/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.SOSCommandResult;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class SOSShell {
    private static Charset SYSTEM_ENCODING;
    private static long DEFAULT_TIMEOUT;

    public static SOSCommandResult executeCommand(String ... command) throws Throwable {
        return SOSShell.executeCommand(DEFAULT_TIMEOUT, command);
    }

    public static SOSCommandResult executeCommand(long timeout, String ... command) throws Throwable {
        String strCommand = String.join((CharSequence)" ", command);
        SOSCommandResult result = new SOSCommandResult(strCommand, SOSShell.getSystemEncoding());
        Process p = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            p = pb.start();
            CompletableFuture<Boolean> out = SOSShell.redirect(p.getInputStream(), result::setStdOut, result.getEncoding());
            CompletableFuture<Boolean> err = SOSShell.redirect(p.getErrorStream(), result::setStdErr, result.getEncoding());
            if (timeout <= 0L) {
                result.setExitCode(p.waitFor());
            } else {
                if (!p.waitFor(timeout, TimeUnit.SECONDS)) {
                    result.setTimeoutExeeded(true);
                }
                result.setExitCode(p.exitValue());
            }
            out.join();
            err.join();
        }
        catch (Throwable e) {
            if (result.isTimeoutExeeded() && timeout > 0L) {
                throw new TimeoutException("Timeout exeeded (" + timeout + "s) for process: '" + strCommand + "'");
            }
            throw e;
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return result;
    }

    private static CompletableFuture<Boolean> redirect(InputStream is, Consumer<String> consumer, Charset charset) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStreamReader isr = new InputStreamReader(is, charset);){
                Boolean bl;
                try (BufferedReader br = new BufferedReader(isr);){
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        consumer.accept(line + System.lineSeparator());
                    }
                    bl = true;
                }
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        });
    }

    private static Charset getSystemEncoding() {
        if (SYSTEM_ENCODING == null) {
            SYSTEM_ENCODING = OsVersion.IS_WINDOWS ? SOSShell.getWindowsEncoding() : Charset.forName("UTF-8");
        }
        return SYSTEM_ENCODING;
    }

    private static Charset getWindowsEncoding() {
        int cp = Kernel32.INSTANCE.GetConsoleCP();
        if (cp == 0) {
            Charset defaultCharset = Charset.defaultCharset();
            System.out.println(String.format("[codepage=%s(%s)] use default charset=%s", cp, SOSShell.getKernel32LastError(), defaultCharset.name()));
            return defaultCharset;
        }
        String name = "cp" + cp;
        if (!Charset.isSupported(name) && !Charset.isSupported(name = "CP" + cp)) {
            String defaultName = Charset.defaultCharset().name();
            System.out.println(String.format("[codepage=%s(charset cp|%s not supported)] use default charset=%s", cp, name, defaultName));
            name = defaultName;
        }
        Charset charset = Charset.forName(name);
        System.out.println(String.format("codepage=%s(charsetName=%s),charset=%s", cp, name, charset.name()));
        return charset;
    }

    private static String getKernel32LastError() {
        try {
            int err = Kernel32.INSTANCE.GetLastError();
            return String.format("Kernel32.GetLastError:err=%s,msg=%s", err, new Win32Exception(err).getMessage());
        }
        catch (Throwable e) {
            return String.format("Exception on get Kernel32.GetLastError:%s", e.toString());
        }
    }

    static {
        DEFAULT_TIMEOUT = 30L;
    }
}

