/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sos.izpack.util.UserValidator;
import com.sos.izpack.util.WindowsAccountValidator;

public class AccountValidator
implements DataValidator {
    private String errorMessageId = "windows.account.validation.error";
    private String warningMessageId = "windows.account.validation.error";
    private boolean defaultAnswer = false;

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        DataValidator.Status status = DataValidator.Status.OK;
        WindowsAccountValidator accountValidator = new WindowsAccountValidator();
        status = accountValidator.validateData(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = accountValidator.getErrorMessageId();
            this.warningMessageId = accountValidator.getWarningMessageId();
            this.defaultAnswer = accountValidator.getDefaultAnswer();
            return status;
        }
        UserValidator userValidator = new UserValidator();
        status = userValidator.validateUser(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = userValidator.getErrorMessageId();
            this.warningMessageId = userValidator.getWarningMessageId();
            this.defaultAnswer = userValidator.getDefaultAnswer();
            return status;
        }
        return status;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.warningMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return this.defaultAnswer;
    }
}

