/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaValidator
extends ProcessHelper
implements DataValidator {
    private String errorMessageId = "java.validation.error";

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return "java.validation.warning";
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        String requiredJavaVersion = idata.getInfo().getJavaVersion();
        idata.setVariable("requiredJavaVersion", requiredJavaVersion);
        idata.setVariable("javaValidationError", "");
        String strJavaHome = idata.getVariable("javaHome");
        if (strJavaHome == null) {
            strJavaHome = "";
        }
        try {
            String workDir = Paths.get("", new String[0]).toRealPath(new LinkOption[0]).toString();
            strJavaHome = this.cutWorkingDir(strJavaHome, workDir);
        }
        catch (IOException workDir) {
            // empty catch block
        }
        if (strJavaHome.length() == 0) {
            return DataValidator.Status.OK;
        }
        if (strJavaHome.equals(idata.getVariable("JAVA_HOME"))) {
            return DataValidator.Status.OK;
        }
        File javaHome = new File(strJavaHome);
        if (!javaHome.exists()) {
            this.errorMessageId = "java.validation.error.exist";
            return DataValidator.Status.ERROR;
        }
        File javaExecutable = null;
        javaExecutable = OsVersion.IS_WINDOWS ? new File(javaHome, "bin\\java.exe") : new File(javaHome, "bin/java");
        if (!javaExecutable.exists()) {
            idata.setVariable("javaValidationError", javaExecutable.getAbsolutePath());
            this.errorMessageId = "java.validation.error.home";
            return DataValidator.Status.ERROR;
        }
        try {
            SOSCommandResult pr = SOSShell.executeCommand(javaExecutable.getAbsolutePath(), "-version");
            Pattern pattern = Pattern.compile(".*\"([0-9._]+)\".*", 40);
            Matcher stdoutMatcher = pattern.matcher(pr.getStdOut());
            Matcher stderrMatcher = pattern.matcher(pr.getStdErr());
            int javaMajorVersion = 0;
            boolean javaVersionFound = false;
            if (stdoutMatcher.find()) {
                javaMajorVersion = this.getJavaMajorVersion(stdoutMatcher.group(1));
                javaVersionFound = true;
            } else if (stderrMatcher.find()) {
                javaMajorVersion = this.getJavaMajorVersion(stderrMatcher.group(1));
                javaVersionFound = true;
            }
            if (javaVersionFound && this.getJavaMajorVersion(requiredJavaVersion) > javaMajorVersion) {
                idata.setVariable("javaValidationError", javaMajorVersion + "");
                this.errorMessageId = "java.validation.error";
                return DataValidator.Status.ERROR;
            }
        }
        catch (Throwable e) {
            idata.setVariable("javaValidationError", "Exception: " + e.getMessage());
            return DataValidator.Status.WARNING;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        return true;
    }

    private String cutWorkingDir(String path, String workDir) {
        if (workDir.equalsIgnoreCase(path)) {
            return "";
        }
        if (path.startsWith(workDir + File.separator + "%")) {
            path = path.substring(workDir.length() + 1);
        }
        if (path.startsWith(workDir + "%")) {
            path = path.substring(workDir.length());
        }
        return path;
    }

    private int getJavaMajorVersion(String version) {
        String[] javaVersions = version.split("\\.");
        String significantNumber = javaVersions[0];
        if (javaVersions.length > 1 && "1".equals(javaVersions[0])) {
            significantNumber = javaVersions[1];
        }
        return Integer.parseInt(significantNumber);
    }
}

