/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class RenameInstallInformation
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        String installInformationName = idata.getVariable("installInformationName");
        Path installPath = Paths.get(idata.getInstallPath(), new String[0]);
        idata.setVariable("renameInstallInformationError", "");
        Path installInformationFile = installPath.resolve(".installationinformation");
        try {
            if (installInformationName != null && !installInformationName.isEmpty() && Files.exists(installInformationFile, new LinkOption[0])) {
                Path dest = installPath.resolve(installInformationName);
                Files.deleteIfExists(dest);
                Files.move(installInformationFile, dest, StandardCopyOption.ATOMIC_MOVE);
            }
        }
        catch (Exception e) {
            idata.setVariable("renameInstallInformationError", e.toString());
        }
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }
}

