/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;

public class WordUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws FileNotFoundException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream("/home/rkrell/Downloads/pentaho-eula-wrap-config-1.0.7-eula.txt"));
            for (String line : WordUtil.wordWrap(in, 80)) {
                System.out.println(line);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String wordWrap(String text, int maxCharsPerLine) {
        return WordUtil.wordWrap(text, maxCharsPerLine, true);
    }

    public static String wordWrap(String text, int maxCharsPerLine, boolean wrapLineFull) {
        StringBuilder sb = new StringBuilder();
        for (String line : WordUtil.wordWrap(new ByteArrayInputStream(text.getBytes()), maxCharsPerLine)) {
            sb.append(line);
            if (line.length() >= maxCharsPerLine && !wrapLineFull) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static List<String> wordWrap(InputStream in, int maxCharsPerLine) {
        ArrayList<String> lines = new ArrayList<String>();
        Scanner scanner = new Scanner(in);
        while (scanner.hasNextLine()) {
            String readLine = scanner.nextLine();
            StringBuilder sb = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(readLine);
            if (tokenizer.countTokens() == 0) {
                lines.add(" ");
            }
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                int len = word.length();
                if (sb.length() > 0) {
                    if (len + 1 > maxCharsPerLine - sb.length()) {
                        lines.add(sb.toString());
                        sb = new StringBuilder();
                    } else if (len < maxCharsPerLine) {
                        sb.append(' ');
                    }
                }
                sb.append(word);
            }
            if (sb.length() <= 0) continue;
            lines.add(sb.toString());
        }
        return lines;
    }
}

