/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.sos.izpack.util.DriverShim;
import com.sos.izpack.util.Install;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public class DBConnectionCallable
implements Callable<Void> {
    private final String classname;
    private final String url;
    private final String user;
    private final String pwd;
    private final String jdbc;
    private URLClassLoader ucl = null;

    public DBConnectionCallable(String classname, String url, String user, String pwd, String jdbc) {
        this.classname = classname;
        this.url = this.getUrl(classname, url);
        this.user = user;
        this.pwd = pwd;
        this.jdbc = jdbc;
    }

    @Override
    public Void call() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, IOException {
        this.getSimpleConnection(this.getDriver());
        return null;
    }

    private String getUrl(String classname, String url) {
        String amp = "?";
        if (url.contains("?")) {
            amp = "&";
        }
        if (classname.contains("maria") && url.contains(":mysql:")) {
            url = url + amp + "permitMysqlScheme";
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getSimpleConnection(Driver driver) throws SQLException {
        Connection conn = null;
        DriverShim driverShim = null;
        try {
            driverShim = new DriverShim(driver);
            DriverManager.registerDriver(driverShim);
            Connection connection = conn = DriverManager.getConnection(this.url, this.user, this.pwd);
            return connection;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (driverShim != null) {
                    DriverManager.deregisterDriver(driverShim);
                }
            }
            catch (Exception exception) {}
            try {
                if (this.ucl != null) {
                    this.ucl.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Driver getDriver() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL uri = null;
        uri = this.jdbc != null && !this.jdbc.isEmpty() ? Paths.get(this.jdbc, new String[0]).toUri().toURL() : Install.getDriverFile(this.classname);
        this.ucl = new URLClassLoader(new URL[]{uri});
        return (Driver)this.ucl.loadClass(this.classname).newInstance();
    }
}

