/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sos.izpack.util.AccessValidator;
import com.sos.izpack.util.HostPortValidator;
import com.sos.izpack.util.SchedulerIdValidator;
import com.sos.izpack.util.UserValidator;
import com.sos.izpack.util.WindowsAccountValidator;

public class NetworkValidator
implements DataValidator {
    private String errorMessageId = "network.validation.error";
    private String warningMessageId = "network.validation.warning";
    private boolean defaultAnswer = false;

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        this.errorMessageId = "network.validation.error";
        this.warningMessageId = "network.validation.warning";
        this.defaultAnswer = false;
        SchedulerIdValidator schedulerIdValidator = new SchedulerIdValidator();
        DataValidator.Status status = schedulerIdValidator.validateData(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = schedulerIdValidator.getErrorMessageId();
            this.warningMessageId = schedulerIdValidator.getWarningMessageId();
            this.defaultAnswer = schedulerIdValidator.getDefaultAnswer();
            return status;
        }
        WindowsAccountValidator accountValidator = new WindowsAccountValidator();
        status = accountValidator.validateData(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = accountValidator.getErrorMessageId();
            this.warningMessageId = accountValidator.getWarningMessageId();
            this.defaultAnswer = accountValidator.getDefaultAnswer();
            return status;
        }
        HostPortValidator hostPortValidator = new HostPortValidator();
        status = hostPortValidator.validateData(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = hostPortValidator.getErrorMessageId();
            this.warningMessageId = hostPortValidator.getWarningMessageId();
            this.defaultAnswer = hostPortValidator.getDefaultAnswer();
            return status;
        }
        AccessValidator accessValidator = new AccessValidator();
        status = accessValidator.validateData(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = accessValidator.getErrorMessageId();
            this.warningMessageId = accessValidator.getWarningMessageId();
            this.defaultAnswer = accessValidator.getDefaultAnswer();
            return status;
        }
        UserValidator userValidator = new UserValidator();
        status = userValidator.validateUser(idata);
        if (status != DataValidator.Status.OK) {
            this.errorMessageId = userValidator.getErrorMessageId();
            this.warningMessageId = userValidator.getWarningMessageId();
            this.defaultAnswer = userValidator.getDefaultAnswer();
            return status;
        }
        return status;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.warningMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return this.defaultAnswer;
    }
}

