/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sos.izpack.util.ClearWorkingDir;
import com.sos.js7.license.check.LicenseCheckHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class SchedulerLicenseValidator
implements DataValidator {
    private String warningMessageId = "license.validation.warning";

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        this.warningMessageId = "license.validation.warning";
        String licenseType = idata.getVariable("licenseOption");
        if (licenseType != null && licenseType.equalsIgnoreCase("GPL")) {
            idata.setVariable("licenseFile", "");
            return DataValidator.Status.OK;
        }
        String licenseFile = ClearWorkingDir.exec("licenseFile", idata);
        if (licenseFile == null || licenseFile != null && !licenseFile.trim().isEmpty()) {
            System.out.println("Processing license file " + licenseFile);
            Path licensePath = Paths.get(licenseFile.trim(), new String[0]);
            if (Files.isRegularFile(licensePath, new LinkOption[0])) {
                try {
                    LicenseCheckHelper.check(licensePath);
                    return DataValidator.Status.OK;
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    System.out.println("Please check your entered license. It seems expired! " + e.toString());
                }
                catch (CertificateException e) {
                    idata.setVariable("licenseFile", "");
                    this.warningMessageId = "license.validation.warning3";
                    System.out.println("Please check your entered license. The file does not appear to be a certificate! " + e.toString());
                }
                catch (Exception e) {
                    System.out.println("Please check your entered license. It seems invalid! " + e.toString());
                }
            } else {
                idata.setVariable("licenseFile", "");
                this.warningMessageId = "license.validation.warning2";
                System.out.println(licensePath.toString() + " is not a file.");
            }
        } else {
            idata.setVariable("licenseFile", "");
            this.warningMessageId = "license.validation.warning2";
        }
        System.out.println("You can continue the installation and add the license file later when indicated.");
        return DataValidator.Status.WARNING;
    }

    @Override
    public String getErrorMessageId() {
        return "license.validation.error";
    }

    @Override
    public String getWarningMessageId() {
        return this.warningMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

