/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.license.check;

import com.sos.js7.license.check.LicenseCheckHelper;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LicenseChecker {
    public boolean checkJocClusterLicenceValid() {
        return this.checkClusterLicenceValid(this.readJocCertificates());
    }

    public boolean checkControllerClusterLicenceValid() {
        return this.checkClusterLicenceValid(this.readControllerCertificates());
    }

    public Date getJocLicenseValidFrom() {
        return this.getJocLicenseValidFrom(this.readJocCertificates());
    }

    public Date getJocLicenseValidFrom(Set<X509Certificate> certificates) {
        boolean anyValid = false;
        HashSet<X509Certificate> sosLicenses = new HashSet<X509Certificate>();
        for (X509Certificate cert : certificates) {
            anyValid = this.checkLicenceIntermediate(cert);
            if (!anyValid || !(anyValid = LicenseCheckHelper.checkLicenceRegisteredId(cert))) continue;
            sosLicenses.add(cert);
        }
        X509Certificate cert = LicenseCheckHelper.getValidOrLatestCertificate(sosLicenses);
        if (cert != null) {
            return cert.getNotBefore();
        }
        return null;
    }

    public Date getJocLicenseValidUntil() {
        return this.getJocLicenseValidUntil(this.readJocCertificates());
    }

    public Date getJocLicenseValidUntil(Set<X509Certificate> certificates) {
        boolean anyValid = false;
        HashSet<X509Certificate> sosLicenses = new HashSet<X509Certificate>();
        for (X509Certificate cert : certificates) {
            anyValid = this.checkLicenceIntermediate(cert);
            if (!anyValid || !(anyValid = LicenseCheckHelper.checkLicenceRegisteredId(cert))) continue;
            sosLicenses.add(cert);
        }
        X509Certificate cert = LicenseCheckHelper.getValidOrLatestCertificate(sosLicenses);
        if (cert != null) {
            return cert.getNotAfter();
        }
        return null;
    }

    public boolean checkClusterLicenceValid(Set<X509Certificate> certificates) {
        boolean anyValid = false;
        if (!certificates.isEmpty()) {
            HashSet<X509Certificate> sosLicenses = new HashSet<X509Certificate>();
            ArrayList<X509Certificate> validLicenses = new ArrayList<X509Certificate>();
            ArrayList<X509Certificate> invalidJs7Certs = new ArrayList<X509Certificate>();
            ArrayList<X509Certificate> invalidJs7Licenses = new ArrayList<X509Certificate>();
            ArrayList<X509Certificate> invalidPeriods = new ArrayList<X509Certificate>();
            for (X509Certificate cert : certificates) {
                anyValid = this.checkLicenceIntermediate(cert);
                if (!anyValid) {
                    invalidJs7Certs.add(cert);
                    System.out.println("License certificate not a JS7 certificate.");
                    System.out.println("DN: " + cert.getSubjectDN().getName());
                    continue;
                }
                anyValid = LicenseCheckHelper.checkLicenceRegisteredId(cert);
                if (!anyValid) {
                    invalidJs7Licenses.add(cert);
                    System.out.println("License not a JS7 license.");
                    System.out.println("DN: " + cert.getSubjectDN().getName());
                    String registeredId = LicenseCheckHelper.getRegisteredId(cert);
                    if (registeredId == null) continue;
                    System.out.println("License: " + registeredId);
                    continue;
                }
                sosLicenses.add(cert);
                anyValid = this.checkLicenceDuration(cert);
                if (!anyValid) {
                    invalidPeriods.add(cert);
                    continue;
                }
                validLicenses.add(cert);
            }
            if (sosLicenses.isEmpty()) {
                System.out.println("No license certificates found.");
                System.out.println("Using Open Source License.");
            } else {
                X509Certificate latest;
                if (!validLicenses.isEmpty()) {
                    latest = LicenseCheckHelper.geLatestValidCertificate(validLicenses);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    System.out.println("using Commercial License. Expiration Date: " + sdf.format(latest.getNotAfter()));
                    return true;
                }
                if (!invalidPeriods.isEmpty()) {
                    latest = LicenseCheckHelper.geLatestInvalidCertificate(invalidPeriods);
                    System.out.println("License validity period failed.");
                    this.checkLicenceDuration(latest, true);
                    return false;
                }
                if (!invalidJs7Licenses.isEmpty()) {
                    System.out.println("License not a JS7 license.");
                    latest = LicenseCheckHelper.geLatestInvalidCertificate(invalidJs7Licenses);
                    System.out.println("DN: " + latest.getSubjectDN().getName());
                    String registeredId = LicenseCheckHelper.getRegisteredId(latest);
                    if (registeredId != null) {
                        System.out.println("License: " + registeredId);
                    }
                    return false;
                }
                if (!invalidJs7Certs.isEmpty()) {
                    latest = LicenseCheckHelper.geLatestInvalidCertificate(invalidJs7Licenses);
                    System.out.println("License certificate not a JS7 certificate.");
                    System.out.println("DN: " + latest.getSubjectDN().getName());
                    return false;
                }
                System.out.println("No license certificates found.");
                System.out.println("Using Open Source License.");
            }
        } else {
            System.out.println("No license certificates found.");
            System.out.println("Using Open Source License.");
        }
        return anyValid;
    }

    private Set<X509Certificate> readControllerCertificates() {
        String configDir = System.getenv("JS7_CONTROLLER_CONFIG_DIR");
        if (configDir == null) {
            configDir = System.getenv("JS7_AGENT_CONFIG_DIR");
        }
        if (configDir == null) {
            System.out.println("Couldn't find 'config' directory.");
        }
        return this.readCertificates(Paths.get(configDir, new String[0]).resolve("license"));
    }

    private Set<X509Certificate> readJocCertificates() {
        Path path = Paths.get(".", new String[0]);
        path = System.getProperty("jetty.base") != null && !System.getProperty("jetty.base").isEmpty() ? Paths.get(System.getProperty("jetty.base"), new String[0]).resolve("resources/joc/license").normalize() : Paths.get(System.getProperty("user.dir"), new String[0]).resolve("resources/joc/license").normalize();
        return this.readCertificates(path);
    }

    public Set<X509Certificate> readCertificates(Path path) {
        Set<X509Certificate> certificates = Collections.emptySet();
        Set filePaths = Collections.emptySet();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                filePaths = Files.walk(path, FileVisitOption.FOLLOW_LINKS).filter(item -> Files.isRegularFile(item, new LinkOption[0])).collect(Collectors.toSet());
            }
            catch (IOException e) {
                System.out.println("Could not read directory: " + path.toString());
            }
            if (filePaths.isEmpty()) {
                System.out.println("No file(s) present in: " + path.toString());
            } else {
                certificates = filePaths.stream().map(item -> this.readCertificate((Path)item)).filter(Objects::nonNull).collect(Collectors.toSet());
                if (certificates.isEmpty()) {
                    System.out.println("No certificate(s) present in: " + path.toString());
                }
            }
        } else {
            System.out.println("Could not read directory: " + path.toString());
        }
        return certificates;
    }

    private X509Certificate readCertificate(Path path) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (CertificateException e) {
            System.out.println("Could not parse certificate from file: " + path.toString());
            return null;
        }
        catch (IOException e) {
            System.out.println("Could not read file: " + path.toString());
            return null;
        }
    }

    private boolean checkLicenceIntermediate(X509Certificate cert) {
        try {
            LicenseCheckHelper.checkLicenceIntermediateWithThrow(cert);
            return true;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            System.out.println("certificate could not be validated against intermediate ca certificate.");
            return false;
        }
    }

    private boolean checkLicenceDuration(X509Certificate cert) {
        return this.checkLicenceDuration(cert, false);
    }

    private boolean checkLicenceDuration(X509Certificate cert, boolean logging) {
        try {
            cert.checkValidity();
            return true;
        }
        catch (CertificateExpiredException e) {
            if (logging) {
                System.out.println("license has expired on: " + cert.getNotAfter());
            }
            return false;
        }
        catch (CertificateNotYetValidException e) {
            if (logging) {
                System.out.println("license not yet valid. Valid from:  " + cert.getNotBefore());
            }
            return false;
        }
    }
}

