/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.AutomatedPanels;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.PrivilegedRunner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;

public class AutomatedInstaller
implements InstallerBase {
    private final AutomatedPanels panels;
    private final AutomatedInstallData installData;
    private RequirementsChecker requirements;
    private UninstallDataWriter uninstallDataWriter;
    private final Locales locales;
    private final Housekeeper housekeeper;

    public AutomatedInstaller(AutomatedPanels panels, AutomatedInstallData installData, Locales locales, RequirementsChecker requirements, UninstallDataWriter uninstallDataWriter, Housekeeper housekeeper) {
        this.panels = panels;
        this.installData = installData;
        this.locales = locales;
        this.requirements = requirements;
        this.uninstallDataWriter = uninstallDataWriter;
        this.housekeeper = housekeeper;
    }

    public void init(String inputFilename, String mediaPath, String[] args) throws Exception {
        PrivilegedRunner runner = new PrivilegedRunner(this.installData.getPlatform());
        if (!runner.hasCorrectPermissions(this.installData.getInfo(), this.installData.getRules())) {
            try {
                runner.relaunchWithElevatedRights(args);
            }
            catch (Exception e) {
                System.out.println(this.installData.getMessages().get("AutomatedInstaller.permissionError", new Object[0]));
            }
            System.exit(0);
        }
        if (inputFilename != null) {
            File input = new File(inputFilename);
            IXMLElement installRecord = this.getXMLData(input);
            this.installData.setInstallationRecord(installRecord);
            this.installData.setAttribute("automatedInstallation", Boolean.TRUE);
            String code = installRecord.getAttribute("langpack", "eng");
            this.locales.setLocale(code);
        }
        this.installData.setMessages(this.locales.getMessages());
        this.installData.setLocale(this.locales.getLocale(), this.locales.getISOCode());
        this.installData.setMediaPath(mediaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstall() throws Exception {
        boolean reboot;
        boolean success;
        block32: {
            success = false;
            if (!this.requirements.check()) {
                System.out.println("[ Automated installation FAILED! ]");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            try {
                IXMLElement installationRecord = this.installData.getInstallationRecord();
                if (installationRecord != null && installationRecord.hasChildren()) {
                    List<IXMLElement> panelRoots = installationRecord.getChildren();
                    for (IXMLElement panelRoot : panelRoots) {
                        String panelId = panelRoot.getAttribute("id");
                        for (AutomatedPanelView panelView : this.panels.getPanelViews()) {
                            if (!panelView.getPanelId().equals(panelId)) continue;
                            success = this.panels.switchPanel(panelView.getIndex(), true);
                            break;
                        }
                        if (success) continue;
                        break;
                    }
                } else {
                    while (this.panels.hasNext() && (success = this.panels.next())) {
                    }
                }
                if (success) {
                    success = this.panels.isValid();
                    if (this.uninstallDataWriter.isUninstallRequired()) {
                        success = this.uninstallDataWriter.write();
                    }
                }
                if (success) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                reboot = false;
                if (!this.installData.isRebootNecessary()) break block32;
                System.out.println("[ There are file operations pending after reboot ]");
            }
            catch (Exception e) {
                boolean reboot2;
                block33: {
                    try {
                        success = false;
                        System.err.println(e.toString());
                        e.printStackTrace();
                        if (success) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        reboot2 = false;
                        if (!this.installData.isRebootNecessary()) break block33;
                        System.out.println("[ There are file operations pending after reboot ]");
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            System.out.println("[ Automated installation done ]");
                        } else {
                            System.out.println("[ Automated installation FAILED! ]");
                        }
                        boolean reboot3 = false;
                        if (this.installData.isRebootNecessary()) {
                            System.out.println("[ There are file operations pending after reboot ]");
                            switch (this.installData.getInfo().getRebootAction()) {
                                case 3: {
                                    reboot3 = true;
                                }
                            }
                            if (reboot3) {
                                System.out.println("[ Rebooting now automatically ]");
                            }
                        }
                        this.housekeeper.shutDown(success ? 0 : 1, reboot3);
                        throw throwable;
                    }
                    switch (this.installData.getInfo().getRebootAction()) {
                        case 3: {
                            reboot2 = true;
                        }
                    }
                    if (reboot2) {
                        System.out.println("[ Rebooting now automatically ]");
                    }
                }
                this.housekeeper.shutDown(success ? 0 : 1, reboot2);
            }
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(success ? 0 : 1, reboot);
    }

    private IXMLElement getXMLData(File input) throws IOException {
        InputStream in = this.transformXMLDatafromVersion4To5(new String(Files.readAllBytes(input.toPath()), StandardCharsets.UTF_8));
        XMLParser parser = new XMLParser(false);
        IXMLElement rtn = parser.parse(in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    private InputStream transformXMLDatafromVersion4To5(String oldXml) {
        return new ByteArrayInputStream(oldXml.replaceAll("</?userInput/?>", "").replaceAll("com\\.izforge\\.izpack\\.panels\\.UserInputPanel", "com.izforge.izpack.panels.userinput.UserInputPanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.HTMLLicencePanel", "com.izforge.izpack.panels.htmllicence.HTMLLicencePanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.TargetPanel", "com.izforge.izpack.panels.target.TargetPanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.InstallPanel", "com.izforge.izpack.panels.install.InstallPanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.ProcessPanel", "com.izforge.izpack.panels.process.ProcessPanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.FinishPanel", "com.izforge.izpack.panels.finish.FinishPanel").replaceAll("com\\.izforge\\.izpack\\.panels\\.UserPathPanel", "com.izforge.izpack.panels.userpath.UserPathPanel").getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        this.panels.writeInstallationRecord(file, uninstallData);
    }
}

