/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class HostPortValidator
implements DataValidator {
    private String errorMessageId = "port.validation.error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataValidator.Status validatePort(int port, String host, InstallData idata) {
        DataValidator.Status status = DataValidator.Status.OK;
        ServerSocket socket = null;
        String msg = "";
        try {
            InetAddress inet = null;
            if (!"0.0.0.0".equals(host)) {
                inet = InetAddress.getByName(host);
            }
            socket = new ServerSocket(port, 0, inet);
            System.out.println("Port " + port + " is available bind to " + host);
        }
        catch (BindException e) {
            System.out.println(e.toString());
            msg = "An application is already running on port " + port + ".\nAre you sure that " + idata.getInfo().getAppName() + " is down?";
            if ("update".equals(idata.getVariable("installMode"))) {
                this.errorMessageId = "port.validation.error.update";
            } else {
                msg = msg + "\nPlease choose another port if necessary.";
            }
            status = DataValidator.Status.ERROR;
            System.out.println(msg);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            idata.setVariable("hostPortValidationError", e.toString());
            this.errorMessageId = "hostport.validation.unknown.error";
            status = DataValidator.Status.ERROR;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return status;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        this.errorMessageId = "port.validation.error";
        String port = idata.getVariable("controllerPort");
        String host = idata.getVariable("controllerHost");
        if ("agent".equals(idata.getVariable("installMode"))) {
            port = idata.getVariable("agentPort");
            host = idata.getVariable("agentHost");
        }
        DataValidator.Status status = DataValidator.Status.OK;
        try {
            int iport;
            if (host == null || host.isEmpty()) {
                host = "0.0.0.0";
            }
            if (port == null || port.isEmpty()) {
                throw new NumberFormatException();
            }
            if (port.indexOf(":") > -1) {
                String[] hostPort = port.split(":", 2);
                port = hostPort[1];
                host = hostPort[0];
                if (host.isEmpty()) {
                    host = "0.0.0.0";
                }
            }
            if ((iport = Integer.parseInt(port)) <= 0 || iport > 65535) {
                throw new NumberFormatException();
            }
            status = this.validatePort(iport, host, idata);
        }
        catch (NumberFormatException e) {
            System.out.println("Port '" + port + "' is invalid.");
            this.errorMessageId = "service.port.valid";
            status = DataValidator.Status.ERROR;
        }
        return status;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return "port.validation.warning";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

