/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sos.izpack.process.JettyJavaOptions;
import com.sos.izpack.process.StartJetty;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.UserValidator;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JettyInstallValidator
implements DataValidator {
    private String errorMessageId = "jettyinstall.validation.error";
    private String warningMessageId = "jettyinstall.validation.error";
    private boolean defaultAnswer = false;

    @Override
    public boolean getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return this.warningMessageId;
    }

    @Override
    public DataValidator.Status validateData(InstallData idata) {
        DataValidator.Status state = DataValidator.Status.OK;
        try {
            UserValidator userValidator;
            Path jettyBaseDir;
            boolean withJettyInstall = "yes".equals(idata.getVariable("withJettyInstall"));
            if (state == DataValidator.Status.OK && (idata.getInstallPath() + File.separator + "jetty").equals(idata.getVariable("jettyBaseDir"))) {
                this.errorMessageId = "jettyinstall.validation.error2";
                state = DataValidator.Status.ERROR;
            }
            if (state == DataValidator.Status.OK && withJettyInstall && "no".equals(idata.getVariable("withRootPermissions"))) {
                for (jettyBaseDir = Paths.get(idata.getVariable("jettyBaseDir"), new String[0]); jettyBaseDir != null; jettyBaseDir = jettyBaseDir.getParent()) {
                    if (Files.notExists(jettyBaseDir, new LinkOption[0])) {
                        continue;
                    }
                    if (Files.isWritable(jettyBaseDir)) break;
                    this.errorMessageId = "jettyinstall.validation.error3";
                    state = DataValidator.Status.ERROR;
                    break;
                }
            }
            if (state == DataValidator.Status.OK && withJettyInstall && (state = (userValidator = new UserValidator()).validateUser(idata)) != DataValidator.Status.OK) {
                this.errorMessageId = userValidator.getErrorMessageId();
                this.warningMessageId = userValidator.getWarningMessageId();
                this.defaultAnswer = userValidator.getDefaultAnswer();
            }
            if (state == DataValidator.Status.OK) {
                if (Install.isAutomatedInstallation.booleanValue()) {
                    String xss = idata.getVariable("jettyOptionXss");
                    String xss2 = idata.getVariable("jettyOptXss");
                    if ((xss == null || xss.isEmpty()) && (xss2 == null || xss2.isEmpty())) {
                        xss = "4000";
                        idata.setVariable("jettyOptionXss", xss);
                        idata.setVariable("jettyOptXss", "-Xss" + xss + "KB");
                    } else if ((xss == null || xss.isEmpty()) && xss2 != null && !xss2.isEmpty()) {
                        idata.setVariable("jettyOptionXss", xss2.replaceAll("\\D", ""));
                    } else {
                        idata.setVariable("jettyOptXss", "-Xss" + xss + "KB");
                    }
                    String xmx = idata.getVariable("jettyOptionXmx");
                    String xmx2 = idata.getVariable("jettyOptXmx");
                    if ((xmx == null || xmx.isEmpty()) && (xmx2 == null || xmx2.isEmpty())) {
                        xmx = "512";
                        idata.setVariable("jettyOptionXmx", xmx);
                        idata.setVariable("jettyOptXmx", "-Xmx" + xmx + "MB");
                    } else if ((xmx == null || xmx.isEmpty()) && xmx2 != null && !xmx2.isEmpty()) {
                        idata.setVariable("jettyOptionXmx", xmx2.replaceAll("\\D", ""));
                    } else {
                        idata.setVariable("jettyOptXmx", "-Xmx" + xmx + "MB");
                    }
                    String xms = idata.getVariable("jettyOptionXms");
                    String xms2 = idata.getVariable("jettyOptXms");
                    if ((xms == null || xms.isEmpty()) && (xms2 == null || xms2.isEmpty())) {
                        xms = "512";
                        idata.setVariable("jettyOptionXms", xms);
                        idata.setVariable("jettyOptXms", "-Xms" + xms + "MB");
                    } else if ((xms == null || xms.isEmpty()) && xms2 != null && !xms2.isEmpty()) {
                        idata.setVariable("jettyOptionXms", xms2.replaceAll("\\D", ""));
                    } else {
                        idata.setVariable("jettyOptXms", "-Xms" + xms + "MB");
                    }
                } else {
                    idata.setVariable("jettyOptionXms", idata.getVariable("jettyOptXms").replaceAll("\\D", ""));
                    idata.setVariable("jettyOptionXmx", idata.getVariable("jettyOptXmx").replaceAll("\\D", ""));
                    idata.setVariable("jettyOptionXss", idata.getVariable("jettyOptXss").replaceAll("\\D", ""));
                }
                JettyJavaOptions jettyOpts = new JettyJavaOptions(idata);
                jettyOpts.readJavaOptionsString(idata.getVariable("jettyOptions"));
                idata.setVariable("jettyOptions", jettyOpts.getOptionsString());
            }
            if (state == DataValidator.Status.OK) {
                state = this.isRunning(idata.getVariable("jettyPort"), idata.getVariable("jettyServiceName"), jettyBaseDir);
            }
        }
        catch (Exception e) {
            System.out.println("JettyInstallValidator: " + e.toString());
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataValidator.Status isRunning(String jettyPort, String serviceName, Path jettyBase) {
        ServerSocket socket = null;
        boolean isAvailable = false;
        try {
            socket = new ServerSocket(Integer.valueOf(jettyPort), 0, InetAddress.getLocalHost());
            if (socket.getLocalPort() > 0) {
                isAvailable = true;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {}
        }
        if (isAvailable) {
            System.out.println("Port " + jettyPort + " is accessible.");
            return DataValidator.Status.OK;
        }
        this.errorMessageId = "jetty.port.validation.error";
        try {
            if (new StartJetty().serviceIsRunning(serviceName, jettyBase)) {
                this.errorMessageId = "jetty.validation.warning.update";
                System.out.println("Please stop JOC!");
                return DataValidator.Status.ERROR;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.out.println("The port " + jettyPort + " is not accessible. \nAre you sure that JOC is down? \nPlease try another port if necessary.");
        return DataValidator.Status.ERROR;
    }
}

