/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessConfigFileHelper;
import com.sos.izpack.util.XmlInfo;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class ConfigureHibernateXml
extends ProcessConfigFileHelper {
    @Override
    protected String getConfigFilename() {
        return "hibernate.cfg.xml";
    }

    @Override
    protected String getConfigDir() {
        return this.idata.getVariable("APPDATA_PATH");
    }

    @Override
    protected String getConfigSubDir() {
        return "resources/joc";
    }

    @Override
    protected void process(File configTmpFile) throws Exception {
    }

    @Override
    protected void process(File hibernateCfg, File hibernateTmpCfg) throws Exception {
        Element dbUrl;
        Element dbDriverElem;
        Element dbDialectElem;
        Element dbPasswordElem;
        XmlInfo hibernateDom = new XmlInfo(hibernateCfg);
        boolean nothingToDo = this.addHikari(hibernateDom);
        boolean driverHasChanged = false;
        Element dbUserElem = hibernateDom.getDBUser();
        if (!this.updateDbElement("databaseUser", dbUserElem)) {
            nothingToDo = false;
        }
        if (!this.updateDbElement("databasePassword", dbPasswordElem = hibernateDom.getDBPassword())) {
            nothingToDo = false;
        }
        if ((dbDialectElem = hibernateDom.getDBDialect()) != null) {
            if (this.idata.getVariable("hibernateDialect") == null || this.idata.getVariable("hibernateDialect").isEmpty()) {
                dbDialectElem.getParentNode().removeChild(dbDialectElem);
            } else if (!this.updateDbElement("hibernateDialect", dbDialectElem)) {
                nothingToDo = false;
            }
        }
        if (!this.updateDbElement("jdbcConnectionDriver", dbDriverElem = hibernateDom.getDBDriverClass())) {
            nothingToDo = false;
            driverHasChanged = true;
        }
        if (!this.updateUrl(dbUrl = hibernateDom.getDBUrl(), driverHasChanged)) {
            nothingToDo = false;
        }
        if (nothingToDo) {
            this.log("... nothing to do", new Object[0]);
        } else {
            this.writeXML(hibernateCfg, hibernateDom.getDom());
        }
        if (hibernateTmpCfg.exists()) {
            hibernateTmpCfg.delete();
        }
    }

    private boolean updateDbElement(String key, Element dbElem) {
        boolean nothingToDo = true;
        String oldValue = dbElem.getTextContent();
        if (this.idata.getVariable(key) != null && !this.idata.getVariable(key).equals(oldValue)) {
            dbElem.setTextContent(this.idata.getVariable(key));
            nothingToDo = false;
            if ("databasePassword".equals(key)) {
                this.log("... %1$s updated %2$s -> %3$s", key, oldValue, "***");
            } else {
                this.log("... %1$s updated %2$s -> %3$s", key, oldValue, dbElem.getTextContent());
            }
        }
        return nothingToDo;
    }

    private boolean updateUrl(Element dbUrl, boolean forceUpdate) {
        boolean nothingToDo = true;
        if ((forceUpdate || dbUrl.getTextContent() == null) && this.idata.getVariable("jdbcConnectionUrl") != null) {
            dbUrl.setTextContent(this.idata.getVariable("jdbcConnectionUrl"));
            this.log("... jdbcConnectionUrl updated -> %1$s", dbUrl.getTextContent());
            return false;
        }
        if (dbUrl.getTextContent() != null) {
            Matcher notMssql;
            String oldValue = dbUrl.getTextContent();
            boolean matcherFound = false;
            Matcher mssql = Pattern.compile("(.*://)([^:]+)(:\\d+)?(.*;databaseName=)([^\\p{Blank};]+)(.*)", 2).matcher(dbUrl.getTextContent());
            if (mssql.find() && !matcherFound) {
                matcherFound = true;
                if (this.idata.getVariable("databaseHost") != null && !this.idata.getVariable("databaseHost").equals(this.nullAsEmpty(mssql.group(3))) || this.idata.getVariable("databasePort") != null && !this.idata.getVariable("databasePort").equals(this.getPort(mssql.group(4))) || this.idata.getVariable("databaseSchema") != null && !this.idata.getVariable("databaseSchema").equals(this.nullAsEmpty(mssql.group(6)))) {
                    dbUrl.setTextContent(mssql.group(1) + this.idata.getVariable("databaseHost") + this.setPort(this.idata.getVariable("databasePort")) + mssql.group(4) + this.idata.getVariable("databaseSchema") + mssql.group(6));
                    this.log("... jdbcConnectionUrl updated %1$s -> %2$s", oldValue, dbUrl.getTextContent());
                    nothingToDo = false;
                }
            }
            if ((notMssql = Pattern.compile("(.*:)(//|@//|//@|@|Tds:)([^:/]+)((?::\\d+)?)(/|:)([^\\p{Blank}:;\\?/]+)(.*)", 2).matcher(dbUrl.getTextContent())).find() && !matcherFound) {
                matcherFound = true;
                if (this.idata.getVariable("databaseHost") != null && !this.idata.getVariable("databaseHost").equals(this.nullAsEmpty(notMssql.group(3))) || this.idata.getVariable("databasePort") != null && !this.idata.getVariable("databasePort").equals(this.getPort(notMssql.group(4))) || this.idata.getVariable("databaseSchema") != null && !this.idata.getVariable("databaseSchema").equals(this.nullAsEmpty(notMssql.group(6)))) {
                    dbUrl.setTextContent(notMssql.group(1) + notMssql.group(2) + this.idata.getVariable("databaseHost") + this.setPort(this.idata.getVariable("databasePort")) + notMssql.group(5) + this.idata.getVariable("databaseSchema") + notMssql.group(7));
                    this.log("... jdbcConnectionUrl updated %1$s -> %2$s", oldValue, dbUrl.getTextContent());
                    nothingToDo = false;
                }
            }
            if ("h2".equals(this.idata.getVariable("databaseConfigurationMethod")) && !matcherFound) {
                this.idata.getVariable("jdbcConnectionUrl");
                if (!oldValue.equals(this.idata.getVariable("jdbcConnectionUrl"))) {
                    dbUrl.setTextContent(this.idata.getVariable("jdbcConnectionUrl"));
                    this.log("... jdbcConnectionUrl updated %1$s -> %2$s", oldValue, dbUrl.getTextContent());
                    nothingToDo = false;
                }
            }
            if (!matcherFound && !this.updateDbElement("jdbcConnectionUrl", dbUrl)) {
                nothingToDo = false;
            }
        }
        return nothingToDo;
    }

    private String nullAsEmpty(String str) {
        return str == null ? "" : str;
    }

    private String getPort(String str) {
        if (str == null) {
            return "";
        }
        return str.replace(":", "");
    }

    private String setPort(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return ":" + str;
    }
}

