/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.util.WindowsRegistry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class SetDefaultTargetPath
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        Path lastInstallP;
        if (OsVersion.IS_UNIX) {
            Path installPathBase = Paths.get("/opt", new String[0]);
            if (!Files.isWritable(installPathBase)) {
                installPathBase = Paths.get(idata.getVariable("USER_HOME"), new String[0]);
            }
            idata.setInstallPath(installPathBase.resolve(idata.getInfo().getInstallationSubPath()).toString());
        }
        String lastInstallPath = null;
        try {
            String appName = idata.getInfo().getAppName();
            String registerUninstaller = idata.getVariable("registerUninstaller");
            if (OsVersion.IS_WINDOWS) {
                WindowsRegistry winReg = new WindowsRegistry();
                lastInstallPath = appName.contains("JS7") ? winReg.readString("HKLM\\SOFTWARE\\SOS\\JS7\\" + appName, "LatestPath") : winReg.readString("HKLM\\SOFTWARE\\SOS\\" + appName, "LatestPath");
            } else if (registerUninstaller != null && registerUninstaller.equals("yes")) {
                Logger l = Logger.getLogger("java.util.prefs");
                l.setLevel(Level.OFF);
                Preferences prefs = Preferences.userRoot();
                if (appName.contains("JS7")) {
                    if (prefs.nodeExists("SOS/JS7/" + appName)) {
                        lastInstallPath = prefs.node("SOS/JS7/" + appName).get("LatestPath", "");
                    }
                } else if (prefs.nodeExists("SOS/" + appName)) {
                    lastInstallPath = prefs.node("SOS/" + appName).get("LatestPath", "");
                }
            }
        }
        catch (Exception appName) {
            // empty catch block
        }
        if (lastInstallPath != null && !lastInstallPath.isEmpty() && (lastInstallP = Paths.get(lastInstallPath, new String[0])) != null && Files.isDirectory(lastInstallP, new LinkOption[0])) {
            Path lastParentInstallP;
            idata.setInstallPath(lastInstallPath);
            if (idata.getVariable("installMode") != null && idata.getVariable("installMode").contains("controller") && (lastParentInstallP = lastInstallP.getParent()) != null) {
                idata.setInstallPath(lastInstallP.getParent().toString());
            }
        }
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }
}

