/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class CreateSymlinks
extends ProcessHelper {
    private boolean nothingToDo = true;

    @Override
    public boolean run(String[] args) throws Exception {
        Path appDataLogDir;
        this.ok = true;
        Path symlink = null;
        Path target = null;
        Path installDir = Paths.get(this.idata.getInstallPath(), new String[0]);
        Path appDataDir = Paths.get(this.idata.getVariable("APPDATA_PATH"), new String[0]);
        Path logDir = Paths.get(this.idata.getVariable("LOGDIR_PATH"), new String[0]);
        Path libPath = installDir.resolve("lib");
        String installDirSymName = "controller_home";
        String appDataDirSymName = "controller_data";
        boolean flgVarLog = logDir.startsWith("/var/log");
        HashMap<Path, Path> paths = new HashMap<Path, Path>();
        int argsLength = args.length;
        for (int i = 0; i < argsLength; i += 2) {
            if (i + 1 >= argsLength) continue;
            symlink = args[i].startsWith("/") ? Paths.get(args[i], new String[0]) : libPath.resolve(args[i]);
            target = args[i + 1].startsWith("/") ? Paths.get(args[i + 1], new String[0]) : libPath.resolve(args[i + 1]);
            if (!Files.exists(target, new LinkOption[0])) continue;
            paths.put(symlink, target);
        }
        boolean flgSetupHasTwoPaths = this.setupHasTwoPaths(installDir, appDataDir);
        if (this.idata.getVariable("installMode") != null) {
            Path configFiles;
            String configDir;
            Path pidFiles;
            String pidFilesDir;
            Path logPathObj;
            String logPath;
            if (this.idata.getVariable("installMode").contains("jade")) {
                installDirSymName = "jade_home";
                appDataDirSymName = "jade_data";
            }
            if (this.idata.getVariable("installMode").contains("joc")) {
                installDirSymName = "joc_home";
                appDataDirSymName = "jetty_base";
            }
            if (this.idata.getVariable("installMode").equals("agent")) {
                installDirSymName = "agent_home";
                appDataDirSymName = "var_" + this.idata.getVariable("agentPort");
                logPath = this.idata.getVariable("logPath");
                if (logPath != null && !logPath.isEmpty() && !(logPathObj = Paths.get(logPath, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(logPathObj, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("logs"), logPathObj);
                }
                if ((pidFilesDir = this.idata.getVariable("pidFilePath")) != null && !pidFilesDir.isEmpty() && !(pidFiles = Paths.get(pidFilesDir, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(pidFiles, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("pidfiles"), pidFiles);
                }
                if ((configDir = this.idata.getVariable("configPath")) != null && !configDir.isEmpty() && !(configFiles = Paths.get(configDir, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(configFiles, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("config"), configFiles);
                }
            }
            if (this.idata.getVariable("installMode").equals("controller")) {
                installDirSymName = "controller_home";
                appDataDirSymName = "var";
                logPath = this.idata.getVariable("logPath");
                if (logPath != null && !logPath.isEmpty() && !(logPathObj = Paths.get(logPath, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(logPathObj, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("logs"), logPathObj);
                }
                if ((pidFilesDir = this.idata.getVariable("pidFilePath")) != null && !pidFilesDir.isEmpty() && !(pidFiles = Paths.get(pidFilesDir, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(pidFiles, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("pidfiles"), pidFiles);
                }
                if ((configDir = this.idata.getVariable("configPath")) != null && !configDir.isEmpty() && !(configFiles = Paths.get(configDir, new String[0])).toAbsolutePath().startsWith(appDataDir) && Files.exists(configFiles, new LinkOption[0])) {
                    paths.put(appDataDir.resolve("config"), configFiles);
                }
            }
        }
        this.writeHeader("Create some symlinks");
        if (flgSetupHasTwoPaths) {
            this.createSymlink(appDataDir.resolve(installDirSymName), installDir);
            this.createSymlink(installDir.resolve(appDataDirSymName), appDataDir);
        }
        if (flgVarLog && !Files.exists(appDataLogDir = appDataDir.resolve("logs"), new LinkOption[0])) {
            this.createSymlink(appDataLogDir, logDir, false);
        }
        for (Path key : paths.keySet()) {
            this.createSymlink(key, (Path)paths.get(key));
        }
        if (this.nothingToDo) {
            this.log("... nothing to do", new Object[0]);
        }
        return this.ok;
    }

    private boolean createSymlink(Path link, Path dest) {
        return this.createSymlink(link, dest, false);
    }

    private boolean createSymlink(Path link, Path dest, boolean useRelativePath) {
        try {
            this.nothingToDo = false;
            if (!Files.exists(dest, new LinkOption[0])) {
                this.log("... trying to create symlink %n%1$s%n    -> %2$s", link.toString(), dest.toString());
                throw new NoSuchFileException(String.format("The symlink target %1$s doesn't exist.", dest.toString()));
            }
            if (!useRelativePath && link.getParent().equals(dest.getParent())) {
                useRelativePath = true;
            }
            if (useRelativePath) {
                try {
                    dest = link.getParent().relativize(dest);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log("... trying to create symlink %n%1$s%n    -> %2$s", link.toString(), dest.toString());
            if (Files.exists(link, LinkOption.NOFOLLOW_LINKS) && Files.isSymbolicLink(link)) {
                Path linkPointsTo = Files.readSymbolicLink(link);
                if (linkPointsTo.toString().equals(dest.toString())) {
                    this.log("... already exists.", new Object[0]);
                    return true;
                }
                try {
                    Files.delete(link);
                }
                catch (NoSuchFileException ee) {
                    this.log("%1$s is a broken symlink (-> %2$s).%nPlease delete it manually and restart the installation.", link.toString(), dest.toString());
                    throw ee;
                }
            }
            if (!Files.exists(link, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createSymbolicLink(link, dest, new FileAttribute[0]);
                    this.log("... done.", new Object[0]);
                }
                catch (FileAlreadyExistsException e) {
                    this.log("... already exists.", new Object[0]);
                }
            } else {
                this.log("A %1$s '%2$s' already exists.%nSymlink cannot be created.", Files.isDirectory(link, LinkOption.NOFOLLOW_LINKS) ? "folder" : "file", link.toString());
            }
        }
        catch (Exception e) {
            this.log(e.getClass().getSimpleName() + ":", new Object[0]);
            this.log(e);
        }
        return true;
    }

    private boolean setupHasTwoPaths(Path installDir, Path appDataDir) {
        try {
            if (Files.isDirectory(installDir, new LinkOption[0]) && Files.isDirectory(appDataDir, new LinkOption[0])) {
                return !appDataDir.toRealPath(new LinkOption[0]).startsWith(installDir.toRealPath(new LinkOption[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

