/*
 | tables for Oracle
 | SOS GmbH, 2021-11-30
*/
 
/* Table for IAM_BLOCKLIST */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_BLOCKLIST';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_BLOCKLIST (
                                "ID"                   NUMBER(10)        NOT NULL,
                                "ACCOUNT_NAME"         NVARCHAR2(255)    NOT NULL,
                                "COMMENT"              NVARCHAR2(255)    NULL,
                                "SINCE"                DATE              NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_BLOCKLIST'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_BLOCKLIST
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/
 

/* Table for IAM_HISTORY */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_HISTORY';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_HISTORY (
                                "ID"                   NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_ID"  NUMBER(10)        DEFAULT 0    NOT NULL,
                                "ACCOUNT_NAME"         NVARCHAR2(255)    NOT NULL,
                                "LOGIN_DATE"           DATE              NOT NULL,
                                "LOGIN_SUCCESS"        NUMBER(1)         DEFAULT 0    NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_HISTORY'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_HISTORY
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_IAMH_ISID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMH_ISID       ON IAM_HISTORY("IDENTITY_SERVICE_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_IAMH_LD';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMH_LD         ON IAM_HISTORY("LOGIN_DATE")';
            END IF;
        END;
    END IF;
END;
/

/* Table for IAM_HISTORY_DETAILS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_HISTORY_DETAILS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_HISTORY_DETAILS (
                                "ID"                     NUMBER(10)        NOT NULL,
                                "IAM_HISTORY_ID"         NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_NAME"  NVARCHAR2(255)    NOT NULL,
                                "MESSAGE"                NVARCHAR2(2000)   NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_HISTORY_DETAILS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_HISTORY_DETAILS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_IAMHD_HID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMHD_HID  ON IAM_HISTORY_DETAILS("IAM_HISTORY_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for IAM_ACCOUNTS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_ACCOUNTS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_ACCOUNTS (
                                "ID"                     NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_ID"    NUMBER(10)        NOT NULL,
                                "ACCOUNT_NAME"           NVARCHAR2(255)    NOT NULL,
                                "ACCOUNT_PASSWORD"       NVARCHAR2(255)    NOT NULL,    
                                "EMAIL"                  NVARCHAR2(255),
                                "FORCE_PASSWORD_CHANGE"  NUMBER(1)         DEFAULT 0    NOT NULL,
                                "DISABLED"               NUMBER(1)         DEFAULT 0    NOT NULL,
                                CONSTRAINT UNIQUE_IAM_A_IN UNIQUE ("IDENTITY_SERVICE_ID","ACCOUNT_NAME"),  
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_ACCOUNTS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_ACCOUNTS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/
 
/* Table for IAM_FIDO2_DEVICES */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_FIDO2_DEVICES';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_FIDO2_DEVICES (
                                "ID"                     NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_ID"    NUMBER(10)        NOT NULL,
                                "ACCOUNT_ID"             NUMBER(10)        NOT NULL,
                                "PUBLIC_KEY"             NVARCHAR2(1024)   NOT NULL,
                                "ALGORITHM"              NVARCHAR2(60)     NOT NULL,
                                "CREDENTIAL_ID"          NVARCHAR2(255),
                                "ORIGIN"                 NVARCHAR2(255)    NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_FIDO2_DEVICES'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_FIDO2_DEVICES
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/
 
/* Table for IAM_ROLES */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_ROLES';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_ROLES (
                                "ID"                    NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_ID"   NUMBER(10)        NOT NULL,
                                "ROLE_NAME"             NVARCHAR2(255)    NOT NULL,
								"ORDERING"              NUMBER(10)        NULL,
                                CONSTRAINT UNIQUE_IAM_R_IN UNIQUE ("IDENTITY_SERVICE_ID","ROLE_NAME"),  
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_ROLES'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_ROLES
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/

/* Table for IAM_ACCOUNT2ROLES */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_ACCOUNT2ROLES';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_ACCOUNT2ROLES (
                                "ID"                    NUMBER(10)        NOT NULL,
                                "ROLE_ID"               NUMBER(10)        NOT NULL,
                                "ACCOUNT_ID"            NUMBER(10)        NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_ACCOUNT2ROLES'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_ACCOUNT2ROLES
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/

/* Table for IAM_PERMISSIONS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_PERMISSIONS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_PERMISSIONS (
                                "ID"                    NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_ID"   NUMBER(10)        NOT NULL,
                                "CONTROLLER_ID"         NVARCHAR2(255) NULL,
                                "ACCOUNT_ID"            NUMBER(10) NULL,                                
                                "ROLE_ID"               NUMBER(10) NULL,                                
                                "ACCOUNT_PERMISSION"    NVARCHAR2(255) NULL,
                                "FOLDER_PERMISSION"     NVARCHAR2(255) NULL,
                                "EXCLUDED"              NUMBER(1)         DEFAULT 0    NOT NULL,
                                "RECURSIVE"             NUMBER(1)         DEFAULT 0    NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_PERMISSIONS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_PERMISSIONS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/
 

/* Table for IAM_IDENTITY_SERVICES */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_IDENTITY_SERVICES';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_IDENTITY_SERVICES (
                                "ID"                     NUMBER(10)        NOT NULL,
                                "IDENTITY_SERVICE_TYPE"  NVARCHAR2(255)    NOT NULL,
                                "IDENTITY_SERVICE_NAME"  NVARCHAR2(255)    NOT NULL,                            
                                "SECOND_FACTOR_IS_ID"    NUMBER(10),                            
                                "AUTHENTICATION_SCHEME"  NVARCHAR2(255)    NOT NULL,                             
                                "SECOND_FACTOR"          NUMBER(1)         DEFAULT 0     NOT NULL, 
                                "ORDERING"               NUMBER(10)        DEFAULT 0     NOT NULL,
                                "REQUIRED"               NUMBER(1)         DEFAULT 0     NOT NULL,
                                "DISABLED"               NUMBER(1)         DEFAULT 0     NOT NULL,
                                CONSTRAINT UNIQUE_IAM_S_N UNIQUE ("IDENTITY_SERVICE_NAME"),  
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_IDENTITY_SERVICES'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_IDENTITY_SERVICES
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/  
 
/* Table for IAM_FIDO2_REGISTRATIONS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_FIDO2_REGISTRATIONS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_FIDO2_REGISTRATIONS (
                               "ID"                  NUMBER(10)        NOT NULL,
                               "EMAIL"               NVARCHAR2(255)    NOT NULL,
                               "IDENTITY_SERVICE_ID" NUMBER(10)        NOT NULL,
                               "ACCOUNT_NAME"        NVARCHAR2(255)    NOT NULL,
                               "TOKEN"               NVARCHAR2(255),
                               "PUBLIC_KEY"          NVARCHAR2(1024),
                               "ALGORITHM"           NVARCHAR2(60),
                               "CREDENTIAL_ID"       NVARCHAR2(255),
                               "ORIGIN"              NVARCHAR2(255),
                               "DEFERRED"            NUMBER(1)         DEFAULT 0     NOT NULL,
                               "CONFIRMED"           NUMBER(1)         DEFAULT 0     NOT NULL,
                               "COMPLETED"           NUMBER(1)         DEFAULT 0     NOT NULL,
                               "CHALLENGE"           NVARCHAR2(255),
                               "CREATED"             DATE              NOT NULL,                                
                               CONSTRAINT UNIQUE_IAM_FIDO2_IID_AN UNIQUE ("IDENTITY_SERVICE_ID","ACCOUNT_NAME","ORIGIN"),                             
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_FIDO2_REGISTRATIONS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_FIDO2_REGISTRATIONS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/  
 
/* Table for IAM_FIDO2_REQUESTS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='IAM_FIDO2_REQUESTS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE IAM_FIDO2_REQUESTS (
                               "ID"                  NUMBER(10)        NOT NULL,
                               "IDENTITY_SERVICE_ID" NUMBER(10)        NOT NULL,
                               "CHALLENGE"           NVARCHAR2(255)    NOT NULL, 
                               "REQUEST_ID"          NVARCHAR2(255)    NOT NULL, 
                               "CREATED"             DATE              NOT NULL,                                
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_IAM_FIDO2_REQUESTS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_IAM_FIDO2_REQUESTS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/  
 
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/

/* Table for DPL_ORDERS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='DPL_ORDERS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE DPL_ORDERS (
                                "ID"                        NUMBER(10)        NOT NULL,
                                "SUBMISSION_HISTORY_ID"     NUMBER(10)        NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)    NOT NULL,
                                "WORKFLOW_NAME"             NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "WORKFLOW_PATH"             NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "WORKFLOW_FOLDER"           NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "ORDER_ID"                  NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "ORDER_NAME"                NVARCHAR2(30)     DEFAULT ''.'' NOT NULL,
                                "SCHEDULE_NAME"             NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "SCHEDULE_PATH"             NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "SCHEDULE_FOLDER"           NVARCHAR2(255)    DEFAULT ''.'' NOT NULL,
                                "CALENDAR_ID"               NUMBER(10)        NOT NULL,
                                "START_MODE"                NUMBER(1)         DEFAULT 0     NOT NULL,
                                "SUBMITTED"                 NUMBER(1)         DEFAULT 0     NOT NULL,
                                "SUBMIT_TIME"               DATE              NULL,
                                "PERIOD_BEGIN"              DATE              NULL,
                                "PERIOD_END"                DATE              NULL,
                                "REPEAT_INTERVAL"           NUMBER(10)        NULL,
                                "PLANNED_START"             DATE              NOT NULL,
                                "EXPECTED_END"              DATE              NULL,
                                "ORDER_PARAMETERISATION"    NVARCHAR2(1000)   NULL,
                                "CREATED"                   DATE              NOT NULL,
                                "MODIFIED"                  DATE              NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DPL_ORDERS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_DPL_ORDERS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
                            
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_O_SHID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_SHID  ON DPL_ORDERS("SUBMISSION_HISTORY_ID")';
            END IF;
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_O_ON';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_ON    ON DPL_ORDERS("ORDER_NAME")';
            END IF;
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_O_OID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_OID   ON DPL_ORDERS("ORDER_ID")';
            END IF;
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_O_PSCID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_PSCID ON DPL_ORDERS("PLANNED_START","CONTROLLER_ID")';
            END IF;
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_O_WN';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_WN    ON DPL_ORDERS("WORKFLOW_NAME")';
            END IF;
        END;
    END IF;
END;
/

/* Table for DPL_SUBMISSIONS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='DPL_SUBMISSIONS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE DPL_SUBMISSIONS (
                                "ID"                    NUMBER(10)        NOT NULL,
                                "CONTROLLER_ID"         NVARCHAR2(100)    NOT NULL,
                                "SUBMISSION_FOR_DATE"   DATE              NOT NULL,
                                "USER_ACCOUNT"          NVARCHAR2(255)    NOT NULL,
                                "CREATED"               DATE              NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DPL_SUBMISSIONS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_DPL_SUBMISSIONS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
                            
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_S_SFDCID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_S_SFDCID  ON DPL_SUBMISSIONS("SUBMISSION_FOR_DATE","CONTROLLER_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for DPL_HISTORY */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='DPL_HISTORY';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE DPL_HISTORY(
                                "ID"                    NUMBER(10)        NOT NULL,
                                "CONTROLLER_ID"         NVARCHAR2(100)    NOT NULL,
                                "SUBMITTED"             NUMBER(1)         DEFAULT 0 NOT NULL,
                                "MESSAGE"               NVARCHAR2(2000)   NULL,
                                "DAILY_PLAN_DATE"       DATE              NOT NULL,
                                "ORDER_ID"              NVARCHAR2(255)    NULL,
                                "WORKFLOW_PATH"         NVARCHAR2(255)    NULL,
                                "WORKFLOW_FOLDER"       NVARCHAR2(255)    NULL,
                                "SCHEDULED_FOR"         DATE              NULL, 
                                "USER_ACCOUNT"          NVARCHAR2(255)    NOT NULL,
                                "SUBMISSION_TIME"       DATE              NOT NULL,
                                "CREATED"               DATE              NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DPL_HISTORY'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_DPL_HISTORY
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
                            
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_H_DPDSCID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_H_DPDSCID   ON DPL_HISTORY("DAILY_PLAN_DATE","SUBMITTED","CONTROLLER_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_H_OID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_H_OID   ON DPL_HISTORY("ORDER_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for DPL_ORDER_VARIABLES */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='DPL_ORDER_VARIABLES';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE DPL_ORDER_VARIABLES(
                                "ID"                    NUMBER(10)        NOT NULL,
                                "CONTROLLER_ID"         NVARCHAR2(100)    NOT NULL,
                                "ORDER_ID"              NVARCHAR2(255)    NOT NULL,
                                "VARIABLE_VALUE"        NCLOB             NOT NULL,
                                "CREATED"               DATE              NOT NULL,
                                "MODIFIED"              DATE              NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DPL_ORDER_VARS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_DPL_ORDER_VARS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
                            
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_DPL_OV_OIDCID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_OV_OIDCID  ON DPL_ORDER_VARIABLES("ORDER_ID","CONTROLLER_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for DPL_PROJECTIONS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='DPL_PROJECTIONS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE DPL_PROJECTIONS(
                                "ID"        NUMBER(6)       NOT NULL,
                                "CONTENT"   BLOB            NOT NULL,
                                "CREATED"   DATE            NOT NULL,
                                PRIMARY KEY ("ID")
                            )'; 
    END IF;
END;
/
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for DEP_HISTORY */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_HISTORY'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_HISTORY (
    "ID"              NUMBER(10)        NOT NULL,
    "ACCOUNT"         NVARCHAR2(100)    NOT NULL,
    "PATH"            NVARCHAR2(255)    NOT NULL,
    "FOLDER"          NVARCHAR2(255)    NOT NULL,
    "NAME"            NVARCHAR2(255)    DEFAULT '''' NOT NULL,
    "TITLE"           NVARCHAR2(255)    NULL,
    "TYPE"            NUMBER(3)         NOT NULL,
    "INV_CID"         NUMBER(10)        NOT NULL,
    "INV_IID"         NUMBER(10)        NOT NULL,   /* Inventory Instance ID */
    "CONTROLLER_ID"   NVARCHAR2(100)    NOT NULL,
    "CONTENT"         NCLOB             NOT NULL,
    "INV_CONTENT"     NCLOB             DEFAULT '''' NOT NULL,
    "SIGNATURE"       NVARCHAR2(2000)   NOT NULL,
    "COMMIT_ID"       NVARCHAR2(255)    NULL,
    "VERSION"         NVARCHAR2(50)     NULL,
    "OPERATION"       NUMBER(1)         NULL,       /* UPDATE, DELETE */
    "STATE"           NUMBER(1)         NOT NULL,   /* DEPLOYED, NOT_DEPLOYED */
    "ERROR_MESSAGE"   NVARCHAR2(255)    NULL,       /* ERROR MESSAGE */
    "DEPLOYMENT_DATE" DATE              NOT NULL,
    "DELETED_DATE"    DATE              NULL,
    "AUDITLOG_ID"     NUMBER(10)        NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_HIS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_HIS
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DH_P'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DH_P      ON DEP_HISTORY("PATH")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DH_N'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DH_N      ON DEP_HISTORY("NAME")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DH_F'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DH_F      ON DEP_HISTORY("FOLDER")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DH_INVCID'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DH_INVCID ON DEP_HISTORY("INV_CID")
'; END IF; END;
/



/* Table for DEP_KEYS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_KEYS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_KEYS (
    "ID"              NUMBER(10)        NOT NULL,
    "KEY_TYPE"        NUMBER(3)         NOT NULL, /* PRIVATE, PUBLIC, X.509 */ 
    "KEY_ALG"         NUMBER(3)         NOT NULL, /* PGP, RSA, ECDSA */
    "KEY"             VARCHAR2(4000)    NULL,     /* non unicode - VARCHAR2 data type */
    "CERTIFICATE"     VARCHAR2(4000)    NULL,     /* X.509 Certificate*/
    "ACCOUNT"         NVARCHAR2(255)    NOT NULL,
    "SECLVL"          NUMBER(3)         DEFAULT 0 NOT NULL,
    CONSTRAINT DEP_K_UNIQUE UNIQUE ("ACCOUNT", "KEY_TYPE", "SECLVL"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_K'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_K
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DK_A'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DK_A      ON DEP_KEYS("ACCOUNT")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DK_SL'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DK_SL      ON DEP_KEYS("SECLVL")
'; END IF; END;
/



/* Table for DEP_SIGNATURES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_SIGNATURES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_SIGNATURES (
    "ID"              NUMBER(10)        NOT NULL,
    "INV_CID"         NUMBER(10)        NULL, 
    "DEP_HID"         NUMBER(10)        NULL,
    "SIGNATURE"       NVARCHAR2(2000)   NOT NULL,
    "ACCOUNT"         NVARCHAR2(255)    NOT NULL,
    "MODIFIED"        DATE              NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_SIG'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_SIG
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DS_A'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DS_A      ON DEP_SIGNATURES("ACCOUNT")
'; END IF; END;
/



/* Table for DEP_VERSIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_VERSIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_VERSIONS (
    "ID"              NUMBER(10)        NOT NULL,
    "INV_CID"         NUMBER(10)        NULL, 
    "DEP_HID"         NUMBER(10)        NULL,
    "VERSION"         NVARCHAR2(100)    NOT NULL,
    "MODIFIED"        DATE              NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_VER'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_VER
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_DV_V'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_DV_V      ON DEP_VERSIONS("VERSION")
'; END IF; END;
/



/* Table for DEP_COMMIT_IDS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_COMMIT_IDS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_COMMIT_IDS (
    "ID"              NUMBER(10)        NOT NULL,
    "INV_CID"         NUMBER(10)        NULL, 
    "DEP_HID"         NUMBER(10)        NULL,
    "CFG_PATH"        NVARCHAR2(255)    NOT NULL,
    "COMMIT_ID"       NVARCHAR2(255)    NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_COM'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_COM
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table for DEP_SUBMISSIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='DEP_SUBMISSIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE DEP_SUBMISSIONS (
    "ID"              NUMBER(10)        NOT NULL,
    "DEP_HID"         NUMBER(10)        NOT NULL,
    "ACCOUNT"         NVARCHAR2(100)    NOT NULL,
    "FOLDER"          NVARCHAR2(255)    NOT NULL,
    "PATH"            NVARCHAR2(255)    NOT NULL,
    "TYPE"            NUMBER(3)         NOT NULL,
    "INV_CID"         NUMBER(10)        NOT NULL,
    "INV_IID"         NUMBER(10)        NOT NULL,   /* Inventory Instance ID */
    "CONTROLLER_ID"   NVARCHAR2(100)    NOT NULL,
    "CONTENT"         NCLOB             NOT NULL,
    "SIGNATURE"       NVARCHAR2(2000)   NOT NULL,
    "COMMIT_ID"       NVARCHAR2(255)    NULL,
    "VERSION"         NVARCHAR2(50)     NULL,
    "OPERATION"       NUMBER(1)         NULL,       /* UPDATE, DELETE */
    "CREATED"         DATE              NOT NULL,
    "DELETED_DATE"    DATE              NULL,
    CONSTRAINT DEP_SUB_UNIQUE UNIQUE ("PATH", "CONTROLLER_ID", "COMMIT_ID", "CREATED"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_DEP_SUB'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_DEP_SUB
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/
/*
 | tables for Oracle
 | SOS GmbH, 2024-05-22
*/


/* Table for ENC_CERTIFICATES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='ENC_CERTIFICATES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE ENC_CERTIFICATES (
    "ALIAS"                 NVARCHAR2(255)  NOT NULL,
    "CERT"                  VARCHAR2(4000)  NOT NULL, /* non unicode - VARCHAR2 data type, X.509 Certificate*/
    "PK_PATH"               NVARCHAR2(255)  NULL,
    PRIMARY KEY ("ALIAS")
)
'; END IF; END;
/

/* Table for ENC_CERTIFICATES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='ENC_AGENT_CERTIFICATES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE ENC_AGENT_CERTIFICATES (
    "AGENT_ID"              NVARCHAR2(255)  NOT NULL,
    "CERT_ALIAS"            NVARCHAR2(255)  NOT NULL,  /* PK of ENC_CERTIFICATES */
    PRIMARY KEY ("AGENT_ID", "CERT_ALIAS")
)
'; END IF; END;
/

/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for HISTORY_CONTROLLERS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_CONTROLLERS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_CONTROLLERS (
                                "READY_EVENT_ID"            NUMBER(16)      NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)  NOT NULL,
                                "URI"                       NVARCHAR2(255)  NOT NULL,
                                "TIMEZONE"                  NVARCHAR2(100)  NOT NULL,
                                "TOTAL_RUNNING_TIME"        NUMBER(16)      NOT NULL, /* in milliseconds */
                                "READY_TIME"                DATE            NOT NULL,
                                "SHUTDOWN_TIME"             DATE            NULL,
                                "LAST_KNOWN_TIME"           DATE            NULL,
                                "CREATED"                   DATE            NOT NULL,
                                PRIMARY KEY ("READY_EVENT_ID","CONTROLLER_ID")
                            )'; 
    END IF; 
END;
/

/* Table for HISTORY_AGENTS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_AGENTS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_AGENTS (
                                "READY_EVENT_ID"            NUMBER(16)      NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)  NOT NULL,
                                "AGENT_ID"                  NVARCHAR2(255)  NOT NULL,
                                "URI"                       NVARCHAR2(255)  NOT NULL,
                                "TIMEZONE"                  NVARCHAR2(100)  NOT NULL,
                                "READY_TIME"                DATE            NOT NULL,
                                "COUPLING_FAILED_TIME"      DATE            NULL,
                                "COUPLING_FAILED_MESSAGE"   NVARCHAR2(500)  NULL,
                                "SHUTDOWN_TIME"             DATE            NULL,
                                "LAST_KNOWN_TIME"           DATE            NULL,
                                "CREATED"                   DATE            NOT NULL,
                                PRIMARY KEY ("READY_EVENT_ID","CONTROLLER_ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HA_AID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HA_AID ON HISTORY_AGENTS("AGENT_ID")';
            END IF;
        END;
    END IF; 
END;
/

/* Table for HISTORY_ORDERS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_ORDERS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_ORDERS (
                                "ID"                        NUMBER(19)          NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)      NOT NULL,
                                "ORDER_ID"                  NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_PATH"             NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_VERSION_ID"       NVARCHAR2(255)      NOT NULL,   /* #2019-06-13T08:43:29Z */
                                "WORKFLOW_POSITION"         NVARCHAR2(255)      NOT NULL,   /* 1#fork_1#0 */
                                "WORKFLOW_FOLDER"           NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_NAME"             NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_TITLE"            NVARCHAR2(255)      NULL,       
                                "MAIN_PARENT_ID"            NUMBER(19)          NOT NULL,   /* HISTORY_ORDERS.ID of the main order */
                                "PARENT_ID"                 NUMBER(19)          NOT NULL,   /* HISTORY_ORDERS.ID of the parent order */
                                "PARENT_ORDER_ID"           NVARCHAR2(255)      NOT NULL,   /* HISTORY_ORDERS.ORDER_ID */
                                "HAS_CHILDREN"              NUMBER(1)           NOT NULL,
                                "RETRY_COUNTER"             NUMBER(10)          NOT NULL,
                                "NAME"                      NVARCHAR2(255)      NOT NULL,   /* orderId or branchId by fork */
                                "START_CAUSE"               NVARCHAR2(50)       NOT NULL,   /* order, fork, file_trigger, setback, unskip, unstop */
                                "START_TIME_SCHEDULED"      DATE                NULL,       
                                "START_TIME"                DATE                NOT NULL,
                                "START_WORKFLOW_POSITION"   NVARCHAR2(255)      NOT NULL,
                                "START_EVENT_ID"            NUMBER(16)          NOT NULL,   /* OrderStarted eventId */
                                "START_VARIABLES"           NCLOB               NULL,       
                                "CURRENT_HOS_ID"            NUMBER(19)          NOT NULL,   /* HISTORY_ORDER_STEPS.ID */
                                "END_TIME"                  DATE                NULL,
                                "END_WORKFLOW_POSITION"     NVARCHAR2(255)      NULL,
                                "END_EVENT_ID"              NUMBER(16)          NULL,       /* OrderFinisched eventId */
                                "END_HOS_ID"                NUMBER(19)          NOT NULL,   /* HISTORY_ORDER_STEPS.ID */
                                "END_RETURN_CODE"           NUMBER(10)          NULL,
                                "END_MESSAGE"               NVARCHAR2(500)      NULL,    
                                "SEVERITY"                  NUMBER(1)           NOT NULL,   /* 0,1,2 */
                                "STATE"                     NUMBER(3)           NOT NULL,   
                                "STATE_TIME"                DATE                NOT NULL,
                                "STATE_TEXT"                NVARCHAR2(255)      NULL,       
                                "HAS_STATES"                NUMBER(3)           NOT NULL,   /* has entries in HISTORY_ORDER_STATES */
                                "ERROR"                     NUMBER(3)           NOT NULL,
                                "ERROR_STATE"               NVARCHAR2(20)       NULL,       /*  failed, disrupted ... - event outcome*/
                                "ERROR_REASON"              NVARCHAR2(50)       NULL,       /*  other ... - event outcome*/
                                "ERROR_RETURN_CODE"         NUMBER(10)          NULL,
                                "ERROR_CODE"                NVARCHAR2(50)       NULL,       
                                "ERROR_TEXT"                NVARCHAR2(500)      NULL,       
                                "LOG_ID"                    NUMBER(19)          NOT NULL,   /* HISTORY_LOGS.ID */
                                "CONSTRAINT_HASH"           NCHAR(64)           NOT NULL,   /* hash from "CONTROLLER_ID", "ORDER_ID"*/
                                "CREATED"                   DATE                NOT NULL,
                                "MODIFIED"                  DATE                NOT NULL,
                                CONSTRAINT UNIQUE_HO_CH UNIQUE ("CONSTRAINT_HASH"), /* used by history*/
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_HISTORY_O'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_HISTORY_O
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HO_OID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_OID      ON HISTORY_ORDERS("ORDER_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HO_WPATH';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_WPATH     ON HISTORY_ORDERS("WORKFLOW_PATH")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HO_WNAME';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_WNAME    ON HISTORY_ORDERS("WORKFLOW_NAME")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HO_STIME_PID_SY_CID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_STIME_PID_SY_CID ON HISTORY_ORDERS("START_TIME","PARENT_ID","SEVERITY","CONTROLLER_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HO_LID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_LID      ON HISTORY_ORDERS("LOG_ID")';
            END IF;
        END;
    END IF; 
END;
/

/* Table for HISTORY_ORDER_STATES */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_ORDER_STATES';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_ORDER_STATES (
                                "ID"                        NUMBER(19)      NOT NULL,
                                "HO_MAIN_PARENT_ID"         NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.MAIN_PARENT_ID */
                                "HO_PARENT_ID"              NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.PARENT_ID */
                                "HO_ID"                     NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.ID */
                                "STATE"                     NUMBER(3)       NOT NULL,   
                                "STATE_TIME"                DATE            NOT NULL,
                                "STATE_EVENT_ID"            NCHAR(16)       NOT NULL,   
                                "STATE_CODE"                NVARCHAR2(50)   NULL,
                                "STATE_TEXT"                NVARCHAR2(255)  NULL,
                                "CREATED"                   DATE            NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_HISTORY_OSTATES'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_HISTORY_OSTATES
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTATES_HOID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTATES_HOID   ON HISTORY_ORDER_STATES("HO_ID")';
            END IF;
        END;
    END IF; 
END;
/

/* Table for HISTORY_ORDER_STEPS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_ORDER_STEPS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_ORDER_STEPS (
                                "ID"                        NUMBER(19)          NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)      NOT NULL,
                                "ORDER_ID"                  NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_PATH"             NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_VERSION_ID"       NVARCHAR2(255)      NOT NULL,   /* #2019-06-13T08:43:29Z */
                                "WORKFLOW_POSITION"         NVARCHAR2(255)      NOT NULL,   /* 1#fork_1#3 */
                                "WORKFLOW_FOLDER"           NVARCHAR2(255)      NOT NULL,
                                "WORKFLOW_NAME"             NVARCHAR2(255)      NOT NULL,
                                "HO_MAIN_PARENT_ID"         NUMBER(19)          NOT NULL,   /* HISTORY_ORDERS.MAIN_PARENT_ID */
                                "HO_ID"                     NUMBER(19)          NOT NULL,   /* HISTORY_ORDERS.ID */
                                "POSITION"                  NUMBER(10)          NOT NULL,   /* 3 - last position from WORKFLOW_POSITION */
                                "RETRY_COUNTER"             NUMBER(10)          NOT NULL,
                                "JOB_NAME"                  NVARCHAR2(255)      NOT NULL,
                                "JOB_LABEL"                 NVARCHAR2(255)      NOT NULL,
                                "JOB_TITLE"                 NVARCHAR2(255)      NULL,       
                                "JOB_NOTIFICATION"          NVARCHAR2(1000)     NULL,
                                "CRITICALITY"               NUMBER(3)           NOT NULL,
                                "AGENT_ID"                  NVARCHAR2(255)      NOT NULL,
                                "AGENT_NAME"                NVARCHAR2(255)      NULL,
                                "AGENT_URI"                 NVARCHAR2(255)      NOT NULL,
                                "SUBAGENT_CLUSTER_ID"       NVARCHAR2(255)      NULL,
                                "START_CAUSE"               NVARCHAR2(50)       NOT NULL,   /* order, file_trigger, setback, unskip, unstop */
                                "START_TIME"                DATE                NOT NULL,
                                "START_EVENT_ID"            NUMBER(16)          NOT NULL,   /* ProcessingStarted eventId */
                                "START_VARIABLES"           NCLOB               NULL,       /*  */
                                "END_TIME"                  DATE                NULL,
                                "END_EVENT_ID"              NUMBER(16)          NULL,       /* Processed eventId */
                                "END_VARIABLES"             NCLOB               NULL,                          
                                "RETURN_CODE"               NUMBER(10)          NULL,
                                "SEVERITY"                  NUMBER(1)           NOT NULL,   /* 0,1,2 */
                                "ERROR"                     NUMBER(3)           NOT NULL,   
                                "ERROR_STATE"               NVARCHAR2(20)       NULL,       /* failed, disrupted ... - event outcome*/
                                "ERROR_REASON"              NVARCHAR2(50)       NULL,       /* other ... - event outcome*/
                                "ERROR_CODE"                NVARCHAR2(50)       NULL,       
                                "ERROR_TEXT"                NVARCHAR2(500)      NULL,       
                                "LOG_ID"                    NUMBER(19)          NOT NULL,   /* HISTORY_LOGS.ID */
                                "CONSTRAINT_HASH"           NCHAR(64)           NOT NULL,   /* hash from "CONTROLLER_ID", "ORDER_ID", "WORKFLOW_POSITION"*/
                                "CREATED"                   DATE                NOT NULL,
                                "MODIFIED"                  DATE                NOT NULL,
                                CONSTRAINT UNIQUE_HOSTEPS_CH UNIQUE ("CONSTRAINT_HASH"),    /* used by history*/
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_HISTORY_OSTEPS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_HISTORY_OSTEPS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_STIME_SY_CID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_STIME_SY_CID    ON HISTORY_ORDER_STEPS("START_TIME","SEVERITY","CONTROLLER_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_HOID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_HOID        ON HISTORY_ORDER_STEPS("HO_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_HOMPID_WPOS';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_HOMPID_WPOS ON HISTORY_ORDER_STEPS("HO_MAIN_PARENT_ID","WORKFLOW_POSITION")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_WPATH';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_WPATH       ON HISTORY_ORDER_STEPS("WORKFLOW_PATH")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_WNAME';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_WNAME       ON HISTORY_ORDER_STEPS("WORKFLOW_NAME")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HOSTEPS_CY_JN';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_CY_JN       ON HISTORY_ORDER_STEPS("CRITICALITY","JOB_NAME")';
            END IF;
        END;
    END IF; 
END;
/

/* Table for HISTORY_LOGS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_LOGS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_LOGS (
                                "ID"                        NUMBER(19)      NOT NULL,
                                "CONTROLLER_ID"             NVARCHAR2(100)  NOT NULL,
                                "HO_MAIN_PARENT_ID"         NUMBER(19)      NOT NULL,  /* HISTORY_ORDERS.MAIN_PARENT_ID */
                                "HO_ID"                     NUMBER(19)      NOT NULL,  /* HISTORY_ORDERS.ID */
                                "HOS_ID"                    NUMBER(19)      NOT NULL,  /* HISTORY_ORDER_STEPS.ID */
                                "COMPRESSED"                NUMBER(1)       NOT NULL,
                                "FILE_BASENAME"             NVARCHAR2(255)  NOT NULL,
                                "FILE_SIZE_UNCOMPRESSED"    NUMBER(10)      NOT NULL,
                                "FILE_LINES_UNCOMPRESSED"   NUMBER(10)      NOT NULL,
                                "FILE_CONTENT"              BLOB            NOT NULL,
                                "CREATED"                   DATE            NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_HISTORY_L'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_HISTORY_L
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;

        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HLOGS_HOID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HLOGS_HOID  ON HISTORY_LOGS("HO_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_HLOGS_HOMPID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_HLOGS_HOMPID  ON HISTORY_LOGS("HO_MAIN_PARENT_ID")';
            END IF;
        END;
    END IF; 
END;
/

/* Table for HISTORY_ORDER_TAGS */
DECLARE table_exist number;
BEGIN
SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='HISTORY_ORDER_TAGS';
    IF (table_exist = 0) THEN
        EXECUTE IMMEDIATE   'CREATE TABLE HISTORY_ORDER_TAGS (
                                "ID"                        NUMBER(19)      NOT NULL,
                                "HO_ID"                     NUMBER(19)      NOT NULL,  /* HISTORY_ORDERS.ID */
                                "CONTROLLER_ID"             NVARCHAR2(100)  NOT NULL,
                                "ORDER_ID"                  NVARCHAR2(255)  NOT NULL,
                                "TAG_NAME"                  NVARCHAR2(255)  NOT NULL,
                                "ORDERING"                  NUMBER(10)      NOT NULL,
                                "GROUP_ID"                  NUMBER(10)      DEFAULT 0 NOT NULL,
                                "START_TIME"                DATE            NOT NULL,
                                "DAILY_PLAN_DATE"           DATE            NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_HISTORY_OTAGS'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_HISTORY_OTAGS
                                        INCREMENT BY 1
                                        START WITH 1
                                        MAXVALUE 9999999999999999999
                                        MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF; 
END;
/
/* HISTORY_ORDER_STEPS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'START_VARIABLES' AND upper(data_type)='NCLOB';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS RENAME COLUMN "START_VARIABLES" TO "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS ADD "START_VARIABLES" NCLOB NULL';
        EXECUTE IMMEDIATE 'UPDATE HISTORY_ORDER_STEPS SET "START_VARIABLES" = "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS DROP COLUMN "START_VARIABLES_OLD"';
    END IF;
END;
/

COMMIT;
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for INV_OPERATING_SYSTEMS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_OPERATING_SYSTEMS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_OPERATING_SYSTEMS (
    "ID"                      NUMBER(10)        NOT NULL,
    "HOSTNAME"                NVARCHAR2(100)    NOT NULL,
    "NAME"                    NVARCHAR2(50)     NULL,
    "ARCHITECTURE"            NVARCHAR2(255)    NULL,
    "DISTRIBUTION"            NVARCHAR2(255)    NULL,
    "MODIFIED"                DATE              NOT NULL,
    CONSTRAINT UNIQUE_IOS_HOST UNIQUE ("HOSTNAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_OS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_OS
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table for INV_JS_INSTANCES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_JS_INSTANCES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_JS_INSTANCES (
    "ID"                    NUMBER(10)     NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100) NOT NULL,
    "SECURITY_LEVEL"        NUMBER(1)      DEFAULT 0 NOT NULL, /* 0=LOW, 1=MEDIUM, 2=HIGH */
    "URI"                   NVARCHAR2(255) NOT NULL,
    "CLUSTER_URI"           NVARCHAR2(255) NULL,
    "OS_ID"                 NUMBER(10)     NOT NULL,
    "VERSION"               NVARCHAR2(30)  NULL,
    "JAVA_VERSION"          NVARCHAR2(30)  NULL,
    "STARTED_AT"            DATE           NULL,
    "TITLE"                 NVARCHAR2(30)  NULL,
    "IS_CLUSTER"            NUMBER(1)      DEFAULT 0 NOT NULL, /* 0=standalone, 1=cluster */
    "IS_PRIMARY"            NUMBER(1)      DEFAULT 1 NOT NULL, /* 1=primary, 0=backup */
    "CERTIFICATE"           VARCHAR2(4000) NULL,     /* non unicode - VARCHAR2 data type, X.509 Certificate*/
    "MODIFIED"              DATE           NOT NULL,
    CONSTRAINT UNIQUE_IJI_CCP UNIQUE ("CONTROLLER_ID", "IS_CLUSTER", "IS_PRIMARY"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_JI'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_JI
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_IJI_CID'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_IJI_CID      ON INV_JS_INSTANCES ("CONTROLLER_ID")
'; END IF; END;
/



/* Table for INV_AGENT_INSTANCES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_AGENT_INSTANCES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_AGENT_INSTANCES (
    "ID"                    NUMBER(10)      NOT NULL,
    "AGENT_ID"              NVARCHAR2(255)  NOT NULL, /* (technical) agentName for the Controller in Job configuration. Cannot overwritten */
    "AGENT_NAME"            NVARCHAR2(255)  NOT NULL, /* (displayed) agentName for JOC in Job configuration */
    "URI"                   NVARCHAR2(255)  NOT NULL,
    "PROCESS_LIMIT"         NUMBER(10)      NULL,
    "ORDERING"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "HIDDEN"                NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "DISABLED"              NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "DEPLOYED"              NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "IS_WATCHER"            NUMBER(1)       DEFAULT 0 NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NOT NULL,
    "OS_ID"                 NUMBER(10)      NOT NULL,
    "TITLE"                 NVARCHAR2(255)  NULL,
    "VERSION"               NVARCHAR2(30)   NULL,
    "JAVA_VERSION"          NVARCHAR2(30)   NULL,
    "CERTIFICATE"           VARCHAR2(4000)  NULL,     /* non unicode - VARCHAR2 data type, X.509 Certificate*/
    "STARTED_AT"            DATE            NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IAI_A UNIQUE ("AGENT_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_AI'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_AI
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table for INV_AGENT_NAME_ALIASES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_AGENT_NAME_ALIASES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_AGENT_NAME_ALIASES (
    "AGENT_ID"      NVARCHAR2(255)  NOT NULL, /* (technical) agentName for the Controller in Jobs configuration. Cannot overwritten*/
    "AGENT_NAME"    NVARCHAR2(255)  NOT NULL, /* (displayed) agentName for JOC in Jobs configuration */
    PRIMARY KEY ("AGENT_ID", "AGENT_NAME")
)
'; END IF; END;
/


/* Table INV_SUBAGENT_INSTANCES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_SUBAGENT_INSTANCES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_SUBAGENT_INSTANCES (
    "ID"                    NUMBER(10)      NOT NULL,
    "SUB_AGENT_ID"          NVARCHAR2(255)  NOT NULL,
    "AGENT_ID"              NVARCHAR2(255)  NOT NULL,
    "URI"                   NVARCHAR2(255)  NOT NULL,
    "IS_DIRECTOR"           NUMBER(1)       DEFAULT 0 NOT NULL, /* 0=No director, 1=primary director, 2=standby director */
    "ORDERING"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "DISABLED"              NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "DEPLOYED"              NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "IS_WATCHER"            NUMBER(1)       DEFAULT 0 NOT NULL,
    "TITLE"                 NVARCHAR2(255)   NULL,
    "OS_ID"                 NUMBER(10)      DEFAULT 0 NOT NULL,
    "VERSION"               NVARCHAR2(30)   NULL,
    "JAVA_VERSION"          NVARCHAR2(30)   NULL,
    "CERTIFICATE"           VARCHAR2(4000)  NULL,     /* non unicode - VARCHAR2 data type, X.509 Certificate*/
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_ISI_S UNIQUE ("SUB_AGENT_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_SAI'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_SAI
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table INV_SUBAGENT_CLUSTERS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_SUBAGENT_CLUSTERS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_SUBAGENT_CLUSTERS (
    "ID"                    NUMBER(10)      NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NOT NULL,
    "AGENT_ID"              NVARCHAR2(255)  NOT NULL,
    "SUBAGENT_CLUSTER_ID"   NVARCHAR2(255)  NOT NULL,
    "TITLE"                 NVARCHAR2(255)  NULL,
    "DEPLOYED"              NUMBER(1)       DEFAULT 0 NOT NULL, /* boolean */
    "ORDERING"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "MODIFIED"              DATE            NOT NULL,    
    CONSTRAINT UNIQUE_ISC_CAC UNIQUE ("CONTROLLER_ID", "SUBAGENT_CLUSTER_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_SAC'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_SAC
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table INV_SUBAGENT_CLUSTER_MEMBERS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_SUBAGENT_CLUSTER_MEMBERS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_SUBAGENT_CLUSTER_MEMBERS (
    "ID"                    NUMBER(10)      NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NOT NULL,
    "SUBAGENT_CLUSTER_ID"   NVARCHAR2(255)  NOT NULL,
    "SUBAGENT_ID"           NVARCHAR2(255)  NOT NULL,
    "PRIORITY"              NVARCHAR2(255)  NOT NULL,
    "MODIFIED"              DATE            NOT NULL,    
    CONSTRAINT UNIQUE_ISCM_CCS UNIQUE ("CONTROLLER_ID", "SUBAGENT_CLUSTER_ID", "SUBAGENT_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_SACM'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_SACM
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table for INV_CONFIGURATIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_CONFIGURATIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_CONFIGURATIONS (
    "ID"                    NUMBER(10)           NOT NULL,
    "TYPE"                  NUMBER(3)            NOT NULL,   /* com.sos.joc.model.inventory.ConfigurationType */
    "PATH"                  NVARCHAR2(255)       NOT NULL,
    "NAME"                  NVARCHAR2(255)       NOT NULL,
    "FOLDER"                NVARCHAR2(255)       NOT NULL,
    "TITLE"                 NVARCHAR2(255)       NULL,
    "CONTENT"               NCLOB                NULL,
    "JSON_CONTENT"          NCLOB                NULL,
    "VALID"                 NUMBER(1)            NOT NULL, /* boolean */
    "DELETED"               NUMBER(1)            NOT NULL, /* boolean */
    "DEPLOYED"              NUMBER(1)            NOT NULL, /* boolean */
    "RELEASED"              NUMBER(1)            NOT NULL, /* boolean */
    "REPO_CTRL"             NUMBER(1)            NOT NULL, /* boolean */
    "AUDIT_LOG_ID"          NUMBER(10)           NOT NULL,
    "CREATED"               DATE                 NOT NULL,
    "MODIFIED"              DATE                 NOT NULL,
    CONSTRAINT IC_JC CHECK ("JSON_CONTENT" IS JSON),
    CONSTRAINT UNIQUE_IC_TP UNIQUE ("TYPE", "PATH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_C'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_C
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_IC_F'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_IC_F      ON INV_CONFIGURATIONS("FOLDER")
'; END IF; END;
/


/* Table for INV_CONFIGURATION_TRASH */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_CONFIGURATION_TRASH'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_CONFIGURATION_TRASH (
    "ID"                    NUMBER(10)           NOT NULL,
    "TYPE"                  NUMBER(3)            NOT NULL,   /* com.sos.joc.model.inventory.ConfigurationType */
    "PATH"                  NVARCHAR2(255)       NOT NULL,
    "NAME"                  NVARCHAR2(255)       NOT NULL,
    "FOLDER"                NVARCHAR2(255)       NOT NULL,
    "TITLE"                 NVARCHAR2(255)       NULL,
    "CONTENT"               NCLOB                NULL,
    "VALID"                 NUMBER(1)            NOT NULL, /* boolean */
    "AUDIT_LOG_ID"          NUMBER(10)           NOT NULL,
    "CREATED"               DATE                 NOT NULL,
    "MODIFIED"              DATE                 NOT NULL,
    CONSTRAINT UNIQUE_ICT_TP UNIQUE ("TYPE", "PATH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_CT'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_CT
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_ICT_F'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_ICT_F      ON INV_CONFIGURATION_TRASH("FOLDER")
'; END IF; END;
/



/* Table for INV_RELEASED_CONFIGURATIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_RELEASED_CONFIGURATIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_RELEASED_CONFIGURATIONS (
    "ID"                    NUMBER(10)           NOT NULL,
    "TYPE"                  NUMBER(3)            NOT NULL,   /* com.sos.joc.model.inventory.ConfigurationType */
    "PATH"                  NVARCHAR2(255)       NOT NULL,
    "CID"                   NUMBER(10)           NOT NULL, /* 1:1 foreign key INV_CONFIGURATIONS.ID */
    "NAME"                  NVARCHAR2(255)       NOT NULL,
    "FOLDER"                NVARCHAR2(255)       NOT NULL,
    "TITLE"                 NVARCHAR2(255)       NULL,
    "CONTENT"               NCLOB                NOT NULL,
    "JSON_CONTENT"          NCLOB                NOT NULL,
    "AUDIT_LOG_ID"          NUMBER(10)           NOT NULL,
    "CREATED"               DATE                 NOT NULL,
    "MODIFIED"              DATE                 NOT NULL,
    CONSTRAINT IRC_JC CHECK ("JSON_CONTENT" IS JSON),
    CONSTRAINT UNIQUE_IRC_TP UNIQUE ("TYPE", "PATH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_RC'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_RC
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_IRC_C'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_IRC_C      ON INV_RELEASED_CONFIGURATIONS("CID")
'; END IF; END;
/



/* Table for INV_CERTS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_CERTS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_CERTS (
    "ID"                    NUMBER(10)           NOT NULL,
    "KEY_TYPE"              NUMBER(1)            NOT NULL, /* PRIVATE, X509 */ 
    "KEY_ALG"               NUMBER(1)            NOT NULL, /* RSA, ECDSA */
    "PEM"                   VARCHAR2(4000)       NOT NULL, /* non unicode - VARCHAR2 data type */
    "CA"                    NUMBER(1)            NOT NULL, /* boolean */
    "ACCOUNT"               NVARCHAR2(255)       NOT NULL,
    "SECLVL"                NUMBER(1)            DEFAULT 0 NOT NULL,
    CONSTRAINT UNIQUE_ICS_KTCAS UNIQUE ("KEY_TYPE", "CA", "ACCOUNT", "SECLVL"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_CRTS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_CRTS
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table for INV_DOCUMENTATIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_DOCUMENTATIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_DOCUMENTATIONS (
    "ID"                    NUMBER(10)           NOT NULL,
    "NAME"                  NVARCHAR2(255)       NOT NULL,
    "FOLDER"                NVARCHAR2(255)       NOT NULL,
    "PATH"                  NVARCHAR2(255)       NOT NULL,
    "TYPE"                  NVARCHAR2(25)        DEFAULT '''' NOT NULL,
    "CONTENT"               NCLOB                NULL,
    "IMAGE_ID"              NUMBER(10)           NULL,
    "IS_REF"                NUMBER(1)            DEFAULT 0 NOT NULL,
    "DOC_REF"               NVARCHAR2(255)       NULL,
    "CREATED"               DATE                 NOT NULL,
    "MODIFIED"              DATE                 NOT NULL,
    CONSTRAINT UNIQUE_IDOC_PATH UNIQUE ("PATH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_D'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_D
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_ID_IR'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_ID_IR      ON INV_DOCUMENTATIONS("IS_REF")
'; END IF; END;
/



/* Table for INV_DOCUMENTATION_IMAGES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_DOCUMENTATION_IMAGES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_DOCUMENTATION_IMAGES (
    "ID"                    NUMBER(10)           NOT NULL,
    "IMAGE"                 BLOB                 NOT NULL,
    "MD5_HASH"              NCHAR(32)            NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_DI'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_DI
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table INV_FAVORITES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_FAVORITES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_FAVORITES (
    "ID"                    NUMBER(10)      NOT NULL,
    "TYPE"                  NUMBER(3)       NOT NULL,   /* e.g. 1=facet, 2=agent */
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "FAVORITE"              NCLOB           NULL,
    "ORDERING"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "ACCOUNT"               NVARCHAR2(255)  NOT NULL,
    "SHARED"                NUMBER(1)       DEFAULT 0 NOT NULL,
    "CREATED"               DATE            NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IF_TNA UNIQUE ("TYPE","NAME","ACCOUNT"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_F'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_F
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_TAGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_TAGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_TAGS (
    "ID"                    NUMBER(10)      NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "ORDERING"              NUMBER(10)      NOT NULL,
    "GROUP_ID"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IT_N UNIQUE ("NAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_T'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_T
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_TAGGINGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_TAGGINGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_TAGGINGS (
    "ID"                    NUMBER(10)      NOT NULL,
    "CID"              	    NUMBER(10)      NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "TYPE"                  NUMBER(3)       NOT NULL, /* com.sos.joc.model.inventory.ConfigurationType */
    "TAG_ID"              	NUMBER(10)      NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_ITG_CT UNIQUE ("CID","TAG_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_TG'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_TG
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_JOB_TAGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_JOB_TAGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_JOB_TAGS (
    "ID"                    NUMBER(10)      NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "ORDERING"              NUMBER(10)      NOT NULL,
    "GROUP_ID"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IJT_N UNIQUE ("NAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_JT'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_JT
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_JOB_TAGGINGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_JOB_TAGGINGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_JOB_TAGGINGS (
    "ID"                    NUMBER(10)      NOT NULL,
    "CID"              	    NUMBER(10)      NOT NULL,
    "WORKFLOW_NAME"         NVARCHAR2(255)  NOT NULL,
    "JOB_NAME"              NVARCHAR2(255)  NOT NULL,
    "TAG_ID"              	NUMBER(10)      NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IJTG_CJT UNIQUE ("CID","JOB_NAME","TAG_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_JTG'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_JTG
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_ADD_ORDER_TAGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_ADD_ORDER_TAGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_ADD_ORDER_TAGS (
    "ORDER_ID_PATTERN"      NUMBER(19)      NOT NULL,
    "ORDER_TAGS"            NCLOB           NOT NULL,
    PRIMARY KEY ("ORDER_ID_PATTERN")
)
'; END IF; END;
/

/* Table INV_ORDER_TAGS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_ORDER_TAGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_ORDER_TAGS (
    "ID"                    NUMBER(10)      NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "ORDERING"              NUMBER(10)      NOT NULL,
    "GROUP_ID"              NUMBER(10)      DEFAULT 0 NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_IOT_N UNIQUE ("NAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_OT'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_OT
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_TAG_GROUPS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_TAG_GROUPS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_TAG_GROUPS (
    "ID"                    NUMBER(10)      NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "ORDERING"              NUMBER(10)      NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_ITG_N UNIQUE ("NAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_TGS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_TGS
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

/* Table INV_DEPENDENCIES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_DEPENDENCIES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE INV_DEPENDENCIES (
    "INV_ID"                NUMBER(10)      NOT NULL,
    "INV_DEP_ID"            NUMBER(10)      NOT NULL,
    "DEP_TYPE"              NUMBER(3)       NOT NULL, /* com.sos.joc.model.inventory.ConfigurationType */
    "PUBLISHED"             NUMBER(1)       DEFAULT 0 NOT NULL,
    "DEP_DEP_ID"            NUMBER(10)      NULL,
    "CONTROLLER_ID"         VARCHAR(100)    NULL,
    PRIMARY KEY ("INV_ID", "INV_DEP_ID")
)
'; END IF; END;
/

/* Table INV_CHANGES */
DECLARE c number; 
BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_CHANGES';
    IF c = 0 THEN EXECUTE IMMEDIATE 
        'CREATE TABLE INV_CHANGES (
            "ID"                    NUMBER(10)      NOT NULL,
            "NAME"                  NVARCHAR2(100)  NOT NULL,
            "TITLE"                 NVARCHAR2(255)  NULL,
            "STATE"                 NUMBER(2)       NOT NULL,
            "CREATED"               DATE            NOT NULL,
            "MODIFIED"              DATE            NOT NULL,
            "CLOSED"                DATE            NULL,
            "OWNER"                 NVARCHAR2(255)  NOT NULL,
            "LAST_PUBLISHED_BY"     NVARCHAR2(255)  NULL,
            CONSTRAINT UNIQUE_ICH_N UNIQUE ("NAME"),
            PRIMARY KEY ("ID")
        )';
    END IF;
END;
/

DECLARE c number; 
BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_INV_CH'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_INV_CH
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_INV_CH_ST';
    IF index_exist = 0 THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_INV_CH_ST ON INV_CHANGES("STATE")';
    END IF;
END;
/

/* Table INV_CHANGES_MAPPINGS */
DECLARE c number; 
BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='INV_CHANGES_MAPPINGS';
    IF c = 0 THEN EXECUTE IMMEDIATE 
        'CREATE TABLE INV_CHANGES_MAPPINGS (
            "CHANGE_ID"             NUMBER(10)      NOT NULL,
            "INV_ID"                NUMBER(10)      NOT NULL,
            "TYPE"                  NUMBER(3)       NOT NULL,   /* com.sos.joc.model.inventory.ConfigurationType */
            PRIMARY KEY ("CHANGE_ID", "INV_ID")
        )';
    END IF;
END;
/

/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for JOC_VARIABLES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_VARIABLES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_VARIABLES (
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "NUMERIC_VALUE"         NUMBER(10)      NULL,
    "TEXT_VALUE"            NVARCHAR2(255)  NULL,
    "BINARY_VALUE"          BLOB            NULL,
    PRIMARY KEY ("NAME")
)
'; END IF; END;
/



/* Table JOC_INSTANCES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_INSTANCES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_INSTANCES (
    "ID"                    NUMBER(10)     NOT NULL,
    "CLUSTER_ID"            NVARCHAR2(10)  NOT NULL,
    "MEMBER_ID"             NVARCHAR2(165) NOT NULL, /* HOSTNAME:hash(DATA_DIRECTORY) */
    "OS_ID"                 NUMBER(10)     NOT NULL,
    "DATA_DIRECTORY"        NVARCHAR2(255) NOT NULL,
    "SECURITY_LEVEL"        NVARCHAR2(10)  NOT NULL,
    "TIMEZONE"              NVARCHAR2(30)  NOT NULL,
    "STARTED_AT"            DATE           NOT NULL,
    "TITLE"                 NVARCHAR2(30)  NULL,
    "ORDERING"              NUMBER(3)      DEFAULT 0 NOT NULL,
    "URI"                   NVARCHAR2(255) NULL,
    "HEART_BEAT"            DATE           NOT NULL,
    "API_SERVER"            NUMBER(1)      NOT NULL,
    "VERSION"               NVARCHAR2(30)  NULL,
    "CERTIFICATE"           VARCHAR2(4000) NULL,     /* non unicode - VARCHAR2 data type, X.509 Certificate*/
    CONSTRAINT UNIQUE_JI_MID UNIQUE ("MEMBER_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_JOC_I'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_JOC_I
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table JOC_CLUSTER */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_CLUSTER'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_CLUSTER (
    "ID"                        NVARCHAR2(10)   NOT NULL,
    "MEMBER_ID"                 NVARCHAR2(165)  NOT NULL,
    "HEART_BEAT"                DATE            NOT NULL,
    "SWITCH_MEMBER_ID"          NVARCHAR2(165)  NULL,
    "SWITCH_HEART_BEAT"         DATE            NULL,
    "NOTIFICATION_MEMBER_ID"    NVARCHAR2(165)  NULL,
    "NOTIFICATION"              NVARCHAR2(100)  NULL,
    CONSTRAINT UNIQUE_JC_MID UNIQUE ("MEMBER_ID"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/



/* Table JOC_CONFIGURATIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_CONFIGURATIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_CONFIGURATIONS (
    "ID"                    NUMBER(10)      NOT NULL,
    "INSTANCE_ID"           NUMBER(10)      NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NULL,
    "ACCOUNT"               NVARCHAR2(255)  NOT NULL,
    "OBJECT_TYPE"           NVARCHAR2(30)   NULL,
    "CONFIGURATION_TYPE"    NVARCHAR2(30)   NOT NULL,
    "NAME"                  NVARCHAR2(255)  NULL,
    "SHARED"                NUMBER(1)       DEFAULT 0 NOT NULL,
    "CONFIGURATION_ITEM"    NCLOB           NOT NULL,
    "MODIFIED"              DATE            NOT NULL,
    CONSTRAINT UNIQUE_JC_CIDAOTCTN UNIQUE ("CONTROLLER_ID","ACCOUNT","OBJECT_TYPE","CONFIGURATION_TYPE","NAME"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_JOC_C'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_JOC_C
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table JOC_AUDIT_LOG */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_AUDIT_LOG'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_AUDIT_LOG (
    "ID"                    NUMBER(10)      NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NOT NULL,
    "ACCOUNT"               NVARCHAR2(255)  NOT NULL,
    "REQUEST"               NVARCHAR2(50)   NOT NULL,
    "PARAMETERS"            NCLOB           NULL,
    "CATEGORY"              NUMBER(2)       DEFAULT 0 NOT NULL,
    "COMMENT"               NVARCHAR2(2000) NULL,
    "CREATED"               DATE            NOT NULL,
    "TICKET_LINK"           NVARCHAR2(255)  NULL,
    "TIME_SPENT"            NUMBER(10)      NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_JOC_AL'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_JOC_AL
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_JAL_CCC'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_JAL_CCC      ON JOC_AUDIT_LOG("CREATED","CONTROLLER_ID","CATEGORY")
'; END IF; END;
/



/* Table JOC_AUDIT_LOG_DETAILS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_AUDIT_LOG_DETAILS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_AUDIT_LOG_DETAILS (
    "ID"                    NUMBER(10)      NOT NULL,
    "AUDITLOG_ID"           NUMBER(10)      NOT NULL, /* ID from JOC_AUDIT_LOG */
    "TYPE"                  NUMBER(2)       DEFAULT 0 NOT NULL, 
    "FOLDER"                NVARCHAR2(255)  NOT NULL,
    "PATH"                  NVARCHAR2(255)  NOT NULL,
    "NAME"                  NVARCHAR2(255)  NOT NULL,
    "ORDER_ID"              NVARCHAR2(255)  NULL, /*For an order the workflow name fills the NAME field */
    "CREATED"               DATE            NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_JOC_ALD'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_JOC_ALD
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_JALD_JALID'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_JALD_JALID    ON JOC_AUDIT_LOG_DETAILS("AUDITLOG_ID")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_JALD_FOLDER'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_JALD_FOLDER    ON JOC_AUDIT_LOG_DETAILS("FOLDER")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_JALD_TYPE'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_JALD_TYPE      ON JOC_AUDIT_LOG_DETAILS("TYPE")
'; END IF; END;
/



/* Table JOC_LOCKS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='JOC_LOCKS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE JOC_LOCKS (
    "ID"                    NUMBER(10)      NOT NULL,
    "RANGE"                 NUMBER(3)       NOT NULL,
    "FOLDER"                NVARCHAR2(255)  NOT NULL,
    "ACCOUNT"               NVARCHAR2(255)  NOT NULL,
    "CREATED"               DATE            NOT NULL,
    CONSTRAINT UNIQUE_JL_RF UNIQUE ("RANGE", "FOLDER"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_JOC_L'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_JOC_L
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/
/*
 | Monitoring Interface tables for Oracle
*/

/* Table for MON_ORDERS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_ORDERS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_ORDERS(
                                "HISTORY_ID"                NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.ID */
                                "CONTROLLER_ID"             NVARCHAR2(100)  NOT NULL,
                                "ORDER_ID"                  NVARCHAR2(255)  NOT NULL,
                                "WORKFLOW_PATH"             NVARCHAR2(255)  NOT NULL,
                                "WORKFLOW_VERSION_ID"       NVARCHAR2(255)  NOT NULL,   /* #2019-06-13T08:43:29Z */
                                "WORKFLOW_POSITION"         NVARCHAR2(255)  NOT NULL,   /* 1#fork_1#0 */
                                "WORKFLOW_FOLDER"           NVARCHAR2(255)  NOT NULL,
                                "WORKFLOW_NAME"             NVARCHAR2(255)  NOT NULL,
                                "WORKFLOW_TITLE"            NVARCHAR2(255)  NULL,                           
                                "MAIN_PARENT_ID"            NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.ID of the main order */
                                "PARENT_ID"                 NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.ID of the parent order */
                                "PARENT_ORDER_ID"           NVARCHAR2(255)  NOT NULL,   /* HISTORY_ORDERS.ORDER_ID */
                                "HAS_CHILDREN"              NUMBER(1)       NOT NULL,
                                "NAME"                      NVARCHAR2(255)  NOT NULL,   /* orderId or branchId by fork */
                                "START_CAUSE"               NVARCHAR2(50)   NOT NULL,   /* order, fork, file_trigger, setback, unskip, unstop */
                                "START_TIME_SCHEDULED"      DATE            NULL,                               
                                "START_TIME"                DATE            NOT NULL,
                                "START_WORKFLOW_POSITION"   NVARCHAR2(255)  NOT NULL,
                                "START_VARIABLES"           NCLOB           NULL,                          
                                "CURRENT_HOS_ID"            NUMBER(19)      NOT NULL,   /* HISTORY_ORDER_STEPS.ID */
                                "END_TIME"                  DATE            NULL,
                                "END_WORKFLOW_POSITION"     NVARCHAR2(255)  NULL,
                                "END_HOS_ID"                NUMBER(19)      NOT NULL,   /* HISTORY_ORDER_STEPS.ID */
                                "END_RETURN_CODE"           NUMBER(10)      NULL,
                                "END_MESSAGE"               NVARCHAR2(500)  NULL,    
                                "SEVERITY"                  NUMBER(1)       NOT NULL,   /* 0,1,2 */
                                "STATE"                     NUMBER(3)       NOT NULL,   
                                "STATE_TIME"                DATE            NOT NULL,
                                "ERROR"                     NUMBER(1)       NOT NULL,
                                "ERROR_STATE"               NVARCHAR2(20)   NULL,       /* failed, disrupted ... - event outcome*/
                                "ERROR_REASON"              NVARCHAR2(50)   NULL,       /* other ... - event outcome*/
                                "ERROR_RETURN_CODE"         NUMBER(10)      NULL,
                                "ERROR_CODE"                NVARCHAR2(50)   NULL,                            
                                "ERROR_TEXT"                NVARCHAR2(500)  NULL,                           
                                "LOG_ID"                    NUMBER(19)      NULL,       /* HISTORY_LOGS.ID */
                                "CREATED"                   DATE            NOT NULL,
                                "MODIFIED"                  DATE            NOT NULL,
                                PRIMARY KEY ("HISTORY_ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONO_CID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONO_CID ON MON_ORDERS("CONTROLLER_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONO_MPID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONO_MPID ON MON_ORDERS("MAIN_PARENT_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for MON_ORDER_STEPS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_ORDER_STEPS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_ORDER_STEPS(
                                "HISTORY_ID"                NUMBER(19)      NOT NULL,   /* HISTORY_ORDER_STEPS.ID */
                                "WORKFLOW_POSITION"         NVARCHAR2(255)  NOT NULL,   /* 1#fork_1#3 */
                                "HO_MAIN_PARENT_ID"         NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.MAIN_PARENT_ID */
                                "HO_ID"                     NUMBER(19)      NOT NULL,   /* HISTORY_ORDERS.ID */
                                "POSITION"                  NUMBER(10)      NOT NULL,   /* 3 - last position from WORKFLOW_POSITION */
                                "JOB_NAME"                  NVARCHAR2(255)  NOT NULL,
                                "JOB_LABEL"                 NVARCHAR2(255)  NOT NULL,
                                "JOB_TITLE"                 NVARCHAR2(255)  NULL,                           
                                "JOB_NOTIFICATION"          NVARCHAR2(1000) NULL,
                                "JOB_CRITICALITY"           NUMBER(3)       NOT NULL,
                                "AGENT_ID"                  NVARCHAR2(255)  NOT NULL,
                                "AGENT_NAME"                NVARCHAR2(255)  NULL,
                                "AGENT_URI"                 NVARCHAR2(255)  NOT NULL,
                                "SUBAGENT_CLUSTER_ID"       NVARCHAR2(255)  NULL,
                                "START_CAUSE"               NVARCHAR2(50)   NOT NULL,   /* order, file_trigger, setback, unskip, unstop */
                                "START_TIME"                DATE            NOT NULL,
                                "START_VARIABLES"           NCLOB           NULL,                          
                                "END_TIME"                  DATE            NULL,
                                "END_VARIABLES"             NCLOB           NULL,                          
                                "RETURN_CODE"               NUMBER(10)      NULL,
                                "SEVERITY"                  NUMBER(1)       NOT NULL,   /* 0,1,2 */
                                "ERROR"                     NUMBER(1)       NOT NULL,   
                                "ERROR_STATE"               NVARCHAR2(20)   NULL,       /* failed, disrupted ... - event outcome*/
                                "ERROR_REASON"              NVARCHAR2(50)   NULL,       /* other ... - event outcome*/
                                "ERROR_CODE"                NVARCHAR2(50)   NULL,                            
                                "ERROR_TEXT"                NVARCHAR2(500)  NULL,                           
                                "LOG_ID"                    NUMBER(19)      NULL,       /* HISTORY_LOGS.ID */
                                "CREATED"                   DATE            NOT NULL,
                                "MODIFIED"                  DATE            NOT NULL,
                                PRIMARY KEY ("HISTORY_ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONOS_HMPID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONOS_HMPID ON MON_ORDER_STEPS("HO_MAIN_PARENT_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for MON_NOTIFICATIONS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_NOTIFICATIONS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_NOTIFICATIONS(
                                "ID"                        NUMBER(19)      NOT NULL,
                                "TYPE"                      NUMBER(3)       NOT NULL,   /* SUCCESS(0), ERROR(1), WARNING(2), RECOVERED(3), ACKNOWLEDGED(4) */
                                "RANGE"                     NUMBER(3)       NOT NULL,   /* WORKFLOW(0), WORKFLOW_JOB(1) */
                                "NOTIFICATION_ID"           NVARCHAR2(255)  NOT NULL,
                                "RECOVERED_ID"              NUMBER(19)      NOT NULL,   /* MON_NOTIFICATIONS.ID */
                                "WARN"                      NUMBER(3)       NOT NULL,  
                                "WARN_TEXT"                 NVARCHAR2(500)  NULL,                           
                                "HAS_MONITORS"              NUMBER(1)       NOT NULL,
                                "CREATED"                   DATE            NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONN_C';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONN_C ON MON_NOTIFICATIONS("CREATED")';
            END IF;
        END;
        
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_MON_N'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_MON_N
                                    INCREMENT BY 1
                                    START WITH 1
                                    MAXVALUE 9999999999999999999
                                    MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/

/* Table for MON_NOT_WORKFLOWS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_NOT_WORKFLOWS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_NOT_WORKFLOWS(
                                "NOT_ID"                    NUMBER(19)      NOT NULL,   /* MON_NOTIFICATIONS.ID */
                                "MON_O_HISTORY_ID"          NUMBER(19)      NOT NULL,   /* MON_ORDERS.HISTORY_ID */
                                "MON_OS_HISTORY_ID"         NUMBER(19)      NOT NULL,   /* MON_ORDER_STEPS.HISTORY_ID */
                                "WORKFLOW_POSITION"         NVARCHAR2(255)  NOT NULL,   /* 1#fork_1#3 */
                                PRIMARY KEY ("NOT_ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONNW_OHID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONNW_OHID ON MON_NOT_WORKFLOWS("MON_O_HISTORY_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONNW_OSHID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONNW_OSHID ON MON_NOT_WORKFLOWS("MON_OS_HISTORY_ID")';
            END IF;
        END;
    END IF;
END;
/

/* Table for MON_SYSNOTIFICATIONS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_SYSNOTIFICATIONS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_SYSNOTIFICATIONS(
                                "ID"                NUMBER(19)          NOT NULL,
                                "TYPE"              NUMBER(3)           NOT NULL, /* ERROR(1), WARNING(2), ACKNOWLEDGED(4) */
                                "CATEGORY"          NUMBER(1)           NOT NULL, /* SYSTEM(0), JOC(1), CONTROLLER(2), AGENT(3) */
                                "JOC_ID"            NVARCHAR2(13)       NOT NULL, /* JOC_INSTANCES.CLUSTER_ID#JOC_INSTANCES.ORDERING */
                                "SOURCE"            NVARCHAR2(100)      NOT NULL,
                                "NOTIFIER"          NVARCHAR2(255)      NOT NULL,
                                "TIME"              DATE                NOT NULL,
                                "MESSAGE"           NVARCHAR2(1000)     NULL,
                                "EXCEPTION"         VARCHAR2(4000 CHAR) NULL,
                                "HAS_MONITORS"      NUMBER(1)           NOT NULL,
                                "CREATED"           DATE                NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONSN_TYPE';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONSN_TYPE ON MON_SYSNOTIFICATIONS("TYPE")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONSN_JOCID';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONSN_JOCID ON MON_SYSNOTIFICATIONS("JOC_ID")';
            END IF;
        END;
        
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONSN_TIME';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONSN_TIME ON MON_SYSNOTIFICATIONS("TIME")';
            END IF;
        END;
        
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_MON_SN'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_MON_SN
                                    INCREMENT BY 1
                                    START WITH 1
                                    MAXVALUE 9999999999999999999
                                    MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/

/* Table for MON_NOT_MONITORS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_NOT_MONITORS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_NOT_MONITORS(
                                "ID"                        NUMBER(19)              NOT NULL,
                                "NOT_ID"                    NUMBER(19)              NOT NULL, /* MON_NOTIFICATIONS.ID or MON_SYSNOTIFICATIONS.ID */
                                "APPLICATION"               NUMBER(1)               NOT NULL, /* 0 - MON_NOTIFICATIONS, 1 - MON_SYSNOTIFICATIONS */
                                "TYPE"                      NUMBER(3)               NOT NULL, /* COMMAND(0), MAIL(1), NSCA(2), JMS(3) */
                                "NAME"                      NVARCHAR2(255)          NOT NULL,
                                "CONFIGURATION"             NVARCHAR2(500)          NOT NULL,
                                "MESSAGE"                   VARCHAR2(4000 CHAR)     NOT NULL, /* VARCHAR2 because NCLOB is too big, NVARCHAR2(4000) not possible (max NVARCHAR2(2000)) */
                                "ERROR"                     NUMBER(1)               NOT NULL,
                                "ERROR_TEXT"                NVARCHAR2(500)          NULL,
                                "CREATED"                   DATE                    NOT NULL,
                                PRIMARY KEY ("ID")
                            )';
        DECLARE index_exist number;
        BEGIN
            SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE INDEX_NAME = 'IDX_MONM_NIDA';
            IF (index_exist = 0) THEN
                EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONM_NIDA ON MON_NOT_MONITORS("NOT_ID","APPLICATION")';
            END IF;
        END;
        
        DECLARE sequence_exist number; 
        BEGIN 
            SELECT COUNT(*) INTO sequence_exist FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_MON_NM'; 
            IF (sequence_exist = 0) THEN 
                EXECUTE IMMEDIATE   'CREATE SEQUENCE SEQ_MON_NM
                                    INCREMENT BY 1
                                    START WITH 1
                                    MAXVALUE 9999999999999999999
                                    MINVALUE 1 CYCLE';          
            END IF; 
        END;
    END IF;
END;
/

/* Table for MON_NOT_ACKNOWLEDGEMENTS */
DECLARE table_exist number;
BEGIN 
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE "TABLE_NAME"='MON_NOT_ACKNOWLEDGEMENTS';
    IF (table_exist = 0) THEN 
        EXECUTE IMMEDIATE   'CREATE TABLE MON_NOT_ACKNOWLEDGEMENTS(
                                "NOT_ID"        NUMBER(19)      NOT NULL, /* MON_NOTIFICATIONS.ID or MON_SYSNOTIFICATIONS.ID */
                                "APPLICATION"   NUMBER(1)       NOT NULL, /* 0 - MON_NOTIFICATIONS, 1 - MON_SYSNOTIFICATIONS */
                                "ACCOUNT"       NVARCHAR2(255)  NOT NULL,
                                "COMMENT"       NVARCHAR2(2000) NULL,
                                "CREATED"       DATE            NOT NULL,
                                PRIMARY KEY ("NOT_ID","APPLICATION")
                            )';
    END IF;
END;
/
/* MON_ORDER_STEPS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'START_VARIABLES' AND upper(data_type)='NCLOB';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS RENAME COLUMN "START_VARIABLES" TO "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS ADD "START_VARIABLES" NCLOB NULL';
        EXECUTE IMMEDIATE 'UPDATE MON_ORDER_STEPS SET "START_VARIABLES" = "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS DROP COLUMN "START_VARIABLES_OLD"';
    END IF;
END;
/

COMMIT;
/*
 | Tables for Oracle
*/

/* Table REPORTS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='REPORTS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE REPORTS (
    "ID"                    NUMBER(10)     NOT NULL,
    "RUN_ID"                NUMBER(10)     NOT NULL, /* REPORT_RUNS.id */
    "FREQUENCY"             NUMBER(10)     NOT NULL,
    "DATE_FROM"             DATE           NOT NULL,
    "DATE_TO"               DATE           NOT NULL,
    "CONTENT"               NCLOB          NOT NULL,
    "CONSTRAINT_HASH"       NCHAR(64)      NOT NULL,
    "MODIFIED"              DATE           NOT NULL,
    "CREATED"               DATE           NOT NULL,
    CONSTRAINT UNIQUE_R_CH UNIQUE ("CONSTRAINT_HASH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_REP_REP'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_REP_REP
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


/* Table REPORT_RUNS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='REPORT_RUNS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE REPORT_RUNS (
    "ID"                    NUMBER(10)     NOT NULL,
    "PATH"                  NVARCHAR2(255) NOT NULL,
    "FOLDER"                NVARCHAR2(255) NOT NULL,
    "NAME"                  NVARCHAR2(255) NOT NULL,
    "TITLE"                 NVARCHAR2(255) NULL,
    "TEMPLATE_ID"           NUMBER(10)     NOT NULL,
    "FREQUENCIES"           NVARCHAR2(255) NOT NULL,
    "SORT"                  NUMBER(10)     NOT NULL,
    "PERIOD_LENGTH"         NUMBER(10)         NULL,
    "PERIOD_STEP"           NUMBER(10)         NULL,
    "HITS"                  NUMBER(10)     NOT NULL,
    "REPORT_COUNT"          NUMBER(10)     NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100) NULL,
    "MONTH_FROM"            DATE           NOT NULL,
    "MONTH_TO"              DATE           NOT NULL,
    "STATE"                 NUMBER(3)      NOT NULL,
    "ERROR_TEXT"            NVARCHAR2(500) NULL,
    "MODIFIED"              DATE           NOT NULL,
    "CREATED"               DATE           NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_REP_RUN'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_REP_RUN
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/


 
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for SEARCH_WORKFLOWS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='SEARCH_WORKFLOWS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE SEARCH_WORKFLOWS (
    "ID"                    NUMBER(10)       NOT NULL,
    "INV_CID"               NUMBER(10)       NOT NULL, /* INV_CONFIGURATIONS.ID */
    "DEPLOYED"              NUMBER(1)        NOT NULL, /* boolean */
    "CONTENT_HASH"          NCHAR(64)        NOT NULL, /* workflow hash */
    "JOBS_COUNT"            NUMBER(10)       NOT NULL,
    "JOBS"                  NCLOB            NOT NULL,
    "ARGS"                  NCLOB            NOT NULL,
    "JOBS_SCRIPTS"          NCLOB            NOT NULL,
    "INSTRUCTIONS"          NCLOB            NOT NULL,
    "INSTRUCTIONS_ARGS"     NCLOB            NOT NULL,
    "CREATED"               DATE             NOT NULL,
    "MODIFIED"              DATE             NOT NULL,
    CONSTRAINT SW_J  CHECK ("JOBS" IS JSON),
    CONSTRAINT SW_JA CHECK ("ARGS" IS JSON),
    CONSTRAINT SW_JS CHECK ("JOBS_SCRIPTS" IS JSON),
    CONSTRAINT SW_I  CHECK ("INSTRUCTIONS" IS JSON),
    CONSTRAINT SW_IA CHECK ("INSTRUCTIONS_ARGS" IS JSON),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_SEARCH_W'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_SEARCH_W
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_SW_INVCID'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_SW_INVCID      ON SEARCH_WORKFLOWS("INV_CID")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_SW_DEP'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_SW_DEP      ON SEARCH_WORKFLOWS("DEPLOYED")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_SW_CH'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_SW_CH      ON SEARCH_WORKFLOWS("CONTENT_HASH")
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_SW_JC'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_SW_JC      ON SEARCH_WORKFLOWS("JOBS_COUNT")
'; END IF; END;
/



/* Table for SEARCH_WORKFLOWS_DEP_H */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='SEARCH_WORKFLOWS_DEP_H'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE SEARCH_WORKFLOWS_DEP_H (
    "SEARCH_WID"            NUMBER(10)           NOT NULL, /* SEARCH_WORKFLOWS.ID */
    "INV_CID"               NUMBER(10)           NOT NULL, /* INV_CONFIGURATIONS.ID */
    "DEP_HID"               NUMBER(10)           NOT NULL, /* DEP_HISTORY.ID */
    "CONTROLLER_ID"         NVARCHAR2(100)       NOT NULL,
    PRIMARY KEY ("SEARCH_WID","INV_CID","CONTROLLER_ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_SWDH_DEPHID'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_SWDH_DEPHID      ON SEARCH_WORKFLOWS_DEP_H("DEP_HID")
'; END IF; END;
/
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for XMLEDITOR_CONFIGURATIONS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE XMLEDITOR_CONFIGURATIONS (
    "ID"                            NUMBER(10)      NOT NULL,
    "TYPE"                          NVARCHAR2(25)   NOT NULL,
    "NAME"                          NVARCHAR2(255)  NOT NULL,
    "SCHEMA_LOCATION"               NVARCHAR2(255)  NOT NULL,
    "CONFIGURATION_DRAFT"           NCLOB           NULL,
    "CONFIGURATION_DRAFT_JSON"      NCLOB           NULL,
    "CONFIGURATION_RELEASED"        NCLOB           NULL,
    "CONFIGURATION_RELEASED_JSON"   NCLOB           NULL,
    "AUDIT_LOG_ID"                  NUMBER(10)      NOT NULL,
    "ACCOUNT"                       NVARCHAR2(255)  NOT NULL,
    "RELEASED"                      DATE            NULL,
    "MODIFIED"                      DATE            NOT NULL,
    "CREATED"                       DATE            NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_XEC'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_XEC
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_XEC_TN'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_XEC_TN ON XMLEDITOR_CONFIGURATIONS ("TYPE", "NAME")
'; END IF; END;
/
/*
 | tables for Oracle
 | SOS GmbH, 2021-05-20
*/


/* Table for YADE_TRANSFERS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='YADE_TRANSFERS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE YADE_TRANSFERS (
    "ID"                    NUMBER(10)      NOT NULL,
    "CONTROLLER_ID"         NVARCHAR2(100)  NOT NULL,
    "WORKFLOW_PATH"         NVARCHAR2(255)  NOT NULL,
    "WORKFLOW_NAME"         NVARCHAR2(255)  NOT NULL,
    "ORDER_ID"              NVARCHAR2(255)  NOT NULL,
    "JOB"                   NVARCHAR2(255)  NOT NULL,
    "JOB_POSITION"          NVARCHAR2(255)  NOT NULL,
    "HOS_ID"                NUMBER(19)      NOT NULL,
    "SOURCE_PROTOCOL_ID"    NUMBER(19)      NOT NULL,
    "TARGET_PROTOCOL_ID"    NUMBER(19)      NULL,
    "JUMP_PROTOCOL_ID"      NUMBER(19)      NULL,
    "OPERATION"             INT             NOT NULL,
    "PROFILE_NAME"          NVARCHAR2(100)  NULL,
    "START"                 DATE            NOT NULL,
    "END"                   DATE            NULL,
    "NUM_OF_FILES"          NUMBER(10)      NOT NULL,
    "STATE"                 NUMBER(10)      NOT NULL,
    "ERROR_MESSAGE"         NVARCHAR2(2000) NULL,
    "CREATED"               DATE            NOT NULL,
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_YADE_TRA'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_YADE_TRA
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_INDEXES WHERE "INDEX_NAME"='IDX_YT_START'; IF c = 0 THEN EXECUTE IMMEDIATE '
    CREATE INDEX IDX_YT_START      ON YADE_TRANSFERS("START")
'; END IF; END;
/



/* Table for YADE_PROTOCOLS */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='YADE_PROTOCOLS'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE YADE_PROTOCOLS (
    "ID"                    NUMBER(19)      NOT NULL,
    "HOSTNAME"              NVARCHAR2(255)  NOT NULL,
    "PORT"                  NUMBER(10)      NOT NULL,
    "PROTOCOL"              NUMBER(10)      NOT NULL,
    "ACCOUNT"               NVARCHAR2(255)  NOT NULL,
    "CREATED"               DATE            NOT NULL,
    CONSTRAINT UNIQUE_YP_HPPA UNIQUE ("HOSTNAME", "PORT", "PROTOCOL", "ACCOUNT"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_YADE_PRO'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_YADE_PRO
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/



/* Table for YADE_FILES */
DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_TABLES WHERE "TABLE_NAME"='YADE_FILES'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE TABLE YADE_FILES (
    "ID"                    NUMBER(19)      NOT NULL,
    "TRANSFER_ID"           NUMBER(19)      NOT NULL,
    "SOURCE_PATH"           NVARCHAR2(255)  NOT NULL,
    "TARGET_PATH"           NVARCHAR2(255)  NULL,
    "SIZE"                  NUMBER(19)      NULL,
    "MODIFICATION_DATE"     DATE            NULL,
    "STATE"                 NUMBER(10)      NOT NULL,
    "INTEGRITY_HASH"        NVARCHAR2(255)  NULL,
    "ERROR_MESSAGE"         NVARCHAR2(2000) NULL,
    "CREATED"               DATE            NOT NULL,
    CONSTRAINT INVENTORY_YF_UNIQUE UNIQUE ("TRANSFER_ID", "SOURCE_PATH"),
    PRIMARY KEY ("ID")
)
'; END IF; END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM USER_SEQUENCES WHERE "SEQUENCE_NAME"='SEQ_YADE_FIL'; IF c = 0 THEN EXECUTE IMMEDIATE '
CREATE SEQUENCE SEQ_YADE_FIL
  INCREMENT BY 1
  START WITH 1
  MAXVALUE 9999999999999999999
  MINVALUE 1 CYCLE
'; END IF; END;
/
/* IAM_IDENTITY_SERVICES OIDC */

BEGIN
EXECUTE IMMEDIATE 'UPDATE IAM_IDENTITY_SERVICES SET IDENTITY_SERVICE_TYPE=''OIDC-JOC'' WHERE IDENTITY_SERVICE_TYPE=''OIDC'' AND ID IN (SELECT IDENTITY_SERVICE_ID FROM IAM_ACCOUNTS)';
EXECUTE IMMEDIATE 'UPDATE JOC_CONFIGURATIONS SET OBJECT_TYPE=''OIDC-JOC'' WHERE OBJECT_TYPE=''OIDC'' AND ID IN 
          (SELECT T.ID FROM (SELECT ID FROM JOC_CONFIGURATIONS JC
          WHERE JC.OBJECT_TYPE=''OIDC'' AND
          JC.NAME IN (SELECT IC.IDENTITY_SERVICE_NAME FROM IAM_IDENTITY_SERVICES IC, IAM_ACCOUNTS IA WHERE IA.IDENTITY_SERVICE_ID=IC.ID AND  IC.IDENTITY_SERVICE_NAME=JC.NAME)) T)';
END;
/
COMMIT;  


/* IAM_IDENTITY_SERVICES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'SECOND_FACTOR' AND table_name = 'IAM_IDENTITY_SERVICES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES ADD "SECOND_FACTOR" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE IAM_IDENTITY_SERVICES SET "SECOND_FACTOR" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES MODIFY "SECOND_FACTOR" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;  

/* IAM_HISTORY Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'IDENTITY_SERVICE_ID' AND table_name = 'IAM_HISTORY';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_HISTORY ADD "IDENTITY_SERVICE_ID" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE IAM_HISTORY SET "IDENTITY_SERVICE_ID" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_HISTORY MODIFY "IDENTITY_SERVICE_ID" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;  

/* IAM_HISTORY indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'IAM_HISTORY' AND index_name = 'IDX_IAMH_ISID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMH_ISID ON IAM_HISTORY("IDENTITY_SERVICE_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'IAM_HISTORY' AND index_name = 'IDX_IAMH_LD';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMH_LD ON IAM_HISTORY("LOGIN_DATE")';
    END IF;
END;
/

COMMIT;

/* IAM_HISTORY_DETAILS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'IAM_HISTORY_DETAILS' AND index_name = 'IDX_IAMHD_HID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_IAMHD_HID ON IAM_HISTORY_DETAILS("IAM_HISTORY_ID")';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'SECOND_FACTOR_IS_ID' AND table_name = 'IAM_IDENTITY_SERVICES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES ADD "SECOND_FACTOR_IS_ID" NUMBER(10) NULL';
    END IF;
END;
/


COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'IAM_IDENTITY_SERVICES' AND column_name = 'SINGLE_FACTOR_PWD';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES DROP COLUMN "SINGLE_FACTOR_PWD"';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'IAM_IDENTITY_SERVICES' AND column_name = 'SINGLE_FACTOR_CERT';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES DROP COLUMN "SINGLE_FACTOR_CERT"';
    END IF;
END;
/

COMMIT;
 

/* IAM_ACCOUNTS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'FORCE_PASSWORD_CHANGE' AND table_name = 'IAM_ACCOUNTS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS ADD "FORCE_PASSWORD_CHANGE" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE IAM_ACCOUNTS SET "FORCE_PASSWORD_CHANGE" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS MODIFY "FORCE_PASSWORD_CHANGE" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT; 

/* IAM_FIDO2_DEVICES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ACCOOUNT_ID' AND table_name = 'IAM_FIDO2_DEVICES';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_FIDO2_DEVICES RENAME COLUMN ACCOOUNT_ID TO ACCOUNT_ID';
    END IF;
END;
/

COMMIT; 

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DISABLED' AND table_name = 'IAM_ACCOUNTS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS ADD "DISABLED" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE IAM_ACCOUNTS SET "DISABLED" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS MODIFY "DISABLED" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;  

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'EMAIL' AND table_name = 'IAM_ACCOUNTS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS ADD "EMAIL" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;  

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ORDERING' AND table_name = 'IAM_ROLES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE IAM_ROLES ADD "ORDERING" NUMBER(10) NULL';
    END IF;
END;
/

COMMIT;  


DECLARE constraint_exist number;
BEGIN
        SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_IAM_A_IN';
        IF (constraint_exist = 0) THEN
            EXECUTE IMMEDIATE 'ALTER TABLE IAM_ACCOUNTS ADD CONSTRAINT UNIQUE_IAM_A_IN UNIQUE ("IDENTITY_SERVICE_ID", "ACCOUNT_NAME")';
        END IF;
END;
/

COMMIT;  

DECLARE constraint_exist number;
BEGIN
        SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_IAM_R_IN';
        IF (constraint_exist = 0) THEN
            EXECUTE IMMEDIATE 'ALTER TABLE IAM_ROLES ADD CONSTRAINT UNIQUE_IAM_R_IN UNIQUE ("IDENTITY_SERVICE_ID", "ROLE_NAME")';
        END IF;
END;
/

COMMIT;  

DECLARE constraint_exist number;
BEGIN
        SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_IAM_S_N';
        IF (constraint_exist = 0) THEN
            EXECUTE IMMEDIATE 'ALTER TABLE IAM_IDENTITY_SERVICES ADD CONSTRAINT UNIQUE_IAM_S_N UNIQUE ("IDENTITY_SERVICE_NAME")';
        END IF;
END;
/

COMMIT;  

DECLARE old_datatype number;
BEGIN 
    SELECT COUNT(*) INTO old_datatype FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='YADE_TRANSFERS' AND COLUMN_NAME='WORKFLOW_PATH' AND DATA_TYPE = 'VARCHAR2';
    IF (old_datatype = 1) THEN 
        -- DEP_HISTORY
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_HISTORY' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "ACCOUNT"         NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "COMMIT_ID"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "ERROR_MESSAGE"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "FOLDER"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "NAME"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "PATH"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "SIGNATURE"       NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "TITLE"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY "VERSION"         NVARCHAR2(50)';
            END IF;
        END;
        
        -- DEP_KEYS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_KEYS' AND COLUMN_NAME='ACCOUNT' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_KEYS MODIFY "ACCOUNT" NVARCHAR2(255)';
            END IF;
        END;
        
        -- DEP_SIGNATURES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_SIGNATURES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SIGNATURES MODIFY "ACCOUNT"      NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SIGNATURES MODIFY "SIGNATURE"    NVARCHAR2(2000)';
            END IF;
        END;
        
        -- DEP_SUBMISSIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_SUBMISSIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "ACCOUNT"         NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "COMMIT_ID"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "FOLDER"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "PATH"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "SIGNATURE"       NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY "VERSION"         NVARCHAR2(50)';
            END IF;
        END;
        
        -- DEP_VERSIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_VERSIONS' AND COLUMN_NAME='VERSION' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_VERSIONS MODIFY "VERSION" NVARCHAR2(100)';
            END IF;
        END;
        
        -- DPL_HISTORY
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DPL_HISTORY' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "MESSAGE"         NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "ORDER_ID"        NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "USER_ACCOUNT"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "WORKFLOW_FOLDER" NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_HISTORY MODIFY "WORKFLOW_PATH"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- DPL_ORDERS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DPL_ORDERS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "CONTROLLER_ID"    NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "MESSAGE"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "ORDER_ID"         NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "ORDER_NAME"       NVARCHAR2(30)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "SCHEDULE_FOLDER"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "SCHEDULE_NAME"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "SCHEDULE_PATH"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "WORKFLOW_FOLDER"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "WORKFLOW_NAME"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "WORKFLOW_PATH"    NVARCHAR2(255)';
            END IF;
        END;
        
        -- DPL_ORDER_VARIABLES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DPL_ORDER_VARIABLES' AND COLUMN_NAME='VARIABLE_VALUE'  AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES MODIFY "VARIABLE_VALUE" NVARCHAR2(2000)';
            END IF;
        END;
        
        -- DPL_SUBMISSIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DPL_SUBMISSIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_SUBMISSIONS MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE DPL_SUBMISSIONS MODIFY "USER_ACCOUNT"    NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_AGENTS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_AGENTS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY "AGENT_ID"                 NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY "CONTROLLER_ID"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY "COUPLING_FAILED_MESSAGE"  NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY "TIMEZONE"                 NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY "URI"                      NVARCHAR2(100)';
            END IF;
        END;
        
        -- HISTORY_CONTROLLERS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_CONTROLLERS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_CONTROLLERS MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_CONTROLLERS MODIFY "TIMEZONE"        NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_CONTROLLERS MODIFY "URI"             NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_LOGS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_LOGS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_LOGS MODIFY "CONTROLLER_ID" NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_LOGS MODIFY "FILE_BASENAME" NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_ORDERS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_ORDERS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "CONSTRAINT_HASH"          NCHAR(64)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "CONTROLLER_ID"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "END_WORKFLOW_POSITION"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "ERROR_CODE"               NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "ERROR_REASON"             NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "ERROR_STATE"              NVARCHAR2(20)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "ERROR_TEXT"               NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "NAME"                     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "ORDER_ID"                 NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "PARENT_ORDER_ID"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "START_CAUSE"              NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "START_VARIABLES"          NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "START_WORKFLOW_POSITION"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "STATE_TEXT"               NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_FOLDER"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_NAME"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_PATH"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_POSITION"        NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_TITLE"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS MODIFY "WORKFLOW_VERSION_ID"      NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_ORDER_STATES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_ORDER_STATES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STATES MODIFY "STATE_EVENT_ID" NCHAR(16)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STATES MODIFY "STATE_CODE"     NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STATES MODIFY "STATE_TEXT"     NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_ORDER_STEPS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_ORDER_STEPS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "CONSTRAINT_HASH"     NCHAR(64)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "AGENT_ID"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "AGENT_URI"           NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "CONTROLLER_ID"       NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "ERROR_CODE"          NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "ERROR_REASON"        NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "ERROR_STATE"         NVARCHAR2(20)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "ERROR_TEXT"          NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "JOB_LABEL"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "JOB_NAME"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "JOB_TITLE"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "ORDER_ID"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "START_CAUSE"         NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "START_VARIABLES"     NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "WORKFLOW_FOLDER"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "WORKFLOW_NAME"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "WORKFLOW_PATH"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "WORKFLOW_POSITION"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY "WORKFLOW_VERSION_ID" NVARCHAR2(255)';
            END IF;
        END;
        
        -- HISTORY_TEMP_LOGS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_TEMP_LOGS' AND COLUMN_NAME='MEMBER_ID'  AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_TEMP_LOGS MODIFY "MEMBER_ID" NVARCHAR2(255)';
            END IF;
        END;
        
        -- INV_AGENT_INSTANCES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_AGENT_INSTANCES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "AGENT_ID"        NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "AGENT_NAME"      NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "CONTROLLER_ID"   NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "URI"             NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "VERSION"         NVARCHAR2(30)';
            END IF;
        END;
        
        -- INV_AGENT_NAME_ALIASES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_AGENT_NAME_ALIASES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_NAME_ALIASES MODIFY "AGENT_ID"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_NAME_ALIASES MODIFY "AGENT_NAME"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- INV_CERTS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CERTS' AND COLUMN_NAME='ACCOUNT' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CERTS MODIFY "ACCOUNT" NVARCHAR2(255)';
            END IF;
        END;
        
        -- INV_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CONFIGURATIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS MODIFY "FOLDER"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS MODIFY "NAME"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS MODIFY "PATH"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS MODIFY "TITLE"    NVARCHAR2(255)';
            END IF;
        END;
        
        -- INV_CONFIGURATION_TRASH
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CONFIGURATION_TRASH' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH MODIFY "FOLDER"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH MODIFY "NAME"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH MODIFY "PATH"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH MODIFY "TITLE"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- INV_DOCUMENTATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_DOCUMENTATIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS MODIFY "DOC_REF"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS MODIFY "FOLDER"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS MODIFY "NAME"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS MODIFY "PATH"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS MODIFY "TYPE"     NVARCHAR2(25)';
            END IF;
        END;
        
        -- INV_DOCUMENTATION_IMAGES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_DOCUMENTATION_IMAGES' AND COLUMN_NAME='MD5_HASH'  AND DATA_TYPE = 'CHAR';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATION_IMAGES MODIFY "MD5_HASH" NCHAR(32)';
            END IF;
        END;
        
        -- INV_JS_INSTANCES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_JS_INSTANCES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES MODIFY "CLUSTER_URI"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES MODIFY "CONTROLLER_ID"  NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES MODIFY "TITLE"          NVARCHAR2(30)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES MODIFY "URI"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES MODIFY "VERSION"        NVARCHAR2(30)';
            END IF;
        END;
        
        -- INV_OPERATING_SYSTEMS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_OPERATING_SYSTEMS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_OPERATING_SYSTEMS MODIFY "ARCHITECTURE"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_OPERATING_SYSTEMS MODIFY "DISTRIBUTION"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_OPERATING_SYSTEMS MODIFY "HOSTNAME"      NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_OPERATING_SYSTEMS MODIFY "NAME"          NVARCHAR2(50)';
            END IF;
        END;
        
        -- INV_RELEASED_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_RELEASED_CONFIGURATIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY "FOLDER"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY "NAME"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY "PATH"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY "TITLE"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- JOC_AUDIT_LOG
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_AUDIT_LOG' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG MODIFY "ACCOUNT"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG MODIFY "COMMENT"       NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG MODIFY "CONTROLLER_ID" NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG MODIFY "REQUEST"       NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG MODIFY "TICKET_LINK"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- JOC_AUDIT_LOG_DETAILS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_AUDIT_LOG_DETAILS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG_DETAILS MODIFY "FOLDER"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG_DETAILS MODIFY "NAME"      NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG_DETAILS MODIFY "ORDER_ID"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG_DETAILS MODIFY "PATH"      NVARCHAR2(255)';
            END IF;
        END;
        
        -- JOC_CLUSTER
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_CLUSTER' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CLUSTER MODIFY "ID"                      NVARCHAR2(10)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CLUSTER MODIFY "MEMBER_ID"               NVARCHAR2(165)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CLUSTER MODIFY "NOTIFICATION"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CLUSTER MODIFY "NOTIFICATION_MEMBER_ID"  NVARCHAR2(165)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CLUSTER MODIFY "SWITCH_MEMBER_ID"        NVARCHAR2(165)';
            END IF;
        END;
        
        -- JOC_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_CONFIGURATIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY "ACCOUNT"              NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY "CONFIGURATION_TYPE"   NVARCHAR2(30)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY "CONTROLLER_ID"        NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY "NAME"                 NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY "OBJECT_TYPE"          NVARCHAR2(30)';
            END IF;
        END;
        
        -- JOC_INSTANCES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_INSTANCES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "DATA_DIRECTORY"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "MEMBER_ID"         NVARCHAR2(165)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "SECURITY_LEVEL"    NVARCHAR2(10)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "TIMEZONE"          NVARCHAR2(30)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "TITLE"             NVARCHAR2(30)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "URI"               NVARCHAR2(255)';
            END IF;
        END;
        
        -- JOC_LOCKS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_LOCKS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_LOCKS MODIFY "ACCOUNT"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_LOCKS MODIFY "FOLDER"    NVARCHAR2(255)';
            END IF;
        END;
        
        -- JOC_VARIABLES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_VARIABLES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_VARIABLES MODIFY "NAME"       NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_VARIABLES MODIFY "TEXT_VALUE" NVARCHAR2(255)';
            END IF;
        END;
        
        -- MON_NOT_ACKNOWLEDGEMENTS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_NOT_ACKNOWLEDGEMENTS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS MODIFY "ACCOUNT" NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS MODIFY "COMMENT" NVARCHAR2(2000)';
            END IF;
        END;
        
        -- MON_NOTIFICATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_NOTIFICATIONS' AND COLUMN_NAME='NOTIFICATION_ID' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOTIFICATIONS MODIFY "NOTIFICATION_ID" NVARCHAR2(255)';
            END IF;
        END;
        
        -- MON_NOT_MONITORS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_NOT_MONITORS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS MODIFY "CONFIGURATION"  NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS MODIFY "ERROR_TEXT"     NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS MODIFY "NAME"           NVARCHAR2(255)';
            END IF;
        END;
        
        -- MON_NOT_WORKFLOWS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_NOT_WORKFLOWS' AND COLUMN_NAME='WORKFLOW_POSITION' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_WORKFLOWS MODIFY "WORKFLOW_POSITION" NVARCHAR2(255)';
            END IF;
        END;
        
        -- MON_ORDERS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_ORDERS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "CONTROLLER_ID"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "END_WORKFLOW_POSITION"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "ERROR_CODE"               NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "ERROR_REASON"             NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "ERROR_STATE"              NVARCHAR2(20)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "ERROR_TEXT"               NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "NAME"                     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "ORDER_ID"                 NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "PARENT_ORDER_ID"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "START_CAUSE"              NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "START_VARIABLES"          NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "START_WORKFLOW_POSITION"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_FOLDER"          NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_NAME"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_PATH"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_POSITION"        NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_TITLE"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS MODIFY "WORKFLOW_VERSION_ID"      NVARCHAR2(255)';
            END IF;
        END;
        
        -- MON_ORDER_STEPS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_ORDER_STEPS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "AGENT_ID"            NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "AGENT_URI"           NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "ERROR_CODE"          NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "ERROR_REASON"        NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "ERROR_STATE"         NVARCHAR2(20)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "ERROR_TEXT"          NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "JOB_LABEL"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "JOB_NAME"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "JOB_TITLE"           NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "START_CAUSE"         NVARCHAR2(50)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "START_VARIABLES"     NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "WARN_TEXT"           NVARCHAR2(500)';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY "WORKFLOW_POSITION"   NVARCHAR2(255)';
            END IF;
        END;
        
        -- SEARCH_WORKFLOWS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='CONTENT_HASH'  AND DATA_TYPE = 'CHAR';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY "CONTENT_HASH" NCHAR(64)';
            END IF;
        END;
        
        -- SEARCH_WORKFLOWS_DEP_H
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS_DEP_H' AND COLUMN_NAME='CONTROLLER_ID' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS_DEP_H MODIFY "CONTROLLER_ID" NVARCHAR2(100)';
            END IF;
        END;
        
        -- XMLEDITOR_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS MODIFY "ACCOUNT"            NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS MODIFY "NAME"               NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS MODIFY "SCHEMA_LOCATION"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS MODIFY "TYPE"               NVARCHAR2(25)';
            END IF;
        END;
        
        -- YADE_FILES
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='YADE_FILES' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_FILES MODIFY "ERROR_MESSAGE"    NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_FILES MODIFY "INTEGRITY_HASH"   NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_FILES MODIFY "SOURCE_PATH"      NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_FILES MODIFY "TARGET_PATH"      NVARCHAR2(255)';
            END IF;
        END;
        
        -- YADE_PROTOCOLS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='YADE_PROTOCOLS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_PROTOCOLS MODIFY "ACCOUNT"  NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_PROTOCOLS MODIFY "HOSTNAME" NVARCHAR2(255)';
            END IF;
        END;
        
        -- YADE_TRANSFERS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='YADE_TRANSFERS' AND DATA_TYPE = 'VARCHAR2';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "CONTROLLER_ID"    NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "ERROR_MESSAGE"    NVARCHAR2(2000)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "JOB"              NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "JOB_POSITION"     NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "ORDER_ID"         NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "PROFILE_NAME"     NVARCHAR2(100)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "WORKFLOW_NAME"    NVARCHAR2(255)';
                EXECUTE IMMEDIATE 'ALTER TABLE YADE_TRANSFERS MODIFY "WORKFLOW_PATH"    NVARCHAR2(255)';
            END IF;
        END;
        
        
    END IF;
END;
/

COMMIT;
DECLARE old_datatype number;
BEGIN 
    SELECT COUNT(*) INTO old_datatype FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_RELEASED_JSON' AND DATA_TYPE = 'CLOB';
    IF (old_datatype = 1) THEN 
        -- DEP_HISTORY
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_HISTORY' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY ADD      "CONTENT_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE DEP_HISTORY      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY   "CONTENT_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_HISTORY' AND COLUMN_NAME='INV_CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY ADD      "INV_CONTENT_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE DEP_HISTORY      SET      "INV_CONTENT_NEW" = TO_NCLOB("INV_CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY MODIFY   "INV_CONTENT_NEW" DEFAULT '''' NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY DROP     COLUMN "INV_CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY RENAME   COLUMN "INV_CONTENT_NEW" TO "INV_CONTENT"';
            END IF;
        END;
        
        -- DEP_SUBMISSIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='DEP_SUBMISSIONS' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS ADD      "CONTENT_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE DEP_SUBMISSIONS      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS MODIFY   "CONTENT_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE DEP_SUBMISSIONS RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        -- HISTORY_ORDER_STEPS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='HISTORY_ORDER_STEPS' AND COLUMN_NAME='END_VARIABLES' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS ADD      "END_VARIABLES_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE HISTORY_ORDER_STEPS      SET      "END_VARIABLES_NEW" = TO_NCLOB("END_VARIABLES")';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS DROP     COLUMN "END_VARIABLES"';
                EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS RENAME   COLUMN "END_VARIABLES_NEW" TO "END_VARIABLES"';
            END IF;
        END;
        
        -- INV_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CONFIGURATIONS' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS ADD      "CONTENT_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE INV_CONFIGURATIONS      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CONFIGURATIONS' AND COLUMN_NAME='JSON_CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS ADD      "JSON_CONTENT_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE INV_CONFIGURATIONS      SET      "JSON_CONTENT_NEW" = TO_NCLOB("JSON_CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS DROP     COLUMN "JSON_CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS RENAME   COLUMN "JSON_CONTENT_NEW" TO "JSON_CONTENT"';
            END IF;
        END;
        
        -- INV_CONFIGURATION_TRASH
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_CONFIGURATION_TRASH' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH ADD      "CONTENT_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE INV_CONFIGURATION_TRASH      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATION_TRASH RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        -- INV_DOCUMENTATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_DOCUMENTATIONS' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS ADD      "CONTENT_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE INV_DOCUMENTATIONS      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_DOCUMENTATIONS RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        -- INV_RELEASED_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_RELEASED_CONFIGURATIONS' AND COLUMN_NAME='CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS ADD      "CONTENT_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE INV_RELEASED_CONFIGURATIONS      SET      "CONTENT_NEW" = TO_NCLOB("CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY   "CONTENT_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS DROP     COLUMN "CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS RENAME   COLUMN "CONTENT_NEW" TO "CONTENT"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='INV_RELEASED_CONFIGURATIONS' AND COLUMN_NAME='JSON_CONTENT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS ADD      "JSON_CONTENT_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE INV_RELEASED_CONFIGURATIONS      SET      "JSON_CONTENT_NEW" = TO_NCLOB("JSON_CONTENT")';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS MODIFY   "JSON_CONTENT_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS DROP     COLUMN "JSON_CONTENT"';
                EXECUTE IMMEDIATE 'ALTER TABLE INV_RELEASED_CONFIGURATIONS RENAME   COLUMN "JSON_CONTENT_NEW" TO "JSON_CONTENT"';
            END IF;
        END;
        
        -- JOC_AUDIT_LOG
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_AUDIT_LOG' AND COLUMN_NAME='PARAMETERS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG ADD      "PARAMETERS_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE JOC_AUDIT_LOG      SET      "PARAMETERS_NEW" = TO_NCLOB("PARAMETERS")';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG DROP     COLUMN "PARAMETERS"';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_AUDIT_LOG RENAME   COLUMN "PARAMETERS_NEW" TO "PARAMETERS"';
            END IF;
        END;
        
        -- JOC_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='JOC_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_ITEM' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS ADD      "CONFIGURATION_ITEM_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE JOC_CONFIGURATIONS      SET      "CONFIGURATION_ITEM_NEW" = TO_NCLOB("CONFIGURATION_ITEM")';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS MODIFY   "CONFIGURATION_ITEM_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS DROP     COLUMN "CONFIGURATION_ITEM"';
                EXECUTE IMMEDIATE 'ALTER TABLE JOC_CONFIGURATIONS RENAME   COLUMN "CONFIGURATION_ITEM_NEW" TO "CONFIGURATION_ITEM"';
            END IF;
        END;
        
        -- MON_ORDER_STEPS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='MON_ORDER_STEPS' AND COLUMN_NAME='END_VARIABLES' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS ADD      "END_VARIABLES_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE MON_ORDER_STEPS      SET      "END_VARIABLES_NEW" = TO_NCLOB("END_VARIABLES")';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS DROP     COLUMN "END_VARIABLES"';
                EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS RENAME   COLUMN "END_VARIABLES_NEW" TO "END_VARIABLES"';
            END IF;
        END;
        
        -- SEARCH_WORKFLOWS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='ARGS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS ADD      "ARGS_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE SEARCH_WORKFLOWS      SET      "ARGS_NEW" = TO_NCLOB("ARGS")';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY   "ARGS_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS DROP     COLUMN "ARGS"';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS RENAME   COLUMN "ARGS_NEW" TO "ARGS"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='INSTRUCTIONS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS ADD      "INSTRUCTIONS_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE SEARCH_WORKFLOWS      SET      "INSTRUCTIONS_NEW" = TO_NCLOB("INSTRUCTIONS")';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY   "INSTRUCTIONS_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS DROP     COLUMN "INSTRUCTIONS"';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS RENAME   COLUMN "INSTRUCTIONS_NEW" TO "INSTRUCTIONS"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='INSTRUCTIONS_ARGS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS ADD      "INSTRUCTIONS_ARGS_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE SEARCH_WORKFLOWS      SET      "INSTRUCTIONS_ARGS_NEW" = TO_NCLOB("INSTRUCTIONS_ARGS")';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY   "INSTRUCTIONS_ARGS_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS DROP     COLUMN "INSTRUCTIONS_ARGS"';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS RENAME   COLUMN "INSTRUCTIONS_ARGS_NEW" TO "INSTRUCTIONS_ARGS"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='JOBS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS ADD      "JOBS_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE SEARCH_WORKFLOWS      SET      "JOBS_NEW" = TO_NCLOB("JOBS")';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY   "JOBS_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS DROP     COLUMN "JOBS"';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS RENAME   COLUMN "JOBS_NEW" TO "JOBS"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='SEARCH_WORKFLOWS' AND COLUMN_NAME='JOBS_SCRIPTS' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS ADD      "JOBS_SCRIPTS_NEW" NCLOB';
                EXECUTE IMMEDIATE 'UPDATE SEARCH_WORKFLOWS      SET      "JOBS_SCRIPTS_NEW" = TO_NCLOB("JOBS_SCRIPTS")';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS MODIFY   "JOBS_SCRIPTS_NEW" NOT NULL';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS DROP     COLUMN "JOBS_SCRIPTS"';
                EXECUTE IMMEDIATE 'ALTER TABLE SEARCH_WORKFLOWS RENAME   COLUMN "JOBS_SCRIPTS_NEW" TO "JOBS_SCRIPTS"';
            END IF;
        END;
        
        -- XMLEDITOR_CONFIGURATIONS
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_DRAFT' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS ADD      "CONF_DRAFT_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE XMLEDITOR_CONFIGURATIONS      SET      "CONF_DRAFT_NEW" = TO_NCLOB("CONFIGURATION_DRAFT")';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS DROP     COLUMN "CONFIGURATION_DRAFT"';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS RENAME   COLUMN "CONF_DRAFT_NEW" TO "CONFIGURATION_DRAFT"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_DRAFT_JSON' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS ADD      "CONF_DRAFT_JSON_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE XMLEDITOR_CONFIGURATIONS      SET      "CONF_DRAFT_JSON_NEW" = TO_NCLOB("CONFIGURATION_DRAFT_JSON")';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS DROP     COLUMN "CONFIGURATION_DRAFT_JSON"';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS RENAME   COLUMN "CONF_DRAFT_JSON_NEW" TO "CONFIGURATION_DRAFT_JSON"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_RELEASED' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS ADD      "CONF_RELEASED_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE XMLEDITOR_CONFIGURATIONS      SET      "CONF_RELEASED_NEW" = TO_NCLOB("CONFIGURATION_RELEASED")';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS DROP     COLUMN "CONFIGURATION_RELEASED"';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS RENAME   COLUMN "CONF_RELEASED_NEW" TO "CONFIGURATION_RELEASED"';
            END IF;
        END;
        
        DECLARE old_columns number;
        BEGIN
            SELECT COUNT(*) INTO old_columns FROM USER_TAB_COLUMNS WHERE "TABLE_NAME"='XMLEDITOR_CONFIGURATIONS' AND COLUMN_NAME='CONFIGURATION_RELEASED_JSON' AND DATA_TYPE = 'CLOB';
            IF (old_columns > 0) THEN
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS ADD      "CONF_RELEASED_JSON_NEW" NCLOB NULL';
                EXECUTE IMMEDIATE 'UPDATE XMLEDITOR_CONFIGURATIONS      SET      "CONF_RELEASED_JSON_NEW" = TO_NCLOB("CONFIGURATION_RELEASED_JSON")';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS DROP     COLUMN "CONFIGURATION_RELEASED_JSON"';
                EXECUTE IMMEDIATE 'ALTER TABLE XMLEDITOR_CONFIGURATIONS RENAME   COLUMN "CONF_RELEASED_JSON_NEW" TO "CONFIGURATION_RELEASED_JSON"';
            END IF;
        END;
    END IF;
END;
/

COMMIT;
/* DPL_ORDERS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'START_MODE' AND table_name = 'DPL_ORDERS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS ADD "START_MODE" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE DPL_ORDERS SET "START_MODE" = 0  where PERIOD_BEGIN is null';
        EXECUTE IMMEDIATE 'UPDATE DPL_ORDERS SET "START_MODE" = 1  where PERIOD_BEGIN is not null';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS MODIFY "START_MODE" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ORDER_PARAMETERISATION' AND table_name = 'DPL_ORDERS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS ADD "ORDER_PARAMETERISATION" NVARCHAR2(1000) NULL';
    END IF;
END;
/

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'MESSAGE' AND table_name = 'DPL_ORDERS';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS DROP COLUMN "MESSAGE"';
    END IF;
END;
/

COMMIT;

/* DPL_ORDERS drop indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'UNIQUE_DO_CWOP';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDERS DROP CONSTRAINT UNIQUE_DO_CWOP';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_PSTART';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_O_PSTART';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_ORDER_ID';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_O_ORDER_ID';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_START_MODE';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_O_START_MODE';
    END IF;
END;
/

/* DPL_ORDERS add indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_SHID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_SHID ON DPL_ORDERS("SUBMISSION_HISTORY_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_ON';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_ON ON DPL_ORDERS("ORDER_NAME")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_OID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_OID ON DPL_ORDERS("ORDER_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_PSCID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_PSCID ON DPL_ORDERS("PLANNED_START","CONTROLLER_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDERS' AND INDEX_NAME = 'IDX_DPL_O_WN';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_O_WN ON DPL_ORDERS("WORKFLOW_NAME")';
    END IF;
END;
/

/* DPL_HISTORY drop indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_HISTORY' AND INDEX_NAME = 'IDX_DPL_DPDATE';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_DPDATE';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_HISTORY' AND INDEX_NAME = 'IDX_DPL_CATEGORY';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_CATEGORY';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_HISTORY' AND INDEX_NAME = 'IDX_DPL_OH_ORDER_ID';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_OH_ORDER_ID';
    END IF;
END;
/

/* DPL_HISTORY add indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_HISTORY' AND INDEX_NAME = 'IDX_DPL_H_DPDSCID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_H_DPDSCID ON DPL_HISTORY("DAILY_PLAN_DATE","SUBMITTED","CONTROLLER_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_HISTORY' AND INDEX_NAME = 'IDX_DPL_H_OID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_H_OID ON DPL_HISTORY("ORDER_ID")';
    END IF;
END;
/

/* DPL_SUBMISSIONS add indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_SUBMISSIONS' AND INDEX_NAME = 'IDX_DPL_S_SFDCID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_S_SFDCID ON DPL_SUBMISSIONS("SUBMISSION_FOR_DATE","CONTROLLER_ID")';
    END IF;
END;
/
/* DPL_ORDER_VARIABLES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ORDER_ID' AND table_name = 'DPL_ORDER_VARIABLES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'DELETE FROM DPL_ORDER_VARIABLES WHERE "PLANNED_ORDER_ID" NOT IN (SELECT "ID" FROM DPL_ORDERS)';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES ADD "CONTROLLER_ID" NVARCHAR2(100) NULL';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES ADD "ORDER_ID" NVARCHAR2(255) NULL';
        EXECUTE IMMEDIATE 'UPDATE DPL_ORDER_VARIABLES ov SET ov."CONTROLLER_ID" = (SELECT o."CONTROLLER_ID" FROM DPL_ORDERS o WHERE o."ID"=ov."PLANNED_ORDER_ID"), ov."ORDER_ID" = (SELECT o."ORDER_ID" FROM DPL_ORDERS o WHERE o."ID"=ov."PLANNED_ORDER_ID") WHERE EXISTS(SELECT o."ORDER_ID" FROM DPL_ORDERS o WHERE o."ID"=ov."PLANNED_ORDER_ID")';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES MODIFY "CONTROLLER_ID" NOT NULL';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES MODIFY "ORDER_ID" NOT NULL';
    END IF;
END;
/

COMMIT;

/* DPL_ORDER_VARIABLES add indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDER_VARIABLES' AND INDEX_NAME = 'IDX_DPL_OV_OIDCID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_DPL_OV_OIDCID ON DPL_ORDER_VARIABLES("ORDER_ID","CONTROLLER_ID")';
    END IF;
END;
/

COMMIT;

/* DPL_ORDER_VARIABLES drop indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'DPL_ORDER_VARIABLES' AND INDEX_NAME = 'IDX_DPL_OV_POID';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_DPL_OV_POID';
    END IF;
END;
/

COMMIT;

/* DPL_ORDER_VARIABLES drop columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'PLANNED_ORDER_ID' AND table_name = 'DPL_ORDER_VARIABLES';
    IF (column_exist > 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES DROP COLUMN "PLANNED_ORDER_ID"';
    END IF;
END;
/

COMMIT;
/* DPL_ORDER_VARIABLES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'DPL_ORDER_VARIABLES' AND column_name = 'VARIABLE_VALUE' AND upper(data_type)='NCLOB';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES RENAME COLUMN "VARIABLE_VALUE" TO "VARIABLE_VALUE_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES ADD "VARIABLE_VALUE" NCLOB NULL';
        EXECUTE IMMEDIATE 'UPDATE DPL_ORDER_VARIABLES SET "VARIABLE_VALUE" = "VARIABLE_VALUE_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES MODIFY "VARIABLE_VALUE" NOT NULL';
        EXECUTE IMMEDIATE 'ALTER TABLE DPL_ORDER_VARIABLES DROP COLUMN "VARIABLE_VALUE_OLD"';
    END IF;
END;
/

COMMIT;
/* DEP_HISTORY */
/* DROP CONSTRAINT UNIQUE_DH_NTCC */
DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_DH_NTCC';
    IF (constraint_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE DEP_HISTORY DROP CONSTRAINT UNIQUE_DH_NTCC';
    END IF;
END;
/
COMMIT;
/* HISTORY_AGENTS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_AGENTS' AND column_name = 'AGENT_ID' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY AGENT_ID NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_AGENTS' AND column_name = 'URI' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_AGENTS MODIFY URI NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

/* HISTORY_ORDERS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDERS' AND column_name = 'END_RETURN_CODE';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS ADD "END_RETURN_CODE" NUMBER(10) NULL';
    END IF;
END;
/

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDERS' AND column_name = 'END_MESSAGE';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS ADD "END_MESSAGE" NVARCHAR2(500) NULL';
    END IF;
END;
/

/* HISTORY_ORDERS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'HISTORY_ORDERS' AND INDEX_NAME = 'IDX_HO_WPAT';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_HO_WPAT';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'HISTORY_ORDERS' AND index_name = 'IDX_HO_WPATH';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_WPATH ON HISTORY_ORDERS("WORKFLOW_PATH")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'HISTORY_ORDERS' AND index_name = 'IDX_HO_LID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_LID ON HISTORY_ORDERS("LOG_ID")';
    END IF;
END;
/

DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'HISTORY_ORDERS' AND index_name = 'IDX_HO_WNAME';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_HO_WNAME ON HISTORY_ORDERS("WORKFLOW_NAME")';
    END IF;
END;
/

/* HISTORY_ORDER_STEPS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'AGENT_ID' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY AGENT_ID NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'AGENT_URI' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS MODIFY AGENT_URI NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'JOB_NOTIFICATION';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS ADD "JOB_NOTIFICATION" NVARCHAR2(1000) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'AGENT_NAME';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS ADD "AGENT_NAME" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDER_STEPS' AND column_name = 'SUBAGENT_CLUSTER_ID';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_STEPS ADD "SUBAGENT_CLUSTER_ID" NVARCHAR2(255) NULL';
    END IF;
END;
/

/* HISTORY_ORDER_STEPS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'HISTORY_ORDER_STEPS' AND index_name = 'IDX_HOSTEPS_WNAME';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_HOSTEPS_WNAME ON HISTORY_ORDER_STEPS("WORKFLOW_NAME")';
    END IF;
END;
/

COMMIT;

/* HISTORY_LOGS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'HISTORY_LOGS' AND index_name = 'IDX_HLOGS_HOMPID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_HLOGS_HOMPID ON HISTORY_LOGS("HO_MAIN_PARENT_ID")';
    END IF;
END;
/

COMMIT;

/* DROP tables */
DECLARE table_exist number;
BEGIN
    SELECT COUNT(*) INTO table_exist FROM USER_TABLES WHERE table_name = 'HISTORY_TEMP_LOGS';
    IF (table_exist > 0) THEN
        EXECUTE IMMEDIATE 'DROP TABLE HISTORY_TEMP_LOGS';
    END IF;
END;
/

COMMIT;

/* add HISTORY_ORDER_TAGS.GROUP_ID */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'GROUP_ID' AND table_name = 'HISTORY_ORDER_TAGS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_TAGS ADD "GROUP_ID" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE HISTORY_ORDER_TAGS SET "GROUP_ID" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_TAGS MODIFY "GROUP_ID" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

/* add HISTORY_ORDER_TAGS.DAILY_PLAN_DATE */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DAILY_PLAN_DATE' AND table_name = 'HISTORY_ORDER_TAGS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDER_TAGS ADD "DAILY_PLAN_DATE" DATE NULL';
        EXECUTE IMMEDIATE 'UPDATE HISTORY_ORDER_TAGS SET "DAILY_PLAN_DATE" = TO_DATE(SUBSTR("ORDER_ID", 2, 10), ''YYYY-MM-DD'')';
    END IF;
END;
/

COMMIT;
/* HISTORY_ORDERS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'HISTORY_ORDERS' AND column_name = 'START_VARIABLES' AND upper(data_type)='NCLOB';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS RENAME COLUMN "START_VARIABLES" TO "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS ADD "START_VARIABLES" NCLOB NULL';
        EXECUTE IMMEDIATE 'UPDATE HISTORY_ORDERS SET "START_VARIABLES" = "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE HISTORY_ORDERS DROP COLUMN "START_VARIABLES_OLD"';
    END IF;
END;
/

COMMIT;
/* INV_JS_INSTANCES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'JAVA_VERSION' AND table_name = 'INV_JS_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_JS_INSTANCES ADD "JAVA_VERSION" NVARCHAR2(30) NULL';
    END IF;
END;
/

COMMIT;

/* INV_AGENT_INSTANCES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'JAVA_VERSION' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "JAVA_VERSION" NVARCHAR2(30) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DEPLOYED' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "DEPLOYED" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_AGENT_INSTANCES SET "DEPLOYED" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "DEPLOYED" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'TITLE' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "TITLE" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'HIDDEN' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES RENAME COLUMN "DISABLED" TO "HIDDEN"';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DISABLED' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "DISABLED" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_AGENT_INSTANCES SET "DISABLED" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "DISABLED" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ORDERING' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "ORDERING" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_AGENT_INSTANCES SET "ORDERING" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES MODIFY "ORDERING" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'PROCESS_LIMIT' AND table_name = 'INV_AGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_AGENT_INSTANCES ADD "PROCESS_LIMIT" NUMBER(10) NULL';
    END IF;
END;
/

COMMIT;

/* INV_SUBAGENT_INSTANCES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DISABLED' AND table_name = 'INV_SUBAGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_INSTANCES ADD "DISABLED" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_INSTANCES SET "DISABLED" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_INSTANCES MODIFY "DISABLED" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'DEPLOYED' AND table_name = 'INV_SUBAGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_INSTANCES ADD "DEPLOYED" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_INSTANCES SET "DEPLOYED" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_INSTANCES MODIFY "DEPLOYED" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'TITLE' AND table_name = 'INV_SUBAGENT_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_INSTANCES ADD "TITLE" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'ORDERING' AND table_name = 'INV_SUBAGENT_CLUSTERS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS ADD "ORDERING" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_CLUSTERS SET "ORDERING" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS MODIFY "ORDERING" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/
COMMIT;

DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ISC_AC';
    IF (constraint_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS DROP CONSTRAINT UNIQUE_ISC_AC';
    END IF;
END;
/
COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'CONTROLLER_ID' AND table_name = 'INV_SUBAGENT_CLUSTERS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS ADD "CONTROLLER_ID" NVARCHAR2(100) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_CLUSTERS sc SET sc."CONTROLLER_ID" = (SELECT ai."CONTROLLER_ID" FROM INV_AGENT_INSTANCES ai WHERE ai."AGENT_ID"=sc."AGENT_ID")';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS MODIFY "CONTROLLER_ID" NVARCHAR2(100) DEFAULT '''' NOT NULL';
    END IF;
END;
/
COMMIT;

DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ISC_CAC';
    IF (constraint_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTERS ADD CONSTRAINT UNIQUE_ISC_CAC UNIQUE ("CONTROLLER_ID", "SUBAGENT_CLUSTER_ID")';
    END IF;
END;
/
COMMIT;

DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ISCM_CS';
    IF (constraint_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS DROP CONSTRAINT UNIQUE_ISCM_CS';
    END IF;
END;
/
COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'CONTROLLER_ID' AND table_name = 'INV_SUBAGENT_CLUSTER_MEMBERS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS ADD "CONTROLLER_ID" NVARCHAR2(100) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_CLUSTER_MEMBERS scm SET scm."CONTROLLER_ID" = (SELECT sc."CONTROLLER_ID" FROM INV_SUBAGENT_CLUSTERS sc WHERE sc."SUBAGENT_CLUSTER_ID"=scm."SUBAGENT_CLUSTER_ID")';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS MODIFY "CONTROLLER_ID" NVARCHAR2(100) DEFAULT '''' NOT NULL';
    END IF;
END;
/
COMMIT;

DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ISCM_CCS';
    IF (constraint_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS ADD CONSTRAINT UNIQUE_ISCM_CCS UNIQUE ("CONTROLLER_ID", "SUBAGENT_CLUSTER_ID", "SUBAGENT_ID")';
    END IF;
END;
/
COMMIT;


/* INV_CONFIGURATIONS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'REPO_CTRL' AND table_name = 'INV_CONFIGURATIONS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS ADD "REPO_CTRL" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_CONFIGURATIONS SET "REPO_CTRL" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_CONFIGURATIONS MODIFY "REPO_CTRL" NUMBER(1) DEFAULT 0 NOT NULL';
    END IF;
END;
/
COMMIT;

/* INV_CERTS */
/* DROP CONSTRAINT UNIQUE_ICS_KTC */
DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ICS_KTC';
    IF (constraint_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_CERTS DROP CONSTRAINT UNIQUE_ICS_KTC';
    END IF;
END;
/
COMMIT;

/* add CONSTRAINT UNIQUE_ICS_KTCAS */
DECLARE constraint_exist number;
BEGIN
    SELECT count(*) INTO constraint_exist FROM user_constraints WHERE constraint_name = 'UNIQUE_ICS_KTCAS';
    IF (constraint_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_CERTS ADD CONSTRAINT UNIQUE_ICS_KTCAS UNIQUE ("KEY_TYPE", "CA", "ACCOUNT", "SECLVL")';
    END IF;
END;
/
COMMIT;

/* modify INV_SUBAGENT_CLUSTER_MEMBERS.PRIORITY */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'INV_SUBAGENT_CLUSTER_MEMBERS' AND column_name = 'PRIORITY' AND upper(data_type)='NUMBER';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS ADD    "PRIORITY_NEW" NVARCHAR2(255)';
        EXECUTE IMMEDIATE 'UPDATE INV_SUBAGENT_CLUSTER_MEMBERS      SET    "PRIORITY_NEW" = TO_CHAR("PRIORITY")';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS DROP COLUMN "PRIORITY"';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_SUBAGENT_CLUSTER_MEMBERS RENAME COLUMN "PRIORITY_NEW" TO "PRIORITY"';
    END IF;
END;
/
COMMIT;

/* add INV_TAGS.GROUP_ID */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'GROUP_ID' AND table_name = 'INV_TAGS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_TAGS ADD "GROUP_ID" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_TAGS SET "GROUP_ID" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_TAGS MODIFY "GROUP_ID" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/
COMMIT;

/* add INV_JOB_TAGS.GROUP_ID */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'GROUP_ID' AND table_name = 'INV_JOB_TAGS';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE INV_JOB_TAGS ADD "GROUP_ID" NUMBER(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE INV_JOB_TAGS SET "GROUP_ID" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE INV_JOB_TAGS MODIFY "GROUP_ID" NUMBER(10) DEFAULT 0 NOT NULL';
    END IF;
END;
/
COMMIT;

/* DROP VIEW INV_RELEASED_SCHEDULE2WORKFLOWS */
DECLARE view_exist number;
BEGIN
    SELECT COUNT(*) INTO view_exist FROM USER_VIEWS WHERE VIEW_NAME = 'INV_RELEASED_SCHEDULE2WORKFLOWS';
    IF (view_exist > 0) THEN
        EXECUTE IMMEDIATE 'DROP VIEW INV_RELEASED_SCHEDULE2WORKFLOWS';
    END IF;
END;
/

COMMIT;
/* JOC_INSTANCES Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'CLUSTER_ID' AND table_name = 'JOC_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES ADD "CLUSTER_ID" NVARCHAR2(10) NULL';
        EXECUTE IMMEDIATE 'UPDATE JOC_INSTANCES SET "CLUSTER_ID" = ''${jocClusterId}''';
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "CLUSTER_ID" NVARCHAR2(10) NOT NULL';
    END IF;
END;
/
COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'API_SERVER' AND table_name = 'JOC_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES ADD "API_SERVER" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE JOC_INSTANCES SET "API_SERVER" = 0';
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES MODIFY "API_SERVER" NUMBER(1) NOT NULL';
    END IF;
END;
/
COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'VERSION' AND table_name = 'JOC_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES ADD "VERSION" NVARCHAR2(30) NULL';
    END IF;
END;
/
COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE column_name = 'CERTIFICATE' AND table_name = 'JOC_INSTANCES';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE JOC_INSTANCES ADD "CERTIFICATE" VARCHAR2(4000) NULL';
    END IF;
END;
/
COMMIT;
/* MON_NOTIFICATIONS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_NOTIFICATIONS' AND column_name = 'WARN';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOTIFICATIONS ADD "WARN" NUMBER(3) NULL';
        EXECUTE IMMEDIATE 'UPDATE MON_NOTIFICATIONS SET "WARN"=0';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOTIFICATIONS MODIFY "WARN" NUMBER(3) NOT NULL';
    END IF;
END;
/

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_NOTIFICATIONS' AND column_name = 'WARN_TEXT';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOTIFICATIONS ADD "WARN_TEXT" NVARCHAR2(500) NULL';
    END IF;
END;
/

/* MON_ORDERS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDERS' AND column_name = 'END_RETURN_CODE';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS ADD "END_RETURN_CODE" NUMBER(10) NULL';
    END IF;
END;
/

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDERS' AND column_name = 'END_MESSAGE';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS ADD "END_MESSAGE" NVARCHAR2(500) NULL';
    END IF;
END;
/

/* MON_ORDERS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'MON_ORDERS' AND index_name = 'IDX_MONO_MPID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONO_MPID ON MON_ORDERS("MAIN_PARENT_ID")';
    END IF;
END;
/

/* MON_ORDER_STEPS drop index */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'MON_ORDER_STEPS' AND INDEX_NAME = 'IDX_MONOS_W';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_MONOS_W';
    END IF;
END;
/

/* MON_ORDER_STEPS indexes */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'MON_ORDER_STEPS' AND index_name = 'IDX_MONOS_HMPID';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONOS_HMPID ON MON_ORDER_STEPS("HO_MAIN_PARENT_ID")';
    END IF;
END;
/

/* MON_ORDER_STEPS Columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'AGENT_ID' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY AGENT_ID NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'AGENT_URI' AND upper(data_type)='NVARCHAR2' AND char_col_decl_length=100;
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS MODIFY AGENT_URI NVARCHAR2(255)';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'JOB_NOTIFICATION';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS ADD "JOB_NOTIFICATION" NVARCHAR2(1000) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'AGENT_NAME';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS ADD "AGENT_NAME" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'SUBAGENT_CLUSTER_ID';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS ADD "SUBAGENT_CLUSTER_ID" NVARCHAR2(255) NULL';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'WARN';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS DROP COLUMN "WARN"';
    END IF;
END;
/

COMMIT;

DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDER_STEPS' AND column_name = 'WARN_TEXT';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDER_STEPS DROP COLUMN "WARN_TEXT"';
    END IF;
END;
/

/* Table for MON_NOT_MONITORS */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_NOT_MONITORS' AND column_name = 'MESSAGE' AND upper(CHAR_USED)='B';
    IF (column_exist = 1) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS MODIFY MESSAGE VARCHAR2(4000 CHAR)';
    END IF;
END;
/

COMMIT;
/* starting with JS7 release 2.5.2 (JOC-1447) - MON_SYSNOTIFICATIONS related changes */

/* MON_NOT_MONITORS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_NOT_MONITORS' AND column_name = 'APPLICATION';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS ADD "APPLICATION" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE MON_NOT_MONITORS SET "APPLICATION"=0';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_MONITORS MODIFY "APPLICATION" NUMBER(1) NOT NULL';
    END IF;
END;
/

/* MON_NOT_MONITORS drop index */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE TABLE_NAME = 'MON_NOT_MONITORS' AND INDEX_NAME = 'IDX_MONM_NID';
    IF (index_exist = 1) THEN
        EXECUTE IMMEDIATE 'DROP INDEX IDX_MONM_NID';
    END IF;
END;
/

/* MON_NOT_MONITORS create index */
DECLARE index_exist number;
BEGIN
    SELECT COUNT(*) INTO index_exist FROM USER_INDEXES WHERE table_name = 'MON_NOT_MONITORS' AND index_name = 'IDX_MONM_NIDA';
    IF (index_exist = 0) THEN
        EXECUTE IMMEDIATE 'CREATE INDEX IDX_MONM_NIDA ON MON_NOT_MONITORS("NOT_ID","APPLICATION")';
    END IF;
END;
/

/* MON_NOT_ACKNOWLEDGEMENTS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_NOT_ACKNOWLEDGEMENTS' AND column_name = 'APPLICATION';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS ADD "APPLICATION" NUMBER(1) NULL';
        EXECUTE IMMEDIATE 'UPDATE MON_NOT_ACKNOWLEDGEMENTS SET "APPLICATION"=0';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS MODIFY "APPLICATION" NUMBER(1) NOT NULL';
    END IF;
END;
/

/* MON_NOT_ACKNOWLEDGEMENTS primary key */
DECLARE count_constraints number; c_name varchar2(100);
BEGIN
    SELECT constraint_name into c_name FROM user_constraints WHERE UPPER(table_name) = UPPER('MON_NOT_ACKNOWLEDGEMENTS') AND CONSTRAINT_TYPE = 'P';
    SELECT COUNT(*) INTO count_constraints FROM all_cons_columns WHERE constraint_name = c_name;
    IF (count_constraints <> 2) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS DROP CONSTRAINT '|| c_name;
        EXECUTE IMMEDIATE 'ALTER TABLE MON_NOT_ACKNOWLEDGEMENTS ADD PRIMARY KEY("NOT_ID","APPLICATION")';
    END IF;
END;
/
/* MON_ORDERS columns */
DECLARE column_exist number;
BEGIN
    SELECT COUNT(*) INTO column_exist FROM USER_TAB_COLS WHERE table_name = 'MON_ORDERS' AND column_name = 'START_VARIABLES' AND upper(data_type)='NCLOB';
    IF (column_exist = 0) THEN
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS RENAME COLUMN "START_VARIABLES" TO "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS ADD "START_VARIABLES" NCLOB NULL';
        EXECUTE IMMEDIATE 'UPDATE MON_ORDERS SET "START_VARIABLES" = "START_VARIABLES_OLD"';
        EXECUTE IMMEDIATE 'ALTER TABLE MON_ORDERS DROP COLUMN "START_VARIABLES_OLD"';
    END IF;
END;
/

COMMIT;
/*
 | Insert Script for default authentication account root:root for identity services
 | SOS GmbH, 2021-12-12
*/

/* import default */



DECLARE c1 number; 
  c2 number;
  c3 number;
  c4 number;
  c5 number; 

BEGIN 
SELECT COUNT(*) INTO c1 FROM IAM_IDENTITY_SERVICES;  
SELECT COUNT(*) INTO c2 FROM IAM_ACCOUNT2ROLES; 
SELECT COUNT(*) INTO c3 FROM IAM_ACCOUNT2ROLES;   
SELECT COUNT(*) INTO c4 FROM IAM_ACCOUNTS; 
SELECT COUNT(*) INTO c5 FROM IAM_ROLES; 

IF c1 = 0 and c2 = 0 and c3 = 0 and c4 = 0 and c5 = 0 THEN 
EXECUTE IMMEDIATE 
'INSERT INTO IAM_IDENTITY_SERVICES("ID","IDENTITY_SERVICE_TYPE", "IDENTITY_SERVICE_NAME","REQUIRED","DISABLED", "AUTHENTICATION_SCHEME","SECOND_FACTOR", "ORDERING") VALUES (SEQ_IAM_IDENTITY_SERVICES.NEXTVAL,''JOC'',''JOC-INITIAL'',0,0,''SINGLE'',0,0)'; 
EXECUTE IMMEDIATE 
'INSERT INTO IAM_ACCOUNTS("ID","IDENTITY_SERVICE_ID", "ACCOUNT_NAME","ACCOUNT_PASSWORD","FORCE_PASSWORD_CHANGE") VALUES (SEQ_IAM_ACCOUNTS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,''root'',''$JS7-1.0$65536$9aRojy9RBlLyf40BVcE+pg==$QLXLz0CHFaYDNeIE3ioZIOAGoBy5xo2rTmp7i38DEEF5cK22MzpAL89jA2USWv5KfTth8yprRkvIk+iWS+q3Aw=='',1)'; 
EXECUTE IMMEDIATE 
'INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,''all'')'; 
EXECUTE IMMEDIATE 
'INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,''sos:products'',0,0)'; 
EXECUTE IMMEDIATE 
'INSERT INTO IAM_ACCOUNT2ROLES("ID","ROLE_ID", "ACCOUNT_ID") VALUES (SEQ_IAM_ACCOUNT2ROLES.NEXTVAL,SEQ_IAM_ROLES.CURRVAL,SEQ_IAM_ACCOUNTS.CURRVAL)'; 

 

/*
 Administrator
*/
INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'administrator');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration',0,0);



INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:cluster:manage',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:inventory:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:notification',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:others',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:restart',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:terminate',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:switch_over',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:agents:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:deployment:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:locks:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:workflows:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:orders:view',0,0);

/*
 application_manager
*/
INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'application_manager');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:customization',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:settings',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:filetransfer',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:inventory',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:notification:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:agents:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:deployment',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:locks:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:workflows:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:orders',0,0);
 
/*
 it_operator
*/
 
INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'it_operator');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:customization',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:settings:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:filetransfer',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:inventory:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:notification:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:agents:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:deployment:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:locks:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:workflows:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:orders',0,0);


/*
 incident_manager
*/
 
INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'incident_manager');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:accounts',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:customization',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:settings',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:filetransfer',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:inventory',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:notification',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:others',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller',0,0);



/*
 business_user
*/

INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'business_user');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:administration:customization:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:filetransfer:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:agents:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:locks:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:workflows:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:orders:view',0,0);



/*
 api_user
*/

INSERT INTO IAM_ROLES("ID","IDENTITY_SERVICE_ID", "ROLE_NAME") VALUES (SEQ_IAM_ROLES.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,'api_user');
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:auditlog:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:calendars:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:dailyplan:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:documentations:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:joc:filetransfer:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:agents:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:deployment:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:locks:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:workflows:view',0,0);
INSERT INTO IAM_PERMISSIONS("ID","IDENTITY_SERVICE_ID","ROLE_ID","ACCOUNT_PERMISSION", "EXCLUDED","RECURSIVE") VALUES (SEQ_IAM_PERMISSIONS.NEXTVAL,SEQ_IAM_IDENTITY_SERVICES.CURRVAL,SEQ_IAM_ROLES.CURRVAL,'sos:products:controller:orders:view',0,0);
 



END IF;END;

/
 
 
COMMIT;
 
 

/* set Security Level */
UPDATE INV_JS_INSTANCES SET "SECURITY_LEVEL" = 0 WHERE "SECURITY_LEVEL" <> 0;
COMMIT;

/* delete/insert version */
DELETE FROM JOC_VARIABLES WHERE "NAME"='version';
INSERT INTO JOC_VARIABLES ("NAME", "NUMERIC_VALUE", "TEXT_VALUE", "BINARY_VALUE") VALUES ('version',NULL,'2.7.5.2',NULL);
COMMIT;
/*
 | Insert Script for default Keys for SecurityLevel LOW and MEDIUM
 | SOS GmbH, 2021-05-22
*/

/*
 | ATTENTION:
 | The "SECLVL" field contains the security level (0=LOW, 1=MEDUIM, 2=HIGH).
 | This value MUST match the security level selected in the setup.
 | If the following two INSERT statements are to be executed before the setup, then the value of "SECLVL" may have to be adjusted.
 | 
 | DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM DEP_KEYS ... AND "SECLVL"=[number of security level];
 | INSERT INTO DEP_KEYS( ... , [number of security level])
 | INSERT INTO INV_CERTS( ... , [number of security level])
*/

DECLARE
  c NUMBER := 0; 
  /* import default */
  current_cert  VARCHAR2(4000) := '-----BEGIN CERTIFICATE-----' || chr(10) || 'MIIEDjCCAfagAwIBAgIJAMxQSEdXteqVMA0GCSqGSIb3DQEBCwUAMIGNMQswCQYD' || chr(10) || 'VQQGEwJERTEPMA0GA1UECAwGQmVybGluMQ8wDQYDVQQHDAZCZXJsaW4xDDAKBgNV' || chr(10) || 'BAoMA1NPUzELMAkGA1UECwwCSVQxHDAaBgNVBAMME1NPUyBJbnRlcm1lZGlhdGUg' || chr(10) || 'Q0ExIzAhBgkqhkiG9w0BCQEWFGFkbWluQHNvcy1iZXJsaW4uY29tMB4XDTI1MDQy' || chr(10) || 'ODExMTUwM1oXDTMwMDYxNTExMTUwM1owbDELMAkGA1UEBhMCREUxDzANBgNVBAgM' || chr(10) || 'BkJlcmxpbjEPMA0GA1UEBwwGQmVybGluMQwwCgYDVQQKDANTT1MxCzAJBgNVBAsM' || chr(10) || 'AklUMQ8wDQYDVQQDDAZzb3MtZWMxDzANBgNVBC4TBlNPUyBDQTBZMBMGByqGSM49' || chr(10) || 'AgEGCCqGSM49AwEHA0IABFTf+XE54Wl99SuR4dDd7IDHyl2NyZLRy7xcV059qz4L' || chr(10) || 'aCgHn9DYwb0gORie7jOPM5cl9ya2qkjw5Hlyai50HcOjXDBaMBEGCWCGSAGG+EIB' || chr(10) || 'AQQEAwIEEDAOBgNVHQ8BAf8EBAMCBeAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMw' || chr(10) || 'HQYDVR0OBBYEFBORoUzmc2PORMqo/hYc58JFDVqHMA0GCSqGSIb3DQEBCwUAA4IC' || chr(10) || 'AQDBI2kcWoz3MjRi15dhHQBxFbLz5F+ObYuivT0Rp21K1HJGnGakDYqMLiBNZLbX' || chr(10) || '35pSd3bEA85amNwsrknoxo1qDUk5rl+d+uaflBj0aIrOHPAO8gJPT1s7foaP6gAM' || chr(10) || 'UitsAMKbba1oGg91LoahOZ9x3uRT33g2IIwsuE81XGIz05A6l3mXor531vNsxXQE' || chr(10) || 'ummLoUqDykutSqe8XihjKuAeUhyBli8YVBwDSzGEeratoeorXgZ4P9NdTPdbYJ50' || chr(10) || 'oRCvHGKzI941pNcfR/3PClE9oGHvYJHifCNINcKdeJjc59+JawesujNdzwkO9iGZ' || chr(10) || 'NvQbCNtKZijDQO3Hw9CrBjfT/miuHu25mcS4dQ47xL5fV2x8zNXqSxKmN/zcSkI6' || chr(10) || 'YUtQ+hBV5YJUFKcXkOJh3rnA3NzeOQS0TsNLu9qUcu/5nhlM32zgYziSnzODa4gS' || chr(10) || 'CV3SnYE1JlnQFhMt4950Z10NEzVJ/upLThpy0EhAhjabv7CsQX2wasrzmhKFTsjo' || chr(10) || 'yGQ0syaesYL3fZx6bzC77X0KACGdY/qRYcByToehHtiW23yW9E1KF5SqrvgQbUgz' || chr(10) || '21lSHVo0EfHMoSdh7JGzG+/XPDAkT5TpW1g45uLDP7JAL0Tt6OpqdfyicVMAa49D' || chr(10) || 'gJlvDou4ZSth/gcuZ26Ph6JX8z09Umcj19Juj0roA7ukmg==' || chr(10) || '-----END CERTIFICATE-----';
  outdated_cert VARCHAR2(4000) := '-----BEGIN CERTIFICATE-----' || chr(10) || 'MIID1zCCAb+gAwIBAgIJAMxQSEdXteoRMA0GCSqGSIb3DQEBCwUAMIGNMQswCQYD' || chr(10) || 'VQQGEwJERTEPMA0GA1UECAwGQmVybGluMQ8wDQYDVQQHDAZCZXJsaW4xDDAKBgNV' || chr(10) || 'BAoMA1NPUzELMAkGA1UECwwCSVQxHDAaBgNVBAMME1NPUyBJbnRlcm1lZGlhdGUg' || chr(10) || 'Q0ExIzAhBgkqhkiG9w0BCQEWFGFkbWluQHNvcy1iZXJsaW4uY29tMB4XDTIwMTAx' || chr(10) || 'MzEyNTA1NVoXDTI1MTAxMjEyNTA1NVowbDELMAkGA1UEBhMCREUxDzANBgNVBAgM' || chr(10) || 'BkJlcmxpbjEPMA0GA1UEBwwGQmVybGluMQwwCgYDVQQKDANTT1MxCzAJBgNVBAsM' || chr(10) || 'AklUMQ8wDQYDVQQDDAZzb3MtZWMxDzANBgNVBC4TBlNPUyBDQTBZMBMGByqGSM49' || chr(10) || 'AgEGCCqGSM49AwEHA0IABFTf+XE54Wl99SuR4dDd7IDHyl2NyZLRy7xcV059qz4L' || chr(10) || 'aCgHn9DYwb0gORie7jOPM5cl9ya2qkjw5Hlyai50HcOjJTAjMBEGCWCGSAGG+EIB' || chr(10) || 'AQQEAwIHgDAOBgNVHQ8BAf8EBAMCBeAwDQYJKoZIhvcNAQELBQADggIBAGC7BKCd' || chr(10) || 'kuhIzEGflG4tslnWlC7BXvbI2lKkUbDYlcBf04hYl4ootWfprFfF80LXBFgWUxGN' || chr(10) || '6HZIQDwWJch/h+UFjf/97zVxzbl0q1miZtNN2USbYK3yfrgWyOKEzZcAxUnr2pL4' || chr(10) || '9/t2LBmFKvgmh1RiB40Vf8s5frEQID2Am+I+pZsi4R7/OtwUo6dZJKP6IFlqZYzf' || chr(10) || 'klWlLMgwVK6Iqo+Lu8M2oxWRHxMCTOAQyQmVWf8ZsfzEn3k412v5tejWjQsoo057' || chr(10) || 'VCQ3p36UOl2+Qrif2PvYOz3pvdek6xwuJaqpr1fDSjEO/WSpl4Fdx0pavCFLniaN' || chr(10) || 'odP00FpH1OfwHf3XvYMCcHO+/JRlsc4uNaalEkD6n3pNbWlpJyaneEUr7GqC8TEX' || chr(10) || 'zHJ3r5SSKFxwEX/iAL5CyIgq8BUFLQtXFBiYVTMQXyUTNixo0h130bV4KMdpfLLm' || chr(10) || 'u+iekRBGM59sP5Ijfg4lvQqoMZ2Ck+BGBye/tlItgDOIh+FIIVMwfHY4KOlfaqRr' || chr(10) || 'JRzEpVkssoIVHNghl1kT3U9ZSbMtJ3W650uBtidhS0tYOXPixd5DJ8VI5cl16pwb' || chr(10) || 'DpkAS01bxgDhQrvQINzrLTXeDuY01Lr3HC8TD/NMS+p7X5CQ1KxUhgzxaPQ8LTau' || chr(10) || '9DzuuCRcbkIBI+KQl5KF8kZ2ohdw/tNOH+RK' || chr(10) || '-----END CERTIFICATE-----%';
BEGIN 
  
	SELECT COUNT(*) INTO c FROM DEP_KEYS WHERE "ACCOUNT"='root' AND "SECLVL"=0; 
  IF c = 0 AND 0 < 2 THEN EXECUTE IMMEDIATE 
    'INSERT INTO DEP_KEYS("ID","KEY_TYPE","KEY_ALG","KEY","CERTIFICATE","ACCOUNT","SECLVL") VALUES (SEQ_DEP_K.nextval,0,2,''-----BEGIN EC PRIVATE KEY-----'' || chr(10) || ''MHcCAQEEID+VjMgUjVph6n1lxu5Vx9qrhoCyMrr9vcmwKBx+MSG2oAoGCCqGSM49'' || chr(10) || ''AwEHoUQDQgAEVN/5cTnhaX31K5Hh0N3sgMfKXY3JktHLvFxXTn2rPgtoKAef0NjB'' || chr(10) || ''vSA5GJ7uM48zlyX3JraqSPDkeXJqLnQdww=='' || chr(10) || ''-----END EC PRIVATE KEY-----'', :current_cert, ''root'', 0)' using current_cert;
  ELSIF c = 0 AND 0 = 2 THEN EXECUTE IMMEDIATE
    'INSERT INTO DEP_KEYS("ID","KEY_TYPE","KEY_ALG","KEY","CERTIFICATE","ACCOUNT","SECLVL") VALUES (SEQ_DEP_K.nextval,1,2,null, :current_cert, ''root'', 0)' using current_cert;
  ELSIF c > 0 THEN EXECUTE IMMEDIATE
    'UPDATE DEP_KEYS SET "CERTIFICATE" = :current_cert WHERE "CERTIFICATE" like :outdated_cert' using current_cert, outdated_cert;
  END IF;
END;
/

DECLARE c number; BEGIN SELECT COUNT(*) INTO c FROM INV_CERTS WHERE "ACCOUNT"='root' AND "CA"=1; IF c = 0 THEN EXECUTE IMMEDIATE '
INSERT INTO INV_CERTS("ID","KEY_TYPE","KEY_ALG","PEM", "CA","ACCOUNT","SECLVL") VALUES (SEQ_INV_CRTS.nextval,1,1,''-----BEGIN CERTIFICATE-----'' || chr(10) || ''MIIGpTCCBI2gAwIBAgIRANBLkv2+/RYfqQXsW1mziIYwDQYJKoZIhvcNAQELBQAw'' || chr(10) || ''gYUxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCZXJsaW4xDzANBgNVBAcMBkJlcmxp'' || chr(10) || ''bjEMMAoGA1UECgwDU09TMQswCQYDVQQLDAJJVDEUMBIGA1UEAwwLU09TIFJvb3Qg'' || chr(10) || ''Q0ExIzAhBgkqhkiG9w0BCQEWFGFkbWluQHNvcy1iZXJsaW4uY29tMB4XDTIwMDYx'' || chr(10) || ''NzIzNDkxNFoXDTMwMDYxNTIzNDkxNFowgY0xCzAJBgNVBAYTAkRFMQ8wDQYDVQQI'' || chr(10) || ''DAZCZXJsaW4xDzANBgNVBAcMBkJlcmxpbjEMMAoGA1UECgwDU09TMQswCQYDVQQL'' || chr(10) || ''DAJJVDEcMBoGA1UEAwwTU09TIEludGVybWVkaWF0ZSBDQTEjMCEGCSqGSIb3DQEJ'' || chr(10) || ''ARYUYWRtaW5Ac29zLWJlcmxpbi5jb20wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw'' || chr(10) || ''ggIKAoICAQDGmo7XDw2Bd/Y9BmLLgNhVXh6oxuAwFpY9Bho3EbtBQp4OpeaC1irb'' || chr(10) || ''m2ID8JlGtWOvCmCv//b00Zxx7KESa1PuF1J5XCxjPzoeRvlVR/BbZtdK8IZUZdL3'' || chr(10) || ''gqWSVX9UX6Go/ghknM5LXPG7y8XhrIUA27F0ts3nYYtD/djrscTTlH6luh7lZiKK'' || chr(10) || ''x5TX52YB5it7pxkHSO7DNaBgSlbDXvK/NEthwWAIHvqunwiBchWgUbH/qrne5MBW'' || chr(10) || ''VvX2G8JCDyU8JK6Fab0InU9PB/yYWz1hDUqDhMhNvRrMLSQ0KwWkMWyEbXJoEHNA'' || chr(10) || ''xBF+7Mp2pBy8gL11i46JaKvCEv5bSPCwQ+BdGDw6Oa4bt7H/aEsKHzNekl8U6pvc'' || chr(10) || ''gpuoXQ6xY2xqLx9JLTYWKDvsMftuevPV2gqqcqqEBvISc9A2FvPN0uFmioDa9WK0'' || chr(10) || ''s7JI9HsbpqpinC4CZUpNohfkLBrzSEbf6aJx9SgE3pFDdQwd2wxVD5QngMMysFd7'' || chr(10) || ''XCQnnPx5GUrMQ/us9qSiGYjuHqiH2x9gp5hurQ8qdwwO3aCwhwjYQA+czatrbWk+'' || chr(10) || ''Fe3WSzDnZrriHIfwD0P12YDdpCx5Eh93NJDAptqn1oIRfK9z6TZjgIIbXLQg4PkA'' || chr(10) || ''KTf+LGmAQItkIQKFiVAdH7daALF01erxl/n5M6FRd2ZpVZWQd+RyKQIDAQABo4IB'' || chr(10) || ''BDCCAQAwHQYDVR0OBBYEFIlZIba80QjXo5Pm+A9P2wF46MPkMIG6BgNVHSMEgbIw'' || chr(10) || ''ga+AFGt2X2MH0PCOWlWoPjVyimGYmK/PoYGLpIGIMIGFMQswCQYDVQQGEwJERTEP'' || chr(10) || ''MA0GA1UECAwGQmVybGluMQ8wDQYDVQQHDAZCZXJsaW4xDDAKBgNVBAoMA1NPUzEL'' || chr(10) || ''MAkGA1UECwwCSVQxFDASBgNVBAMMC1NPUyBSb290IENBMSMwIQYJKoZIhvcNAQkB'' || chr(10) || ''FhRhZG1pbkBzb3MtYmVybGluLmNvbYIJAM3gM6k6sCzUMBIGA1UdEwEB/wQIMAYB'' || chr(10) || ''Af8CAQAwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4ICAQBd/NR493wc'' || chr(10) || ''2FvLHLKJwOoI7WucD7sP7L0G6NqmJ2dR3cbNRe7X4bXxugCSUD470RiWKTUVpD6O'' || chr(10) || ''/fcDawS6GgqkQI8Mn9KGSRbliqjfXaTcArt2wdNi84pbC+eLakJFqjS5SZxYzAZK'' || chr(10) || ''Zdf0UmhrPkr+C1ndShkIkVLbMsZfQD5Uu78uHDDziVwdPVYVI4Ge2nLpi9i4zx06'' || chr(10) || ''GtOHbKFmv67KdZX7sXXEzJJHc206aZ7wjRSSvh1mJsplm/yGY/jsnKAKqe1VT3hB'' || chr(10) || ''JCxTnyFN5CYEnwCTF3qdZGJchv8MG5VA9QZeLpHh+ERM/BKZlXrU70JqCpmTaDov'' || chr(10) || ''tZt1dXOS8EKOm2PbaNoXZm39ol+Ky2Co8ES8UWIb9PQV69ZP2zKXBtM0UWW17m9m'' || chr(10) || ''BqjF4EfTGlViTdalorcl2UYH/1l1rR4CtJECpPr2njZD8msSs3Jh+BDKTrmJFMxn'' || chr(10) || ''YQyWkyHxWfdR7/WxMNLh4WYx6Dw+FYqN/Hw+UMkByCRpVeIzal25AzLAvfHhzVXq'' || chr(10) || ''bCOCXxSkn3d8N6V0P30BqkbieEwQx1T2SgLIfqo3G9QJ8BRCOaK+LhVJ2NaSe9FP'' || chr(10) || ''yyRb8+sd/SHRiO6CvTxqy5iCozdgjb0SRufS01iBDMQT2r31nRn8qezRL0YMes1W'' || chr(10) || ''HwphnWeOC52Ovuw2OLv1TomJKSzujvLzpA=='' || chr(10) || ''-----END CERTIFICATE-----'', 1, ''root'', 0)
'; END IF; END;
/

COMMIT;
/*
 | Deployment views for Oracle
 | SOS GmbH, 2019-10-04
*/


/* View for current inventory at the controllers */
CREATE OR REPLACE VIEW DEP_CONFIGURATIONS_JOIN AS SELECT
    "CONTROLLER_ID",
    "NAME",
    "TYPE",
    MAX("ID") AS "MAX_ID"
FROM DEP_HISTORY
WHERE "STATE" = 0
GROUP BY
    "CONTROLLER_ID",
    "NAME",
    "TYPE";

CREATE OR REPLACE VIEW DEP_CONFIGURATIONS AS SELECT
    a."ID",
    a."NAME",
    a."TITLE",
    a."PATH",
    a."FOLDER",
    a."TYPE",
    a."INV_CID",
    a."CONTROLLER_ID",
    a."INV_CONTENT" AS "CONTENT",
    a."COMMIT_ID",
    a."DEPLOYMENT_DATE" AS "CREATED"
FROM DEP_HISTORY a
INNER JOIN DEP_CONFIGURATIONS_JOIN b
    ON a."ID" = b."MAX_ID"
    WHERE a."OPERATION" = 0;

CREATE OR REPLACE VIEW DEP_NAMEPATHS AS SELECT
    a."ID",
    a."NAME",
    a."PATH",
    a."TYPE",
    a."CONTROLLER_ID"
FROM DEP_HISTORY a
INNER JOIN DEP_CONFIGURATIONS_JOIN b
    ON a."ID" = b."MAX_ID";
/*
 | Inventory views for Oracle
 | JOC-1972 - Adding ROW_NUM to ensure a unique key for Oracle 12c compatibility; not required in newer versions
*/

CREATE OR REPLACE VIEW INV_SCHEDULE2CALENDARS AS 
    SELECT 
        ROW_NUMBER() OVER (ORDER BY c."CALENDAR_NAME", i."NAME") AS "ROW_NUM",
        CAST(c."CALENDAR_NAME" AS NVARCHAR2(255)) AS "CALENDAR_NAME",
        i."NAME"            AS "SCHEDULE_NAME",
        i."PATH"            AS "SCHEDULE_PATH",
        i."FOLDER"          AS "SCHEDULE_FOLDER",
        i."RELEASED"        AS "SCHEDULE_RELEASED"
    FROM INV_CONFIGURATIONS i,
        JSON_TABLE(i."JSON_CONTENT", '$.calendars[*]'
                COLUMNS ("CALENDAR_NAME" PATH '$.calendarName')
               ) AS c
    WHERE i."TYPE"=7;
    
CREATE OR REPLACE VIEW INV_REL_SCHEDULE2CALENDARS AS 
    SELECT 
        ROW_NUMBER() OVER (ORDER BY c."CALENDAR_NAME", i."NAME") AS "ROW_NUM",
        CAST(c."CALENDAR_NAME" AS NVARCHAR2(255)) AS "CALENDAR_NAME",
        i."NAME"            AS "SCHEDULE_NAME",
        i."PATH"            AS "SCHEDULE_PATH",
        i."FOLDER"          AS "SCHEDULE_FOLDER"
    FROM INV_RELEASED_CONFIGURATIONS i,
        JSON_TABLE(i."JSON_CONTENT", '$.calendars[*]'
                COLUMNS ("CALENDAR_NAME" PATH '$.calendarName')
               ) AS c
    WHERE i."TYPE"=7;
/*
 | Inventory views for Oracle
 | JOC-1972 - Adding ROW_NUM to ensure a unique key for Oracle 12c compatibility; not required in newer versions
*/

CREATE OR REPLACE VIEW INV_SCHEDULE2WORKFLOWS AS 
    SELECT 
        ROW_NUMBER() OVER (ORDER BY s."WORKFLOW_NAME", s."SCHEDULE_NAME") AS "ROW_NUM",
        s."WORKFLOW_NAME",
        s."SCHEDULE_NAME",
        s."SCHEDULE_PATH",
        s."SCHEDULE_FOLDER",
        s."SCHEDULE_CONTENT"        
    FROM (    
        SELECT 
            CAST(JSON_VALUE("JSON_CONTENT",'$.workflowName') AS NVARCHAR2(255)) AS "WORKFLOW_NAME",
            "NAME"          AS "SCHEDULE_NAME",
            "PATH"          AS "SCHEDULE_PATH",
            "FOLDER"        AS "SCHEDULE_FOLDER",
            "RELEASED"      AS "SCHEDULE_RELEASED",
            "JSON_CONTENT"  AS "SCHEDULE_CONTENT"
        FROM INV_CONFIGURATIONS
        WHERE "TYPE"=7
            AND JSON_QUERY("JSON_CONTENT",'$.workflowNames') IS NULL
        UNION ALL
        SELECT 
            CAST(w."WORKFLOW_NAME" AS NVARCHAR2(255)) AS "WORKFLOW_NAME",
            i."NAME"            AS "SCHEDULE_NAME",
            i."PATH"            AS "SCHEDULE_PATH",
            i."FOLDER"          AS "SCHEDULE_FOLDER",
            i."RELEASED"        AS "SCHEDULE_RELEASED",
            i."JSON_CONTENT"    AS "SCHEDULE_CONTENT"
        FROM INV_CONFIGURATIONS i,
            JSON_TABLE(i."JSON_CONTENT", '$.workflowNames[*]'
                    COLUMNS ("WORKFLOW_NAME" PATH '$')
                ) AS w
        WHERE i."TYPE"=7) s;
    
CREATE OR REPLACE VIEW INV_REL_SCHEDULE2WORKFLOWS AS 
    SELECT 
        ROW_NUMBER() OVER (ORDER BY s."WORKFLOW_NAME", s."SCHEDULE_NAME") AS "ROW_NUM",
        s."WORKFLOW_NAME",
        s."SCHEDULE_NAME",
        s."SCHEDULE_PATH",
        s."SCHEDULE_FOLDER",
        s."SCHEDULE_CONTENT"        
    FROM (    
        SELECT 
            CAST(JSON_VALUE("JSON_CONTENT",'$.workflowName') AS NVARCHAR2(255)) AS "WORKFLOW_NAME",
            "NAME"          AS "SCHEDULE_NAME",
            "PATH"          AS "SCHEDULE_PATH",
            "FOLDER"        AS "SCHEDULE_FOLDER",
            "JSON_CONTENT"  AS "SCHEDULE_CONTENT"
        FROM INV_RELEASED_CONFIGURATIONS
        WHERE "TYPE"=7
            AND JSON_QUERY("JSON_CONTENT",'$.workflowNames') IS NULL
        UNION ALL
        SELECT 
            CAST(w."WORKFLOW_NAME" AS NVARCHAR2(255)) AS "WORKFLOW_NAME",
            i."NAME"            AS "SCHEDULE_NAME",
            i."PATH"            AS "SCHEDULE_PATH",
            i."FOLDER"          AS "SCHEDULE_FOLDER",
            i."JSON_CONTENT"    AS "SCHEDULE_CONTENT"
        FROM INV_RELEASED_CONFIGURATIONS i,
            JSON_TABLE(i."JSON_CONTENT", '$.workflowNames[*]'
                    COLUMNS ("WORKFLOW_NAME" PATH '$')
                ) AS w
        WHERE i."TYPE"=7) s;
