/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

final class ByteBufferCleaner {
    private static final Cleaner INSTANCE = ByteBufferCleaner.getCleaner();

    ByteBufferCleaner() {
    }

    static void clean(ByteBuffer byteBuffer) {
        try {
            INSTANCE.clean(byteBuffer);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to clean direct buffer.", throwable);
        }
    }

    private static Cleaner getCleaner() {
        Cleaner cleaner = null;
        try {
            cleaner = new Java8Cleaner();
        }
        catch (Exception exception) {
            try {
                cleaner = new Java9Cleaner();
            }
            catch (Exception exception2) {
                System.err.println("WARNING: Failed to initialize a ByteBuffer Cleaner. This means direct ByteBuffers will only be cleaned upon garbage collection. Reason: " + exception2);
            }
        }
        if (cleaner != null) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
                cleaner.clean(byteBuffer);
            }
            catch (Throwable throwable) {
                cleaner = null;
                System.err.println("WARNING: ByteBuffer Cleaner failed to clean a test buffer. ByteBuffer Cleaner has been disabled. This means direct ByteBuffers will only be cleaned upon garbage collection. Reason: " + throwable);
            }
        }
        return cleaner;
    }

    static boolean isSupported() {
        return INSTANCE != null;
    }

    private static final class Java9Cleaner
    implements Cleaner {
        private final MethodHandle invokeCleaner;

        private Java9Cleaner() throws ReflectiveOperationException {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object object = field.get(null);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = lookup.findVirtual(clazz, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            this.invokeCleaner = methodHandle.bindTo(object);
        }

        @Override
        public void clean(ByteBuffer byteBuffer) throws Throwable {
            this.invokeCleaner.invokeExact(byteBuffer);
        }
    }

    private static final class Java8Cleaner
    implements Cleaner {
        private final Method cleanerMethod;
        private final Method cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);

        private Java8Cleaner() throws ReflectiveOperationException {
            this.cleanerMethod = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
        }

        @Override
        public void clean(ByteBuffer byteBuffer) throws Throwable {
            Object object = this.cleanerMethod.invoke((Object)byteBuffer, new Object[0]);
            if (object != null) {
                this.cleanMethod.invoke(object, new Object[0]);
            }
        }
    }

    private static interface Cleaner {
        public void clean(ByteBuffer var1) throws Throwable;
    }
}

