/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.board;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sos.controller.model.board.NoticeState;
import com.sos.joc.model.common.WorkflowTags;
import com.sos.joc.model.order.OrderV;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "key", "endOfLife", "expectingOrders", "expectingOrderIds", "workflowTagsPerWorkflow", "state"})
public class Notice {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="endOfLife")
    @JsonPropertyDescription(value="Value is UTC timestamp in ISO 8601 YYYY-MM-DDThh:mm:ss.sZ or empty")
    private Date endOfLife;
    @JsonProperty(value="expectingOrders")
    private List<OrderV> expectingOrders = null;
    @JsonProperty(value="expectingOrderIds")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="is empty if expectingOrders is filled")
    private Set<String> expectingOrderIds = null;
    @JsonProperty(value="workflowTagsPerWorkflow")
    @JsonPropertyDescription(value="a map of workflowName -> tags-array")
    private WorkflowTags workflowTagsPerWorkflow;
    @JsonProperty(value="state")
    private NoticeState state;

    public Notice() {
    }

    public Notice(String id, String key, Date endOfLife, List<OrderV> expectingOrders, Set<String> expectingOrderIds, WorkflowTags workflowTagsPerWorkflow, NoticeState state) {
        this.id = id;
        this.key = key;
        this.endOfLife = endOfLife;
        this.expectingOrders = expectingOrders;
        this.expectingOrderIds = expectingOrderIds;
        this.workflowTagsPerWorkflow = workflowTagsPerWorkflow;
        this.state = state;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="endOfLife")
    public Date getEndOfLife() {
        return this.endOfLife;
    }

    @JsonProperty(value="endOfLife")
    public void setEndOfLife(Date endOfLife) {
        this.endOfLife = endOfLife;
    }

    @JsonProperty(value="expectingOrders")
    public List<OrderV> getExpectingOrders() {
        return this.expectingOrders;
    }

    @JsonProperty(value="expectingOrders")
    public void setExpectingOrders(List<OrderV> expectingOrders) {
        this.expectingOrders = expectingOrders;
    }

    @JsonProperty(value="expectingOrderIds")
    public Set<String> getExpectingOrderIds() {
        return this.expectingOrderIds;
    }

    @JsonProperty(value="expectingOrderIds")
    public void setExpectingOrderIds(Set<String> expectingOrderIds) {
        this.expectingOrderIds = expectingOrderIds;
    }

    @JsonProperty(value="workflowTagsPerWorkflow")
    public WorkflowTags getWorkflowTagsPerWorkflow() {
        return this.workflowTagsPerWorkflow;
    }

    @JsonProperty(value="workflowTagsPerWorkflow")
    public void setWorkflowTagsPerWorkflow(WorkflowTags workflowTagsPerWorkflow) {
        this.workflowTagsPerWorkflow = workflowTagsPerWorkflow;
    }

    @JsonProperty(value="state")
    public NoticeState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(NoticeState state) {
        this.state = state;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("key", (Object)this.key).append("endOfLife", (Object)this.endOfLife).append("expectingOrders", this.expectingOrders).append("expectingOrderIds", this.expectingOrderIds).append("workflowTagsPerWorkflow", (Object)this.workflowTagsPerWorkflow).append("state", (Object)this.state).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Notice)) {
            return false;
        }
        Notice rhs = (Notice)other;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).isEquals();
    }
}

