/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderModeType {
    FRESH_ONLY("FreshOnly"),
    FRESH_OR_STARTED("FreshOrStarted");

    private final String value;
    private static final Map<String, OrderModeType> CONSTANTS;

    private OrderModeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OrderModeType fromValue(String value) {
        OrderModeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OrderModeType>();
        for (OrderModeType c : OrderModeType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

