/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.board;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum BoardType {
    GLOBAL("GLOBAL"),
    PLANNABLE("PLANNABLE");

    private final String value;
    private static final Map<String, BoardType> CONSTANTS;

    private BoardType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static BoardType fromValue(String value) {
        BoardType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, BoardType>();
        for (BoardType c : BoardType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

