/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.job;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ExecutableType {
    ShellScriptExecutable("ShellScriptExecutable"),
    ScriptExecutable("ScriptExecutable"),
    InternalExecutable("InternalExecutable");

    private final String value;
    private static final Map<String, ExecutableType> CONSTANTS;

    private ExecutableType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ExecutableType fromValue(String value) {
        ExecutableType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ExecutableType>();
        for (ExecutableType c : ExecutableType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

