/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.job;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JobCriticality {
    NORMAL(0),
    CRITICAL(1),
    MINOR(2),
    MAJOR(3);

    private final Integer intValue;
    private static final Map<String, JobCriticality> CONSTANTS;
    private static final Map<Integer, JobCriticality> INTCONSTANTS;

    private JobCriticality(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static JobCriticality fromValue(String value) {
        JobCriticality constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static JobCriticality fromValue(Integer intValue) {
        JobCriticality constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JobCriticality>();
        INTCONSTANTS = new HashMap<Integer, JobCriticality>();
        for (JobCriticality c : JobCriticality.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (JobCriticality c : JobCriticality.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

