/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Frequency {
    WEEKLY("weekly", 1),
    TWO_WEEKS("every2weeks", 2),
    MONTHLY("monthly", 4),
    THREE_MONTHS("every3months", 13),
    SIX_MONTHS("every6months", 26),
    YEARLY("yearly", 52),
    THREE_YEARS("every3years", 156);

    private final String strValue;
    private final Integer intValue;
    private static final Map<String, Frequency> CONSTANTS;
    private static final Map<String, Frequency> STRCONSTANTS;
    private static final Map<Integer, Frequency> INTCONSTANTS;

    private Frequency(String strValue, Integer intValue) {
        this.strValue = strValue;
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public String strValue() {
        return this.strValue;
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static Frequency fromValue(String value) {
        Frequency constant = CONSTANTS.get(value);
        if (constant == null) {
            return Frequency.fromStrValue(value);
        }
        return constant;
    }

    public static Frequency fromValue(Integer value) {
        Frequency constant = INTCONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("" + value);
        }
        return constant;
    }

    private static Frequency fromStrValue(String value) {
        Frequency constant = STRCONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Frequency>();
        STRCONSTANTS = new HashMap<String, Frequency>();
        INTCONSTANTS = new HashMap<Integer, Frequency>();
        for (Frequency c : Frequency.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (Frequency c : Frequency.values()) {
            STRCONSTANTS.put(c.strValue, c);
        }
        for (Frequency c : Frequency.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

