/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ObjectType {
    FOLDER(0),
    WORKFLOW(1),
    JOBCLASS(2),
    LOCK(4),
    WORKINGDAYSCALENDAR(60),
    NONWORKINGDAYSCALENDAR(61),
    SCHEDULE(7),
    JOBTEMPLATE(8),
    FILEORDERSOURCE(9),
    JOBRESOURCE(10),
    NOTICEBOARD(11),
    INCLUDESCRIPT(12),
    REPORT(15),
    DOCUMENTATION(20),
    ORDER(99);

    private final Integer intValue;
    private static final Map<String, ObjectType> CONSTANTS;
    private static final Map<Integer, ObjectType> INTCONSTANTS;

    private ObjectType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ObjectType fromValue(String value) {
        ObjectType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ObjectType fromValue(Integer intValue) {
        ObjectType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ObjectType>();
        INTCONSTANTS = new HashMap<Integer, ObjectType>();
        for (ObjectType c : ObjectType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ObjectType c : ObjectType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

