/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JocSecurityLevel {
    LOW(0),
    MEDIUM(1),
    HIGH(2);

    private final Integer intValue;
    private static final Map<String, JocSecurityLevel> CONSTANTS;
    private static final Map<Integer, JocSecurityLevel> INTCONSTANTS;

    private JocSecurityLevel(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static JocSecurityLevel fromValue(String value) {
        JocSecurityLevel constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static JocSecurityLevel fromValue(Integer intValue) {
        JocSecurityLevel constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JocSecurityLevel>();
        INTCONSTANTS = new HashMap<Integer, JocSecurityLevel>();
        for (JocSecurityLevel c : JocSecurityLevel.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (JocSecurityLevel c : JocSecurityLevel.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

