/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum VariableType {
    STRING(0),
    BOOLEAN(1),
    INTEGER(2),
    BIGDECIMAL(3),
    DOUBLE(4);

    private final Integer value;
    private static final Map<Integer, VariableType> CONSTANTS;

    private VariableType(Integer value) {
        this.value = value;
    }

    @JsonValue
    public Integer value() {
        return this.value;
    }

    @JsonCreator
    public static VariableType fromValue(Integer value) {
        VariableType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("" + value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, VariableType>();
        for (VariableType c : VariableType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

