/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EventType {
    JOCCLUSTER("JOCCLUSTER"),
    CONTROLLER("CONTROLLER"),
    CONTROLLERCLUSTER("CONTROLLERCLUSTER"),
    AGENT("AGENT"),
    PROBLEM("PROBLEM"),
    FOLDER("FOLDER"),
    TAG("TAG"),
    WORKFLOW("WORKFLOW"),
    ORDER("ORDER"),
    LOCK("LOCK"),
    JOB("JOB"),
    FILEORDERSOURCE("FILEORDERSOURCE"),
    NOTICEBOARD("NOTICEBOARD"),
    JOBCLASS("JOBCLASS"),
    JOBTEMPLATE("JOBTEMPLATE"),
    JOBRESOURCE("JOBRESOURCE"),
    SCHEDULE("SCHEDULE"),
    INCLUDESCRIPT("INCLUDESCRIPT"),
    REPORT("REPORT"),
    CALENDAR("CALENDAR"),
    WORKINGDAYSCALENDAR("WORKINGDAYSCALENDAR"),
    NONWORKINGDAYSCALENDAR("NONWORKINGDAYSCALENDAR"),
    DAILYPLAN("DAILYPLAN"),
    ORDERHISTORY("ORDERHISTORY"),
    TASKHISTORY("TASKHISTORY"),
    FILETRANSFER("FILETRANSFER"),
    MONITORINGNOTIFICATION("MONITORINGNOTIFICATION"),
    MONITORINGCONTROLLER("MONITORINGCONTROLLER"),
    MONITORINGAGENT("MONITORINGAGENT"),
    AUDITLOG("AUDITLOG"),
    PLAN("PLAN"),
    APPROVAL("APPROVAL");

    private final String value;
    private static final Map<String, EventType> CONSTANTS;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static EventType fromValue(String value) {
        EventType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, EventType>();
        for (EventType c : EventType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

