/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.favorite;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FavoriteType {
    FACET(1),
    AGENT(2),
    TAG(3);

    private final Integer intValue;
    private static final Map<String, FavoriteType> CONSTANTS;
    private static final Map<Integer, FavoriteType> INTCONSTANTS;

    private FavoriteType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static FavoriteType fromValue(String value) {
        FavoriteType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static FavoriteType fromValue(Integer intValue) {
        FavoriteType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FavoriteType>();
        INTCONSTANTS = new HashMap<Integer, FavoriteType>();
        for (FavoriteType c : FavoriteType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (FavoriteType c : FavoriteType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

