/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ArgumentType {
    STRING(0),
    INTEGER(1),
    NUMBER(2),
    BOOLEAN(3);

    private final Integer intValue;
    private static final Map<String, ArgumentType> CONSTANTS;
    private static final Map<Integer, ArgumentType> INTCONSTANTS;

    private ArgumentType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ArgumentType fromValue(String value) {
        ArgumentType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ArgumentType fromValue(Integer intValue) {
        ArgumentType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ArgumentType>();
        INTCONSTANTS = new HashMap<Integer, ArgumentType>();
        for (ArgumentType c : ArgumentType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ArgumentType c : ArgumentType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

