/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ConfigurationType {
    FOLDER(0),
    WORKFLOW(1),
    JOBCLASS(2),
    LOCK(4),
    WORKINGDAYSCALENDAR(60),
    NONWORKINGDAYSCALENDAR(61),
    SCHEDULE(7),
    JOBTEMPLATE(8),
    FILEORDERSOURCE(9),
    JOBRESOURCE(10),
    NOTICEBOARD(11),
    INCLUDESCRIPT(12),
    DEPLOYMENTDESCRIPTOR(13),
    DESCRIPTORFOLDER(14),
    REPORT(15);

    private final Integer intValue;
    private static final Map<String, ConfigurationType> CONSTANTS;
    private static final Map<Integer, ConfigurationType> INTCONSTANTS;

    private ConfigurationType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ConfigurationType fromValue(String value) {
        ConfigurationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ConfigurationType fromValue(Integer intValue) {
        ConfigurationType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ConfigurationType>();
        INTCONSTANTS = new HashMap<Integer, ConfigurationType>();
        for (ConfigurationType c : ConfigurationType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ConfigurationType c : ConfigurationType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

