/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum LockType {
    EXCLUSIVE(0),
    SHARED(1),
    QUANTITATIVE_RESOURCES(2);

    private final Integer intValue;
    private static final Map<String, LockType> CONSTANTS;
    private static final Map<Integer, LockType> INTCONSTANTS;

    private LockType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static LockType fromValue(String value) {
        LockType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static LockType fromValue(Integer intValue) {
        LockType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, LockType>();
        INTCONSTANTS = new HashMap<Integer, LockType>();
        for (LockType c : LockType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (LockType c : LockType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

