/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Product {
    CONTROLLER(0),
    AGENT(1);

    private final Integer intValue;
    private static final Map<String, Product> CONSTANTS;
    private static final Map<Integer, Product> INTCONSTANTS;

    private Product(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static Product fromValue(String value) {
        Product constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static Product fromValue(Integer intValue) {
        Product constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Product>();
        INTCONSTANTS = new HashMap<Integer, Product>();
        for (Product c : Product.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (Product c : Product.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

