/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.monitoring.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum EntryItemSource {
    history("history"),
    historyNotInInventory("historyNotInInventory"),
    inventory("inventory"),
    webservice("webservice");

    private final String value;
    private static final Map<String, EntryItemSource> CONSTANTS;

    private EntryItemSource(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static EntryItemSource fromValue(String value) {
        EntryItemSource constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, EntryItemSource>();
        for (EntryItemSource c : EntryItemSource.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

