/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.monitoring.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TotalRunningTimeSource {
    estimated("estimated"),
    dateFrom("dateFrom"),
    dateTo("dateTo"),
    nextReadyTime("nextReadyTime"),
    now("now"),
    shutdown("shutdown");

    private final String value;
    private static final Map<String, TotalRunningTimeSource> CONSTANTS;

    private TotalRunningTimeSource(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TotalRunningTimeSource fromValue(String value) {
        TotalRunningTimeSource constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TotalRunningTimeSource>();
        for (TotalRunningTimeSource c : TotalRunningTimeSource.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

