/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderStateText {
    PLANNED(0),
    PENDING(1),
    RUNNING(2),
    SUSPENDED(3),
    FAILED(4),
    WAITING(5),
    BLOCKED(6),
    CANCELLED(7),
    FINISHED(8),
    BROKEN(12),
    INPROGRESS(13),
    SCHEDULED(15),
    PROMPTING(16),
    UNKNOWN(99);

    private final Integer intValue;
    private static final Map<String, OrderStateText> CONSTANTS;
    private static final Map<Integer, OrderStateText> INTCONSTANTS;

    private OrderStateText(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static OrderStateText fromValue(String value) {
        OrderStateText constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static OrderStateText fromValue(Integer intValue) {
        OrderStateText constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OrderStateText>();
        INTCONSTANTS = new HashMap<Integer, OrderStateText>();
        for (OrderStateText c : OrderStateText.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (OrderStateText c : OrderStateText.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

