/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.security.foureyes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sos.joc.model.audit.CategoryType;
import com.sos.joc.model.security.foureyes.ApprovalBase;
import com.sos.joc.model.security.foureyes.ApproverState;
import com.sos.joc.model.security.foureyes.RequestBody;
import com.sos.joc.model.security.foureyes.RequestorState;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "title", "approver", "unknownApprover", "reason", "approverState", "approverStateDate", "requestorState", "requestorStateDate"})
public class ApprovalRequest
extends ApprovalBase {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="approver")
    private String approver;
    @JsonProperty(value="unknownApprover")
    @JsonPropertyDescription(value="An approver was selected for the approval request but is not longer configured as approver")
    private Boolean unknownApprover = false;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="approverState")
    private ApproverState approverState;
    @JsonProperty(value="approverStateDate")
    @JsonPropertyDescription(value="Value is UTC timestamp in ISO 8601 YYYY-MM-DDThh:mm:ss.sZ or empty")
    private Date approverStateDate;
    @JsonProperty(value="requestorState")
    private RequestorState requestorState;
    @JsonProperty(value="requestorStateDate")
    @JsonPropertyDescription(value="Value is UTC timestamp in ISO 8601 YYYY-MM-DDThh:mm:ss.sZ or empty")
    private Date requestorStateDate;

    public ApprovalRequest() {
    }

    public ApprovalRequest(Long id, String title, String approver, Boolean unknownApprover, String reason, ApproverState approverState, Date approverStateDate, RequestorState requestorState, Date requestorStateDate, String requestor, String requestUrl, RequestBody requestBody, CategoryType category) {
        super(requestor, requestUrl, requestBody, category);
        this.id = id;
        this.title = title;
        this.approver = approver;
        this.unknownApprover = unknownApprover;
        this.reason = reason;
        this.approverState = approverState;
        this.approverStateDate = approverStateDate;
        this.requestorState = requestorState;
        this.requestorStateDate = requestorStateDate;
    }

    @JsonProperty(value="id")
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="approver")
    public String getApprover() {
        return this.approver;
    }

    @JsonProperty(value="approver")
    public void setApprover(String approver) {
        this.approver = approver;
    }

    @JsonProperty(value="unknownApprover")
    public Boolean getUnknownApprover() {
        return this.unknownApprover;
    }

    @JsonProperty(value="unknownApprover")
    public void setUnknownApprover(Boolean unknownApprover) {
        this.unknownApprover = unknownApprover;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="approverState")
    public ApproverState getApproverState() {
        return this.approverState;
    }

    @JsonProperty(value="approverState")
    public void setApproverState(ApproverState approverState) {
        this.approverState = approverState;
    }

    @JsonProperty(value="approverStateDate")
    public Date getApproverStateDate() {
        return this.approverStateDate;
    }

    @JsonProperty(value="approverStateDate")
    public void setApproverStateDate(Date approverStateDate) {
        this.approverStateDate = approverStateDate;
    }

    @JsonProperty(value="requestorState")
    public RequestorState getRequestorState() {
        return this.requestorState;
    }

    @JsonProperty(value="requestorState")
    public void setRequestorState(RequestorState requestorState) {
        this.requestorState = requestorState;
    }

    @JsonProperty(value="requestorStateDate")
    public Date getRequestorStateDate() {
        return this.requestorStateDate;
    }

    @JsonProperty(value="requestorStateDate")
    public void setRequestorStateDate(Date requestorStateDate) {
        this.requestorStateDate = requestorStateDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("id", (Object)this.id).append("title", (Object)this.title).append("approver", (Object)this.approver).append("unknownApprover", (Object)this.unknownApprover).append("reason", (Object)this.reason).append("approverState", (Object)this.approverState).append("approverStateDate", (Object)this.approverStateDate).append("requestorState", (Object)this.requestorState).append("requestorStateDate", (Object)this.requestorStateDate).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.approver).append((Object)this.approverState).append((Object)this.reason).append((Object)this.requestorState).append((Object)this.requestorStateDate).append((Object)this.id).append((Object)this.title).append((Object)this.approverStateDate).append((Object)this.unknownApprover).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApprovalRequest)) {
            return false;
        }
        ApprovalRequest rhs = (ApprovalRequest)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.approver, (Object)rhs.approver).append((Object)this.approverState, (Object)rhs.approverState).append((Object)this.reason, (Object)rhs.reason).append((Object)this.requestorState, (Object)rhs.requestorState).append((Object)this.requestorStateDate, (Object)rhs.requestorStateDate).append((Object)this.id, (Object)rhs.id).append((Object)this.title, (Object)rhs.title).append((Object)this.approverStateDate, (Object)rhs.approverStateDate).append((Object)this.unknownApprover, (Object)rhs.unknownApprover).isEquals();
    }
}

