/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.security.foureyes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ApproverState {
    PENDING(0),
    APPROVED(1),
    REJECTED(2);

    private final Integer intValue;
    private static final Map<String, ApproverState> CONSTANTS;
    private static final Map<Integer, ApproverState> INTCONSTANTS;

    private ApproverState(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ApproverState fromValue(String value) {
        ApproverState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ApproverState fromValue(Integer intValue) {
        ApproverState constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ApproverState>();
        INTCONSTANTS = new HashMap<Integer, ApproverState>();
        for (ApproverState c : ApproverState.values()) {
            CONSTANTS.put(c.name(), c);
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

