/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.security.foureyes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RequestorState {
    REQUESTED(0),
    WITHDRAWN(1),
    EXECUTED(2);

    private final Integer intValue;
    private static final Map<String, RequestorState> CONSTANTS;
    private static final Map<Integer, RequestorState> INTCONSTANTS;

    private RequestorState(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static RequestorState fromValue(String value) {
        RequestorState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static RequestorState fromValue(Integer intValue) {
        RequestorState constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RequestorState>();
        INTCONSTANTS = new HashMap<Integer, RequestorState>();
        for (RequestorState c : RequestorState.values()) {
            CONSTANTS.put(c.name(), c);
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

