/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.security.properties.fido;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FidoProtocolType {
    FIDO_2("FIDO2"),
    PASSKEY("PASSKEY");

    private final String value;
    private static final Map<String, FidoProtocolType> CONSTANTS;

    private FidoProtocolType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static FidoProtocolType fromValue(String value) {
        FidoProtocolType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, FidoProtocolType>();
        for (FidoProtocolType c : FidoProtocolType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

