/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.yade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Protocol {
    UNKNOWN("UNKNOWN"),
    AZURE_BLOB_STORAGE("AZURE_BLOB_STORAGE"),
    FTP("FTP"),
    FTPS("FTPS"),
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    LOCAL("LOCAL"),
    SFTP("SFTP"),
    SMB("SMB"),
    WEBDAV("WEBDAV"),
    WEBDAVS("WEBDAVS");

    private final String value;
    private static final Map<String, Protocol> CONSTANTS;

    private Protocol(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Protocol fromValue(String value) {
        Protocol constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Protocol>();
        for (Protocol c : Protocol.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

