/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MonitorType {
    COMMAND(0),
    MAIL(1),
    NSCA(2),
    JMS(3);

    private final Integer intValue;
    private static final Map<String, MonitorType> CONSTANTS;
    private static final Map<Integer, MonitorType> INTCONSTANTS;

    private MonitorType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static MonitorType fromValue(String value) {
        MonitorType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static MonitorType fromValue(Integer intValue) {
        MonitorType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MonitorType>();
        INTCONSTANTS = new HashMap<Integer, MonitorType>();
        for (MonitorType c : MonitorType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (MonitorType c : MonitorType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

