/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum NotificationType {
    SUCCESS(0),
    ERROR(1),
    WARNING(2),
    RECOVERED(3),
    ACKNOWLEDGED(4);

    private final Integer intValue;
    private static final Map<String, NotificationType> CONSTANTS;
    private static final Map<Integer, NotificationType> INTCONSTANTS;

    private NotificationType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static NotificationType fromValue(String value) {
        NotificationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static NotificationType fromValue(Integer intValue) {
        NotificationType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, NotificationType>();
        INTCONSTANTS = new HashMap<Integer, NotificationType>();
        for (NotificationType c : NotificationType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (NotificationType c : NotificationType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

