/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreType;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KeyStoreContainer {
    private KeyStoreType type;
    private Path path;
    private KeyStore keyStore;
    private String password;
    private String keyPassword;
    private List<String> aliases;

    public KeyStoreContainer(KeyStoreType type, Path path) {
        this(type);
        this.path = path;
    }

    public KeyStoreContainer(KeyStoreType type, KeyStore keyStore) {
        this(type);
        this.keyStore = keyStore;
    }

    private KeyStoreContainer(KeyStoreType type) {
        this.type = type;
    }

    public KeyStoreType getType() {
        return this.type;
    }

    public void setType(KeyStoreType val) {
        this.type = val;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore val) {
        this.keyStore = val;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path val) {
        this.path = val;
    }

    public String getPassword() {
        return this.password;
    }

    public char[] getPasswordChars() {
        return this.password == null ? null : this.password.toCharArray();
    }

    public void setPassword(String val) {
        this.password = val;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public char[] getKeyPasswordChars() {
        return this.keyPassword == null ? this.getPasswordChars() : this.keyPassword.toCharArray();
    }

    public void setKeyPassword(String val) {
        this.keyPassword = val;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> val) {
        this.aliases = val;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        if (this.path != null) {
            sb.append(" ").append(this.path);
        }
        if (this.password != null) {
            sb.append("  password=" + SOSArgument.DisplayMode.MASKED.getValue());
        }
        if (!SOSCollection.isEmpty(this.aliases)) {
            sb.append("  aliases=" + this.aliases);
        }
        if (this.keyPassword != null) {
            sb.append("  keyPassword=" + SOSArgument.DisplayMode.MASKED.getValue());
        }
        return sb.toString();
    }

    public static String toString(String prefix, KeyStoreContainer c) {
        return prefix + " " + c.toString();
    }

    public static String toString(String prefix, List<KeyStoreContainer> lc) {
        ArrayList<String> m = new ArrayList<String>();
        for (KeyStoreContainer c : lc) {
            m.add(KeyStoreContainer.toString(prefix, c));
        }
        return String.join((CharSequence)", ", m);
    }

    private boolean areEqual(KeyStoreContainer c1, KeyStoreContainer c2) throws Exception {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.getPath() != null) {
            if (c2.getPath() == null) {
                return false;
            }
            return c1.getPath().equals(c2.getPath());
        }
        if (c2.getPath() != null) {
            if (c1.getPath() == null) {
                return false;
            }
            return c1.getPath().equals(c2.getPath());
        }
        KeyStore ks1 = c1.getKeyStore();
        KeyStore ks2 = c2.getKeyStore();
        if (ks1 == null && ks2 == null) {
            return true;
        }
        if (ks1 == null || ks2 == null) {
            return false;
        }
        ArrayList<String> aliases1 = Collections.list(ks1.aliases());
        ArrayList<String> aliases2 = Collections.list(ks2.aliases());
        Collections.sort(aliases1);
        Collections.sort(aliases2);
        if (!aliases1.equals(aliases2)) {
            return false;
        }
        for (String alias : aliases1) {
            Certificate cert1 = ks1.getCertificate(alias);
            Certificate cert2 = ks2.getCertificate(alias);
            if (cert1 == null && cert2 != null) {
                return false;
            }
            if (cert1 == null || cert1.equals(cert2)) continue;
            return false;
        }
        return true;
    }
}

