/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.keystore;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.keystore.KeyStoreArguments;
import com.sos.commons.util.keystore.KeyStoreContainer;
import com.sos.commons.util.keystore.KeyStoreType;
import com.sos.commons.util.loggers.base.ISOSLogger;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KeyStoreReader {
    private static final String SYSTEM_PROPERTY_KEYSTORE_PATH = "javax.net.ssl.keyStore";
    private static final String SYSTEM_PROPERTY_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PATH = "javax.net.ssl.trustStore";
    private static final String SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private final Type type;
    private Path path;
    private String password;
    private KeyStoreType storeType;

    private KeyStoreReader() {
        this(null, null, null, null);
    }

    private KeyStoreReader(Type type, Path path, String password, KeyStoreType storeType) {
        this.type = type;
        this.path = path;
        this.password = password;
        this.storeType = KeyStoreReader.getType(storeType);
    }

    public KeyStore read() throws Exception {
        if (this.path == null) {
            return null;
        }
        this.resolvePathAndPassword();
        return KeyStoreReader.load(this.path, this.password, this.storeType);
    }

    public static KeyStoreResult read(ISOSLogger logger, KeyStoreArguments args) throws Exception {
        if (args == null || !args.isCustomStoresEnabled()) {
            return null;
        }
        KeyStoreResult result = new KeyStoreReader().new KeyStoreResult();
        if (!args.getKeyStoreContainer().isEmpty()) {
            KeyStoreContainer c = args.getKeyStoreContainer().getValue();
            if (c.getKeyStore() == null) {
                result.setKeyStoreContainer(KeyStoreReader.read(Type.KEYSTORE, c.getPath(), c.getPassword(), c.getType()));
            } else {
                result.setKeyStoreContainer(c);
            }
        }
        if (!SOSCollection.isEmpty((Collection)args.getTrustStoreContainers().getValue())) {
            for (KeyStoreContainer c : args.getTrustStoreContainers().getValue()) {
                if (c.getKeyStore() == null) {
                    result.addTrustStoreContainer(KeyStoreReader.read(Type.TRUSTSTORE, c.getPath(), c.getPassword(), c.getType()));
                    continue;
                }
                result.addTrustStoreContainer(c);
            }
        }
        return result;
    }

    public static KeyStore load(Path path, String password, KeyStoreType storeType) throws Exception {
        KeyStore keyStore;
        block9: {
            if (path == null) {
                return null;
            }
            KeyStoreType type = KeyStoreReader.getType(storeType);
            char[] pass = password == null ? null : password.toCharArray();
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                KeyStore ks = KeyStore.getInstance(type.name());
                ks.load(is, pass);
                keyStore = ks;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new Exception(String.format("[%s.load][%s][%s]%s", new Object[]{KeyStoreReader.class.getSimpleName(), storeType, path, e}), e);
                }
            }
            is.close();
        }
        return keyStore;
    }

    public Path getPath() {
        return this.path;
    }

    public KeyStoreType getStoreType() {
        return this.storeType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type").append((Object)this.type);
        if (this.storeType != null) {
            sb.append(",storeType=").append((Object)this.storeType);
        }
        if (this.path != null) {
            sb.append(",path=").append(this.path);
        }
        return sb.toString();
    }

    private static KeyStoreContainer read(Type type, Path path, String password, KeyStoreType storeType) throws Exception {
        KeyStoreReader reader = new KeyStoreReader(type, path, password, storeType);
        reader.resolvePathAndPassword();
        KeyStoreContainer c = new KeyStoreContainer(reader.storeType, reader.path);
        c.setKeyStore(KeyStoreReader.load(reader.path, reader.password, reader.storeType));
        c.setPassword(reader.password);
        return c;
    }

    private void resolvePathAndPassword() {
        switch (this.type) {
            case KEYSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_KEYSTORE_PATH, SYSTEM_PROPERTY_KEYSTORE_PASSWORD);
                break;
            }
            case TRUSTSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_TRUSTSTORE_PATH, SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD);
                break;
            }
            case KEY_AND_TRUSTSTORE: {
                this.setPathAndPassword(SYSTEM_PROPERTY_KEYSTORE_PATH, SYSTEM_PROPERTY_KEYSTORE_PASSWORD);
                this.setPathAndPassword(SYSTEM_PROPERTY_TRUSTSTORE_PATH, SYSTEM_PROPERTY_TRUSTSTORE_PASSWORD);
                break;
            }
        }
    }

    private static KeyStoreType getType(KeyStoreType storeType) {
        if (storeType != null) {
            return storeType;
        }
        try {
            return KeyStoreType.fromString(KeyStore.getDefaultType());
        }
        catch (Exception e) {
            return KeyStoreType.JKS;
        }
    }

    private void setPathAndPassword(String pathProperty, String passwordProperty) {
        String val;
        if (this.path == null && (val = System.getProperty(pathProperty)) != null) {
            this.path = Paths.get(val, new String[0]);
        }
        if (this.password == null && (val = System.getProperty(passwordProperty)) != null) {
            this.password = val;
        }
    }

    public static enum Type {
        KEYSTORE,
        TRUSTSTORE,
        KEY_AND_TRUSTSTORE;

    }

    public class KeyStoreResult {
        private KeyStoreContainer keyStoreContainer;
        private List<KeyStoreContainer> trustStoreContainers;

        public KeyStoreContainer getKeyStoreContainer() {
            return this.keyStoreContainer;
        }

        public List<KeyStoreContainer> getTrustStoreContainers() {
            return this.trustStoreContainers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.keyStoreContainer != null && !SOSCollection.isEmpty(this.trustStoreContainers)) {
                KeyStoreContainer trustStoreSingleContainer;
                KeyStoreContainer keyStoreContainer = trustStoreSingleContainer = this.trustStoreContainers.size() == 1 ? this.trustStoreContainers.get(0) : null;
                if (trustStoreSingleContainer != null && trustStoreSingleContainer.getPath() != null && this.keyStoreContainer.getPath() != null && trustStoreSingleContainer.getPath().equals(this.keyStoreContainer.getPath())) {
                    sb.append("keystore/truststore ").append(this.keyStoreContainer);
                } else {
                    sb.append(KeyStoreContainer.toString("keystore", this.keyStoreContainer));
                    sb.append(", ");
                    sb.append(KeyStoreContainer.toString("truststore", this.trustStoreContainers));
                }
            } else if (this.keyStoreContainer != null) {
                sb.append(KeyStoreContainer.toString("keystore", this.keyStoreContainer));
            } else if (!SOSCollection.isEmpty(this.trustStoreContainers)) {
                sb.append(KeyStoreContainer.toString("truststore", this.trustStoreContainers));
            }
            return sb.toString();
        }

        private void setKeyStoreContainer(KeyStoreContainer c) {
            this.keyStoreContainer = c;
        }

        private void addTrustStoreContainer(KeyStoreContainer c) {
            if (this.trustStoreContainers == null) {
                this.trustStoreContainers = new ArrayList<KeyStoreContainer>();
            }
            this.trustStoreContainers.add(c);
        }
    }
}

