/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.ssl;

import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreArguments;
import com.sos.commons.util.keystore.KeyStoreContainer;
import java.util.ArrayList;
import java.util.Collection;

public class SslArguments
extends ASOSArguments {
    private static String ARG_NAME_TRUSTSTORE_DISPLAY_NAME = "TrustStore";
    private static String ARG_NAME_KEYSTORE_DISPLAY_NAME = "KeyStore";
    private KeyStoreArguments trustedSsl;
    private SOSArgument<Boolean> untrustedSsl = new SOSArgument<Boolean>("untrusted_ssl", false, false);
    private SOSArgument<Boolean> untrustedSslVerifyCertificateHostname = new SOSArgument<Boolean>("verify_certificate_hostname", false, true);
    private String untrustedSslNameAlias;
    private String untrustedSslVerifyCertificateHostnameOppositeName;
    private SOSArgument<String> enabledProtocols = new SOSArgument("enabled_protocols", false);

    public KeyStoreArguments getTrustedSsl() {
        if (this.trustedSsl == null) {
            this.trustedSsl = new KeyStoreArguments();
            this.trustedSsl.applyDefaultIfNullQuietly();
        }
        return this.trustedSsl;
    }

    public String getTrustedSslInfo() {
        if (this.trustedSsl == null) {
            return "";
        }
        if (!this.trustedSsl.isCustomStoresEnabled()) {
            return "Default " + ARG_NAME_TRUSTSTORE_DISPLAY_NAME;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        if (!this.trustedSsl.getKeyStoreFile().isEmpty()) {
            l.add(ARG_NAME_KEYSTORE_DISPLAY_NAME + " " + (Object)((Object)this.trustedSsl.getKeyStoreType().getValue()) + " " + this.trustedSsl.getKeyStoreFile().getValue());
        }
        if (!SOSCollection.isEmpty((Collection)this.trustedSsl.getTrustStoreContainers().getValue())) {
            l.add(KeyStoreContainer.toString(ARG_NAME_TRUSTSTORE_DISPLAY_NAME, this.trustedSsl.getTrustStoreContainers().getValue()));
        }
        return String.join((CharSequence)", ", l);
    }

    public void setTrustedSsl(KeyStoreArguments val) {
        this.trustedSsl = val;
    }

    public SOSArgument<Boolean> getUntrustedSsl() {
        return this.untrustedSsl;
    }

    public SOSArgument<Boolean> getUntrustedSslVerifyCertificateHostname() {
        return this.untrustedSslVerifyCertificateHostname;
    }

    public SOSArgument<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setUntrustedSslNameAlias(String val) {
        this.untrustedSslNameAlias = val;
    }

    public String getUntrustedSslVerifyCertificateHostnameOppositeName() {
        return this.untrustedSslVerifyCertificateHostnameOppositeName;
    }

    public void setUntrustedSslVerifyCertificateHostnameOppositeName(String val) {
        this.untrustedSslVerifyCertificateHostnameOppositeName = val;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(SslArguments.class.getSimpleName()).append("]");
        if (this.untrustedSslNameAlias == null) {
            sb.append(this.untrustedSsl.getName());
        } else {
            sb.append(this.untrustedSslNameAlias);
        }
        sb.append("=").append(this.untrustedSsl.getValue());
        sb.append(", ");
        if (this.untrustedSslVerifyCertificateHostnameOppositeName == null) {
            sb.append(this.untrustedSslVerifyCertificateHostname.getName());
            sb.append("=").append(this.untrustedSslVerifyCertificateHostname.getValue());
        } else {
            sb.append(this.untrustedSslVerifyCertificateHostnameOppositeName);
            sb.append("=").append(this.untrustedSslVerifyCertificateHostname.getValue() == false);
        }
        if (this.enabledProtocols.getValue() != null) {
            sb.append(", ");
            sb.append(this.enabledProtocols.getName());
            sb.append("=").append(String.join((CharSequence)", ", this.enabledProtocols.getValue()));
        }
        sb.append(", ");
        sb.append("[").append(KeyStoreArguments.class.getSimpleName()).append("]");
        sb.append(this.trustedSsl);
        return sb.toString();
    }
}

