/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.model.source.internal.hbm.HbmLocalMetadataBuildingContext;
import org.hibernate.boot.query.BootQueryLogging;
import org.hibernate.boot.query.HbmResultSetMappingDescriptor;
import org.hibernate.boot.query.ResultDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;

public class ImplicitHbmResultSetMappingDescriptorBuilder {
    private final String registrationName;
    private final MetadataBuildingContext metadataBuildingContext;
    private final List<ResultDescriptor> resultDescriptors;
    private Map<String, Map<String, HbmResultSetMappingDescriptor.JoinDescriptor>> joinDescriptors;
    private Map<String, HbmResultSetMappingDescriptor.HbmFetchParent> fetchParentByAlias;
    private boolean foundEntityReturn;
    private boolean foundCollectionReturn;

    public ImplicitHbmResultSetMappingDescriptorBuilder(String queryRegistrationName, MetadataBuildingContext metadataBuildingContext) {
        this.registrationName = queryRegistrationName;
        BootQueryLogging.BOOT_QUERY_LOGGER.debugf("Creating implicit HbmResultSetMappingDescriptor for named-native-query : %s", (Object)this.registrationName);
        this.metadataBuildingContext = metadataBuildingContext;
        this.resultDescriptors = new ArrayList<ResultDescriptor>();
    }

    public ImplicitHbmResultSetMappingDescriptorBuilder(String queryRegistrationName, int numberOfReturns, MetadataBuildingContext metadataBuildingContext) {
        this.registrationName = queryRegistrationName;
        this.metadataBuildingContext = metadataBuildingContext;
        this.resultDescriptors = new ArrayList<ResultDescriptor>(numberOfReturns);
    }

    public String getRegistrationName() {
        return this.registrationName;
    }

    public boolean hasAnyReturns() {
        return !this.resultDescriptors.isEmpty();
    }

    public ImplicitHbmResultSetMappingDescriptorBuilder addReturn(JaxbHbmNativeQueryScalarReturnType returnMapping) {
        this.resultDescriptors.add(new HbmResultSetMappingDescriptor.ScalarDescriptor(returnMapping.getColumn(), returnMapping.getType()));
        return this;
    }

    public ImplicitHbmResultSetMappingDescriptorBuilder addReturn(JaxbHbmNativeQueryReturnType returnMapping) {
        this.foundEntityReturn = true;
        HbmResultSetMappingDescriptor.EntityResultDescriptor resultDescriptor = new HbmResultSetMappingDescriptor.EntityResultDescriptor(returnMapping, () -> this.joinDescriptors, this.registrationName, this.metadataBuildingContext);
        this.resultDescriptors.add(resultDescriptor);
        if (this.fetchParentByAlias == null) {
            this.fetchParentByAlias = new HashMap<String, HbmResultSetMappingDescriptor.HbmFetchParent>();
        }
        this.fetchParentByAlias.put(returnMapping.getAlias(), resultDescriptor);
        return this;
    }

    public ImplicitHbmResultSetMappingDescriptorBuilder addReturn(JaxbHbmNativeQueryJoinReturnType returnMapping) {
        if (this.joinDescriptors == null) {
            this.joinDescriptors = new HashMap<String, Map<String, HbmResultSetMappingDescriptor.JoinDescriptor>>();
        }
        if (this.fetchParentByAlias == null) {
            this.fetchParentByAlias = new HashMap<String, HbmResultSetMappingDescriptor.HbmFetchParent>();
        }
        HbmResultSetMappingDescriptor.collectJoinFetch(returnMapping, this.joinDescriptors, this.fetchParentByAlias, this.registrationName, this.metadataBuildingContext);
        return this;
    }

    public ImplicitHbmResultSetMappingDescriptorBuilder addReturn(JaxbHbmNativeQueryCollectionLoadReturnType returnMapping) {
        this.foundCollectionReturn = true;
        HbmResultSetMappingDescriptor.CollectionResultDescriptor resultDescriptor = new HbmResultSetMappingDescriptor.CollectionResultDescriptor(returnMapping, () -> this.joinDescriptors, this.registrationName, this.metadataBuildingContext);
        this.resultDescriptors.add(resultDescriptor);
        if (this.fetchParentByAlias == null) {
            this.fetchParentByAlias = new HashMap<String, HbmResultSetMappingDescriptor.HbmFetchParent>();
        }
        this.fetchParentByAlias.put(returnMapping.getAlias(), resultDescriptor);
        return this;
    }

    public HbmResultSetMappingDescriptor build(HbmLocalMetadataBuildingContext context) {
        if (this.foundCollectionReturn && this.resultDescriptors.size() > 1) {
            throw new MappingException("HBM return-collection ResultSet mapping cannot define entity or scalar returns : " + this.registrationName, context.getOrigin());
        }
        if (this.joinDescriptors != null && !this.foundEntityReturn && !this.foundCollectionReturn) {
            throw new MappingException("HBM return-join ResultSet mapping must be used in conjunction with root entity or collection return : " + this.registrationName, context.getOrigin());
        }
        return new HbmResultSetMappingDescriptor(this.registrationName, this.resultDescriptors, this.joinDescriptors != null ? this.joinDescriptors : Collections.emptyMap(), this.fetchParentByAlias != null ? this.fetchParentByAlias : Collections.emptyMap());
    }
}

