/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine;

import com.sos.commons.mail.SOSMail;
import com.sos.commons.util.SOSClassUtil;
import com.sos.commons.util.SOSCollection;
import com.sos.commons.util.SOSPath;
import com.sos.commons.util.loggers.base.ISOSLogger;
import com.sos.commons.vfs.commons.file.ProviderFile;
import com.sos.yade.commons.Yade;
import com.sos.yade.engine.addons.YADEEngineJumpHostAddon;
import com.sos.yade.engine.commons.YADEProviderFile;
import com.sos.yade.engine.commons.arguments.YADENotificationArguments;
import com.sos.yade.engine.commons.arguments.YADENotificationMailArguments;
import com.sos.yade.engine.commons.arguments.YADENotificationMailServerArguments;
import com.sos.yade.engine.commons.arguments.loaders.AYADEArgumentsLoader;
import com.sos.yade.engine.commons.delegators.YADEProviderDelegatorFactory;
import com.sos.yade.engine.commons.delegators.YADESourceProviderDelegator;
import com.sos.yade.engine.commons.delegators.YADETargetProviderDelegator;
import com.sos.yade.engine.commons.helpers.YADEArgumentsChecker;
import com.sos.yade.engine.commons.helpers.YADEClientBannerWriter;
import com.sos.yade.engine.commons.helpers.YADEClientHelper;
import com.sos.yade.engine.commons.helpers.YADEProviderDelegatorHelper;
import com.sos.yade.engine.exceptions.YADEEngineException;
import com.sos.yade.engine.exceptions.YADEEngineInitializationException;
import com.sos.yade.engine.handlers.command.YADECommandExecutor;
import com.sos.yade.engine.handlers.operations.YADEOperationsManager;
import com.sos.yade.engine.handlers.operations.copymove.file.commons.YADETargetProviderFile;
import com.sos.yade.engine.handlers.source.YADESourceFilesPolling;
import com.sos.yade.engine.handlers.source.YADESourceFilesSelector;
import com.sos.yade.engine.handlers.source.YADESourceFilesSteadyStateChecker;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class YADEEngine {
    private AtomicBoolean cancel = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<ProviderFile> execute(ISOSLogger logger, AYADEArgumentsLoader argsLoader, boolean writeYADEBanner) throws YADEEngineException {
        block21: {
            try {
                YADEClientBannerWriter.writeHeader(logger, argsLoader, writeYADEBanner);
                YADEArgumentsChecker.validateOrExit(logger, argsLoader);
                YADEClientHelper.setSystemPropertiesFromFiles(logger, argsLoader.getClientArgs());
                jumpHostAddon = YADEEngineJumpHostAddon.initialize(logger, argsLoader);
                sourceDelegator = YADEProviderDelegatorFactory.createSourceDelegator(logger, argsLoader.getArgs(), argsLoader.getSourceArgs());
                targetDelegator = YADEProviderDelegatorFactory.createTargetDelegator(logger, argsLoader.getArgs(), argsLoader.getTargetArgs());
            }
            catch (YADEEngineInitializationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new YADEEngineInitializationException(e);
            }
            operationDuration = null;
            exception = null;
            files = null;
            selectFiles = this.selectFiles(argsLoader, sourceDelegator, jumpHostAddon);
            sourceExcludedFileExtension = YADESourceFilesSelector.getExcludedFileExtension(argsLoader.getArgs(), sourceDelegator, targetDelegator);
            if (argsLoader.getSourceArgs().isPollingEnabled()) break block21;
            try {
                YADEProviderDelegatorHelper.ensureConnected(logger, sourceDelegator);
                if (jumpHostAddon != null) {
                    jumpHostAddon.onAfterSourceDelegatorConnected(sourceDelegator);
                }
                YADECommandExecutor.executeBeforeOperation(logger, sourceDelegator, jumpHostAddon);
                if (selectFiles) {
                    files = YADESourceFilesSelector.selectFiles(logger, sourceDelegator, sourceExcludedFileExtension);
                    YADESourceFilesSteadyStateChecker.check(logger, sourceDelegator, files);
                    YADESourceFilesSelector.checkSelectionResult(logger, sourceDelegator, argsLoader.getClientArgs(), files);
                }
                if (!SOSCollection.isEmpty(files)) {
                    YADEProviderDelegatorHelper.ensureConnected(logger, targetDelegator);
                    if (jumpHostAddon != null) {
                        jumpHostAddon.onAfterTargetDelegatorConnected(targetDelegator);
                    }
                    YADECommandExecutor.executeBeforeOperation(logger, targetDelegator);
                    operationDuration = YADEOperationsManager.process(logger, argsLoader.getArgs(), argsLoader.getClientArgs(), sourceDelegator, targetDelegator, files, this.cancel);
                }
                YADECommandExecutor.executeAfterOperationOnSuccess(logger, sourceDelegator, targetDelegator);
            }
            catch (Throwable e) {
                this.onError(logger, sourceDelegator, targetDelegator, exception);
                exception = e;
            }
            finally {
                this.onFinally(logger, argsLoader, operationDuration, sourceDelegator, targetDelegator, jumpHostAddon, files, exception, true);
            }
        }
        sourcePolling = new YADESourceFilesPolling(sourceDelegator);
        jumpHostAddonExecutedAfterSourceDelegatorConnected = false;
        jumpHostAddonExecutedAfterTargetDelegatorConnected = false;
        while (true) lbl-1000:
        // 3 sources

        {
            exception = null;
            operationDuration = null;
            sourcePolling.incrementCycleCounter();
            try {
                sourcePolling.ensureConnected(logger, sourceDelegator);
                if (jumpHostAddon != null && !jumpHostAddonExecutedAfterSourceDelegatorConnected) {
                    jumpHostAddon.onAfterSourceDelegatorConnected(sourceDelegator);
                    jumpHostAddonExecutedAfterSourceDelegatorConnected = true;
                }
                YADECommandExecutor.executeBeforeOperation(logger, sourceDelegator, jumpHostAddon);
                if (selectFiles) {
                    files = sourcePolling.selectFiles(logger, sourceDelegator, sourceExcludedFileExtension);
                    YADESourceFilesSteadyStateChecker.check(logger, sourceDelegator, files);
                    YADESourceFilesSelector.checkSelectionResult(logger, sourceDelegator, argsLoader.getClientArgs(), files);
                }
                if (!SOSCollection.isEmpty(files)) {
                    YADEProviderDelegatorHelper.ensureConnected(logger, targetDelegator);
                    if (jumpHostAddon != null && !jumpHostAddonExecutedAfterTargetDelegatorConnected) {
                        jumpHostAddon.onAfterTargetDelegatorConnected(targetDelegator);
                        jumpHostAddonExecutedAfterTargetDelegatorConnected = true;
                    }
                    YADECommandExecutor.executeBeforeOperation(logger, targetDelegator);
                    operationDuration = YADEOperationsManager.process(logger, argsLoader.getArgs(), argsLoader.getClientArgs(), sourceDelegator, targetDelegator, files, this.cancel);
                }
                YADECommandExecutor.executeAfterOperationOnSuccess(logger, sourceDelegator, targetDelegator);
                startNextPollingCycle = sourcePolling.startNextPollingCycle(logger);
                this.onFinally(logger, argsLoader, operationDuration, sourceDelegator, targetDelegator, jumpHostAddon, files, exception, startNextPollingCycle == false);
                if (startNextPollingCycle) ** GOTO lbl-1000
            }
            catch (Throwable e) {
                try {
                    this.onError(logger, sourceDelegator, targetDelegator, exception);
                    exception = e;
                    startNextPollingCycle = sourcePolling.startNextPollingCycle(logger);
                    this.onFinally(logger, argsLoader, operationDuration, sourceDelegator, targetDelegator, jumpHostAddon, files, exception, startNextPollingCycle == false);
                    if (startNextPollingCycle) continue;
                }
                catch (Throwable var16_21) {
                    startNextPollingCycle = sourcePolling.startNextPollingCycle(logger);
                    this.onFinally(logger, argsLoader, operationDuration, sourceDelegator, targetDelegator, jumpHostAddon, files, exception, startNextPollingCycle == false);
                    if (!startNextPollingCycle) break;
                    throw var16_21;
                }
            }
            break;
        }
        return files;
    }

    public void cancel(ISOSLogger logger) {
        logger.info((Object)"[cancel]...");
        this.cancel.set(true);
    }

    private boolean selectFiles(AYADEArgumentsLoader argsLoader, YADESourceProviderDelegator sourceDelegator, YADEEngineJumpHostAddon jumpHostAddon) {
        return jumpHostAddon == null || !sourceDelegator.isJumpHost() || !argsLoader.getArgs().isOperationGETLIST() && !argsLoader.getArgs().isOperationREMOVE();
    }

    private void onError(ISOSLogger logger, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, Throwable exception) {
        YADECommandExecutor.YADECommandResult r = YADECommandExecutor.executeAfterOperationOnError(logger, sourceDelegator, targetDelegator, exception);
        r.logIfErrorOnErrorLevel(logger);
    }

    private void onFinally(ISOSLogger logger, AYADEArgumentsLoader argsLoader, Duration operationDuration, YADESourceProviderDelegator sourceDelegator, YADETargetProviderDelegator targetDelegator, YADEEngineJumpHostAddon jumpHostAddon, List<ProviderFile> files, Throwable exception, boolean disconnectSource) throws YADEEngineException {
        YADECommandExecutor.YADECommandResult r = YADECommandExecutor.executeAfterOperationFinal(logger, sourceDelegator, targetDelegator, exception);
        r.logIfErrorOnErrorLevel(logger);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (exception != null) {
            exceptions.add(exception);
        }
        if (jumpHostAddon != null) {
            try {
                jumpHostAddon.onBeforeDelegatorDisconnected(sourceDelegator, targetDelegator, files, exception == null, disconnectSource);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (disconnectSource) {
            YADEProviderDelegatorHelper.disconnect(sourceDelegator);
        }
        YADEProviderDelegatorHelper.disconnect(targetDelegator);
        if (exceptions.size() == 0) {
            try {
                YADEClientHelper.writeResultSet(logger, (Yade.TransferOperation)argsLoader.getArgs().getOperation().getValue(), argsLoader.getClientArgs(), files);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        this.sendNotifications(logger, argsLoader, files, exceptions);
        YADEClientBannerWriter.writeSummary(logger, argsLoader.getArgs(), operationDuration, sourceDelegator, targetDelegator, jumpHostAddon, files, exception);
        if (exceptions.size() > 0 && disconnectSource) {
            if (exceptions.size() == 1) {
                Throwable e = (Throwable)exceptions.get(0);
                if (e instanceof YADEEngineException) {
                    throw (YADEEngineException)((Object)e);
                }
                throw new YADEEngineException(e);
            }
            StringBuilder msg = new StringBuilder();
            for (Throwable e : exceptions) {
                msg.append("[").append(e.toString()).append("]");
            }
            throw new YADEEngineException(msg.toString(), (Throwable)exceptions.get(0));
        }
    }

    private void sendNotifications(ISOSLogger logger, AYADEArgumentsLoader argsLoader, List<ProviderFile> files, List<Throwable> exceptions) {
        if (argsLoader.getNotificationArgs() == null || !argsLoader.getNotificationArgs().isEnabled()) {
            return;
        }
        YADENotificationArguments args = argsLoader.getNotificationArgs();
        YADENotificationMailServerArguments mailServerArgs = args.getMailServer();
        if (exceptions.size() > 0) {
            if (args.getMailOnError() == null) {
                return;
            }
            YADENotificationMailArguments mailArgs = args.getMailOnError();
            String body = mailArgs.getBody().getValue() == null ? "" : (String)mailArgs.getBody().getValue() + mailArgs.getNewLine();
            StringBuilder sb = new StringBuilder();
            sb.append(body);
            for (Throwable e : exceptions) {
                sb.append(SOSClassUtil.getStackTrace((Throwable)e, (String)mailArgs.getNewLine()));
            }
            mailArgs.getBody().setValue((Object)sb.toString());
            this.sendMail(logger, mailServerArgs, mailArgs, "OnError");
        } else {
            StringBuilder sb;
            String body;
            YADENotificationMailArguments mailArgs;
            if (argsLoader.getNotificationArgs().getMailOnSuccess() != null) {
                mailArgs = args.getMailOnSuccess();
                body = mailArgs.getBody().getValue() == null ? "" : (String)mailArgs.getBody().getValue() + mailArgs.getNewLine();
                sb = new StringBuilder();
                for (ProviderFile f : files) {
                    YADEProviderFile file = (YADEProviderFile)f;
                    YADETargetProviderFile targetFile = file.getTarget();
                    sb.append(file.getFinalFullPath());
                    if (targetFile == null) {
                        if (file.getState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(file.getState())).append("]");
                        }
                        if (file.getSubState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(file.getSubState())).append("]");
                        }
                    } else {
                        if (targetFile.getState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(targetFile.getState())).append("]");
                        }
                        if (targetFile.getSubState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(targetFile.getSubState())).append("]");
                        }
                    }
                    sb.append("[Bytes ").append(file.getSize()).append("]");
                    sb.append(mailArgs.getNewLine());
                }
                mailArgs.getBody().setValue((Object)(body + sb.toString()));
                this.sendMail(logger, mailServerArgs, mailArgs, "OnSuccess");
            }
            if (argsLoader.getNotificationArgs().getMailOnEmptyFiles() != null) {
                mailArgs = args.getMailOnEmptyFiles();
                body = mailArgs.getBody().getValue() == null ? "" : (String)mailArgs.getBody().getValue() + mailArgs.getNewLine();
                sb = new StringBuilder();
                int counterEmpyFiles = 0;
                for (ProviderFile f : files) {
                    YADEProviderFile file = (YADEProviderFile)f;
                    if (file.getSize() > 0L) continue;
                    ++counterEmpyFiles;
                    YADETargetProviderFile targetFile = file.getTarget();
                    sb.append(file.getFinalFullPath());
                    if (targetFile == null) {
                        if (file.getState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(file.getState())).append("]");
                        }
                        if (file.getSubState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(file.getSubState())).append("]");
                        }
                    } else {
                        if (targetFile.getState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(targetFile.getState())).append("]");
                        }
                        if (targetFile.getSubState() != null) {
                            sb.append("[").append(YADEClientBannerWriter.formatState(targetFile.getSubState())).append("]");
                        }
                    }
                    sb.append("[Bytes ").append(file.getSize()).append("]");
                    sb.append(mailArgs.getNewLine());
                }
                if (counterEmpyFiles > 0) {
                    mailArgs.getBody().setValue((Object)(body + sb.toString()));
                    this.sendMail(logger, mailServerArgs, mailArgs, "OnEmptyFiles");
                }
            }
        }
    }

    private void sendMail(ISOSLogger logger, YADENotificationMailServerArguments mailServerArgs, YADENotificationMailArguments mailArgs, String label) {
        try {
            SOSMail mail = new SOSMail(mailServerArgs.getMailSettings());
            mail.setFrom((String)mailArgs.getHeaderFrom().getValue());
            for (String to : (List)mailArgs.getHeaderTo().getValue()) {
                mail.addRecipient(to);
            }
            if (!mailArgs.getHeaderCC().isEmpty()) {
                for (String cc : (List)mailArgs.getHeaderCC().getValue()) {
                    mail.addCC(cc);
                }
            }
            if (!mailArgs.getHeaderBCC().isEmpty()) {
                for (String bcc : (List)mailArgs.getHeaderBCC().getValue()) {
                    mail.addBCC(bcc);
                }
            }
            if (!mailArgs.getAttachment().isEmpty()) {
                for (Path attachment : (List)mailArgs.getAttachment().getValue()) {
                    mail.addAttachment(SOSPath.toAbsoluteNormalizedPath((Path)attachment).toString());
                }
            }
            mail.setSubject(mailArgs.getHeaderSubject().getValue() == null ? label : (String)mailArgs.getHeaderSubject().getValue());
            mail.setBody((String)mailArgs.getBody().getValue());
            mail.setContentType((String)mailArgs.getContentType().getValue());
            mail.setEncoding((String)mailArgs.getEncoding().getValue());
            if (!mailServerArgs.getQueueDirectory().isEmpty()) {
                mail.setQueueMailOnError(true);
                mail.setQueueDir((String)mailServerArgs.getQueueDirectory().getValue());
            }
            if (!mail.send(logger)) {
                logger.warn((Object)"[sendMail]failed");
            }
        }
        catch (Exception e) {
            logger.warn("[sendMail]" + e, (Throwable)e);
        }
    }
}

