/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments;

import com.sos.commons.util.SOSString;
import com.sos.commons.util.arguments.base.ASOSArguments;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.vfs.exceptions.ProviderInitializationException;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.yade.engine.commons.arguments.YADEProviderCommandArguments;

public class YADEJumpHostArguments
extends ASOSArguments {
    public static final String LABEL = "Jump";
    private SSHProviderArguments provider;
    private YADEProviderCommandArguments commands;
    private SOSArgument<String> tempDirectoryParent = new SOSArgument("TempDirectoryParent", false, (Object)"/tmp");
    private SOSArgument<JumpPlatform> platform = new SOSArgument("Platform", false);
    private SOSArgument<String> yadeClientCommand = new SOSArgument("YADEClientCommand", false);
    private SOSArgument<Boolean> configuredOnSource = new SOSArgument(null, false);

    public SSHProviderArguments getProvider() {
        if (this.provider == null) {
            this.provider = new SSHProviderArguments();
            this.provider.applyDefaultIfNullQuietly();
        }
        return this.provider;
    }

    public YADEProviderCommandArguments getCommands() {
        if (this.commands == null) {
            this.commands = new YADEProviderCommandArguments();
            this.commands.applyDefaultIfNullQuietly();
        }
        return this.commands;
    }

    public SOSArgument<String> getTempDirectoryParent() {
        return this.tempDirectoryParent;
    }

    public SOSArgument<JumpPlatform> getPlatform() {
        return this.platform;
    }

    public boolean isPlatformEnabled() {
        return !this.platform.isEmpty();
    }

    public boolean isWindowsPlatform() {
        return this.isPlatformEnabled() && JumpPlatform.WINDOWS.equals(this.platform.getValue());
    }

    public void setPlatform(String val) {
        if (SOSString.isEmpty((String)val)) {
            return;
        }
        this.platform.setValue((Object)JumpPlatform.valueOf(val.trim().toUpperCase()));
    }

    public SOSArgument<String> getYADEClientCommand() {
        return this.yadeClientCommand;
    }

    public SOSArgument<Boolean> getConfiguredOnSource() {
        return this.configuredOnSource;
    }

    public boolean isConfiguredOnSource() {
        return this.configuredOnSource.isTrue();
    }

    public String getAccessInfo() throws ProviderInitializationException {
        return this.provider == null ? null : this.provider.getAccessInfo();
    }

    public String getAdvancedAccessInfo() {
        return this.provider == null ? null : this.provider.getAdvancedAccessInfo();
    }

    public static enum JumpPlatform {
        UNIX,
        WINDOWS;

    }
}

