/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders.xml;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.httpclient.azure.commons.auth.blob.AzureBlobStorageClientAuthMethod;
import com.sos.commons.util.arguments.base.SOSArgument;
import com.sos.commons.util.keystore.KeyStoreType;
import com.sos.commons.util.proxy.ProxyConfigArguments;
import com.sos.commons.util.ssl.SslArguments;
import com.sos.commons.vfs.azure.commons.AzureBlobStorageProviderArguments;
import com.sos.commons.vfs.commons.AProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPSProviderArguments;
import com.sos.commons.vfs.ftp.commons.FTPSSecurityMode;
import com.sos.commons.vfs.http.commons.HTTPProviderArguments;
import com.sos.commons.vfs.http.commons.HTTPSProviderArguments;
import com.sos.commons.vfs.smb.commons.SMBAuthMethod;
import com.sos.commons.vfs.smb.commons.SMBProviderArguments;
import com.sos.commons.vfs.ssh.commons.SSHAuthMethod;
import com.sos.commons.vfs.ssh.commons.SSHProviderArguments;
import com.sos.commons.vfs.webdav.commons.WebDAVProviderArguments;
import com.sos.commons.vfs.webdav.commons.WebDAVSProviderArguments;
import com.sos.commons.xml.SOSXML;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLArgumentsLoader;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLFragmentsCredentialStoreFragmentHelper;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLFragmentsProtocolFragmentJumpHelper;
import java.net.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YADEXMLFragmentsProtocolFragmentHelper {
    protected static AzureBlobStorageProviderArguments parseAzureBlobStorage(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "AzureBlobStorage");
        AzureBlobStorageProviderArguments args = new AzureBlobStorageProviderArguments();
        args.applyDefaultIfNullQuietly();
        args.getAuthMethod().setValue((Object)AzureBlobStorageClientAuthMethod.PUBLIC);
        NodeList nl = fragment.getChildNodes();
        block18: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block18;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block18;
                }
                case "AzureBlobStorageConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseAzureBlobStorageConnection(argsLoader, args, n);
                    continue block18;
                }
                case "AzureBlobStorageAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseAzureBlobStorageAuthentication(argsLoader, args, n);
                    continue block18;
                }
                case "ProxyForAzure": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block18;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, args, n);
                    continue block18;
                }
                case "SSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSSL(argsLoader, args.getSsl(), n);
                }
            }
        }
        return args;
    }

    protected static FTPProviderArguments parseFTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "FTP");
        FTPProviderArguments args = new FTPProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block22: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                    continue block22;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block22;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block22;
                }
                case "BasicConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicConnection(argsLoader, (AProviderArguments)args, n);
                    continue block22;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicAuthentication(argsLoader, (AProviderArguments)args, n);
                    continue block22;
                }
                case "ProxyForFTP": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block22;
                }
                case "KeepAlive": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseFTPKeepAlive(argsLoader, args, n);
                    continue block22;
                }
                case "PassiveMode": {
                    argsLoader.setBooleanArgumentValue((SOSArgument<Boolean>)args.getPassiveMode(), n);
                    continue block22;
                }
                case "TransferMode": {
                    FTPProviderArguments.TransferMode transferMode = FTPProviderArguments.TransferMode.fromString((String)argsLoader.getValue(n));
                    if (transferMode == null) continue block22;
                    args.getTransferMode().setValue((Object)transferMode);
                }
            }
        }
        return args;
    }

    protected static FTPSProviderArguments parseFTPS(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "FTPS");
        FTPSProviderArguments args = new FTPSProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block26: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "FTPSClientSecurity": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseYADE1FTPSClientSecurity(argsLoader, args, n);
                    continue block26;
                }
                case "FTPSProtocol": {
                    args.getSsl().getEnabledProtocols().setValue((Object)argsLoader.getValue(n));
                    continue block26;
                }
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                    continue block26;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block26;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block26;
                }
                case "BasicConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicConnection(argsLoader, (AProviderArguments)args, n);
                    continue block26;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicAuthentication(argsLoader, (AProviderArguments)args, n);
                    continue block26;
                }
                case "ProxyForFTPS": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block26;
                }
                case "KeepAlive": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseFTPKeepAlive(argsLoader, (FTPProviderArguments)args, n);
                    continue block26;
                }
                case "SecurityMode": {
                    FTPSSecurityMode securityMode = FTPSSecurityMode.fromString((String)argsLoader.getValue(n));
                    if (securityMode == null) continue block26;
                    args.getSecurityMode().setValue((Object)securityMode);
                    continue block26;
                }
                case "SSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSSL(argsLoader, args.getSsl(), n);
                }
            }
        }
        return args;
    }

    protected static HTTPProviderArguments parseHTTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "HTTP");
        HTTPProviderArguments args = new HTTPProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block16: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block16;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block16;
                }
                case "URLConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseURLConnection(argsLoader, (AProviderArguments)args, n);
                    continue block16;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicAuthentication(argsLoader, (AProviderArguments)args, n);
                    continue block16;
                }
                case "ProxyForHTTP": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block16;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, args, n);
                }
            }
        }
        return args;
    }

    protected static HTTPSProviderArguments parseHTTPS(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "HTTPS");
        HTTPSProviderArguments args = new HTTPSProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block24: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AcceptUntrustedCertificate": {
                    argsLoader.setBooleanArgumentValue((SOSArgument<Boolean>)args.getSsl().getUntrustedSsl(), n);
                    continue block24;
                }
                case "DisableCertificateHostnameVerification": {
                    argsLoader.setOppositeBooleanArgumentValue((SOSArgument<Boolean>)args.getSsl().getUntrustedSslVerifyCertificateHostname(), n);
                    continue block24;
                }
                case "KeyStore": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseYADE1KeyStore(argsLoader, args.getSsl(), n);
                    continue block24;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block24;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block24;
                }
                case "URLConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseURLConnection(argsLoader, (AProviderArguments)args, n);
                    continue block24;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicAuthentication(argsLoader, (AProviderArguments)args, n);
                    continue block24;
                }
                case "ProxyForHTTP": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block24;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, (HTTPProviderArguments)args, n);
                    continue block24;
                }
                case "SSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSSL(argsLoader, args.getSsl(), n);
                }
            }
        }
        return args;
    }

    protected static SSHProviderArguments parseSFTP(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "SFTP");
        SSHProviderArguments args = new SSHProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block30: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "ServerAliveInterval": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getServerAliveInterval(), n);
                    continue block30;
                }
                case "ServerAliveCountMax": {
                    argsLoader.setIntegerArgumentValue((SOSArgument<Integer>)args.getServerAliveCountMax(), n);
                    continue block30;
                }
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                    continue block30;
                }
                case "ChannelConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getSocketTimeout(), n);
                    continue block30;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block30;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block30;
                }
                case "BasicConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicConnection(argsLoader, (AProviderArguments)args, n);
                    continue block30;
                }
                case "SSHAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSFTPSSHAuthentication(argsLoader, args, n);
                    continue block30;
                }
                case "ProxyForSFTP": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block30;
                }
                case "SocketTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getSocketTimeout(), n);
                    continue block30;
                }
                case "KeepAlive": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSFTPKeepAlive(argsLoader, args, n);
                    continue block30;
                }
                case "StrictHostkeyChecking": {
                    argsLoader.setBooleanArgumentValue((SOSArgument<Boolean>)args.getStrictHostkeyChecking(), n);
                    continue block30;
                }
                case "ConfigurationFiles": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseConfigurationFiles(argsLoader, (AProviderArguments)args, n);
                }
            }
        }
        return args;
    }

    protected static SMBProviderArguments parseSMB(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "SMB");
        SMBProviderArguments args = new SMBProviderArguments();
        args.applyDefaultIfNullQuietly();
        NodeList nl = fragment.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Hostname": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    args.tryRedefineHostPort();
                    continue block14;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block14;
                }
                case "SMBConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBConnection(argsLoader, args, n);
                    continue block14;
                }
                case "SMBAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBAuthentication(argsLoader, args, n);
                    continue block14;
                }
                case "ConfigurationFiles": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseConfigurationFiles(argsLoader, (AProviderArguments)args, n);
                }
            }
        }
        return args;
    }

    protected static WebDAVProviderArguments parseWebDAV(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource) throws Exception {
        Node fragment = YADEXMLFragmentsProtocolFragmentHelper.getProtocolFragment(argsLoader, ref, isSource, "WebDAV");
        Node urlConnectionURL = argsLoader.getXPath().selectNode(fragment, "URLConnection/URL");
        if (urlConnectionURL == null) {
            throw new SOSMissingDataException("[WebDAV]URLConnection/URL");
        }
        String url = argsLoader.getValue(urlConnectionURL);
        String urlLC = url.toLowerCase();
        WebDAVSProviderArguments args = urlLC.startsWith("https://") || urlLC.startsWith("webdavs://") ? new WebDAVSProviderArguments() : new WebDAVProviderArguments();
        args.applyDefaultIfNullQuietly();
        args.getHost().setValue((Object)url);
        Node urlConnectionConnectTimeout = argsLoader.getXPath().selectNode(fragment, "URLConnection/ConnectTimeout");
        if (urlConnectionConnectTimeout != null) {
            args.getConnectTimeout().setValue((Object)argsLoader.getValue(urlConnectionConnectTimeout));
        }
        NodeList nl = fragment.getChildNodes();
        block22: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AcceptUntrustedCertificate": {
                    argsLoader.setBooleanArgumentValue((SOSArgument<Boolean>)args.getSsl().getUntrustedSsl(), n);
                    continue block22;
                }
                case "DisableCertificateHostnameVerification": {
                    argsLoader.setOppositeBooleanArgumentValue((SOSArgument<Boolean>)args.getSsl().getUntrustedSslVerifyCertificateHostname(), n);
                    continue block22;
                }
                case "KeyStore": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseYADE1KeyStore(argsLoader, args.getSsl(), n);
                    continue block22;
                }
                case "CredentialStoreFragmentRef": {
                    YADEXMLFragmentsCredentialStoreFragmentHelper.parse(argsLoader, n, isSource, (AProviderArguments)args);
                    continue block22;
                }
                case "JumpFragmentRef": {
                    YADEXMLFragmentsProtocolFragmentJumpHelper.parse(argsLoader, n, isSource);
                    continue block22;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseBasicAuthentication(argsLoader, (AProviderArguments)args, n);
                    continue block22;
                }
                case "ProxyForWebDAV": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, (AProviderArguments)args, n);
                    continue block22;
                }
                case "HTTPHeaders": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseHTTPHeaders(argsLoader, (HTTPProviderArguments)args, n);
                    continue block22;
                }
                case "SSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSSL(argsLoader, args.getSsl(), n);
                }
            }
        }
        return args;
    }

    protected static void parseHTTPHeaders(YADEXMLArgumentsLoader argsLoader, AzureBlobStorageProviderArguments args, Node headers) throws Exception {
        NodeList nl = headers.getChildNodes();
        if (args.getHttpHeaders().getValue() == null) {
            args.getHttpHeaders().setValue(new ArrayList());
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "HTTPHeader": {
                    ((List)args.getHttpHeaders().getValue()).add(argsLoader.getValue(n));
                }
            }
        }
    }

    protected static void parseHTTPHeaders(YADEXMLArgumentsLoader argsLoader, HTTPProviderArguments args, Node headers) throws Exception {
        NodeList nl = headers.getChildNodes();
        if (args.getHttpHeaders().getValue() == null) {
            args.getHttpHeaders().setValue(new ArrayList());
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "HTTPHeader": {
                    ((List)args.getHttpHeaders().getValue()).add(argsLoader.getValue(n));
                }
            }
        }
    }

    protected static Node getProtocolFragment(YADEXMLArgumentsLoader argsLoader, Node ref, boolean isSource, String fragmentPrefix) throws Exception {
        String exp = "Fragments/ProtocolFragments/" + fragmentPrefix + "Fragment[@name='" + SOSXML.getAttributeValue((Node)ref, (String)"ref") + "']";
        Node node = argsLoader.getXPath().selectNode(argsLoader.getRoot(), exp);
        if (node == null) {
            throw new SOSMissingDataException("[profile=" + (String)argsLoader.getArgs().getProfile().getValue() + "][" + (isSource ? "Source" : "Target") + "][" + exp + "]referenced Protocol fragment not found");
        }
        return node;
    }

    protected static void parseBasicConnection(YADEXMLArgumentsLoader argsLoader, AProviderArguments args, Node basicConnection) throws Exception {
        NodeList nl = basicConnection.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Hostname": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    continue block10;
                }
                case "Port": {
                    argsLoader.setIntegerArgumentValue((SOSArgument<Integer>)args.getPort(), n);
                    continue block10;
                }
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                }
            }
        }
    }

    protected static void parseConfigurationFiles(YADEXMLArgumentsLoader argsLoader, AProviderArguments args, Node configurationFiles) {
        ArrayList<Path> files = new ArrayList<Path>();
        NodeList nl = configurationFiles.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"ConfigurationFile".equals(n.getNodeName())) continue;
            files.add(Path.of(argsLoader.getValue(n), new String[0]));
        }
        if (files.size() > 0) {
            args.getConfigurationFiles().setValue(files);
        }
    }

    protected static void parseProxy(YADEXMLArgumentsLoader argsLoader, AProviderArguments args, Node proxy) throws Exception {
        NodeList nl = proxy.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            ProxyConfigArguments proxyArgs = new ProxyConfigArguments();
            proxyArgs.applyDefaultIfNullQuietly();
            block12: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "SOCKS4Proxy": {
                        proxyArgs.getType().setValue((Object)Proxy.Type.SOCKS);
                        YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, proxyArgs, n);
                        continue block12;
                    }
                    case "SOCKS5Proxy": {
                        proxyArgs.getType().setValue((Object)Proxy.Type.SOCKS);
                        YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, proxyArgs, n);
                        continue block12;
                    }
                    case "HTTPProxy": {
                        proxyArgs.getType().setValue((Object)Proxy.Type.HTTP);
                        YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, proxyArgs, n);
                        continue block12;
                    }
                    case "SOCKSProxy": {
                        proxyArgs.getType().setValue((Object)Proxy.Type.SOCKS);
                        YADEXMLFragmentsProtocolFragmentHelper.parseProxy(argsLoader, proxyArgs, n);
                    }
                }
            }
            args.setProxy(proxyArgs);
        }
    }

    protected static void parseSFTPSSHAuthentication(YADEXMLArgumentsLoader argsLoader, SSHProviderArguments args, Node sshAuthentication) {
        NodeList nl = sshAuthentication.getChildNodes();
        SSHAuthMethod authMethod = null;
        block16: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block16;
                }
                case "AuthenticationMethodPassword": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSFTPSSHAuthenticationMethodPassword(argsLoader, args, n);
                    authMethod = SSHAuthMethod.PASSWORD;
                    continue block16;
                }
                case "AuthenticationMethodPublickey": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSFTPSSHAuthenticationMethodPublickey(argsLoader, args, n);
                    authMethod = SSHAuthMethod.PUBLICKEY;
                    continue block16;
                }
                case "AuthenticationMethodKeyboardInteractive": {
                    authMethod = SSHAuthMethod.KEYBOARD_INTERACTIVE;
                    continue block16;
                }
                case "PreferredAuthentications": {
                    args.getPreferredAuthentications().setValue((Object)SSHAuthMethod.fromString((String)argsLoader.getValue(n)));
                    continue block16;
                }
                case "RequiredAuthentications": {
                    args.getRequiredAuthentications().setValue((Object)SSHAuthMethod.fromString((String)argsLoader.getValue(n)));
                }
            }
        }
        args.getAuthMethod().setValue(authMethod);
    }

    private static void parseBasicAuthentication(YADEXMLArgumentsLoader argsLoader, AProviderArguments args, Node basicAuthentication) throws Exception {
        NodeList nl = basicAuthentication.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block8;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                }
            }
        }
    }

    private static void parseAzureBlobStorageConnection(YADEXMLArgumentsLoader argsLoader, AzureBlobStorageProviderArguments args, Node urlConnection) throws Exception {
        NodeList nl = urlConnection.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "ServiceEndpoint": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    args.getServiceEndpoint().setValue((Object)((String)args.getHost().getValue()));
                    continue block8;
                }
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                }
            }
        }
    }

    private static void parseAzureBlobStorageAuthentication(YADEXMLArgumentsLoader argsLoader, AzureBlobStorageProviderArguments args, Node basicAuthentication) throws Exception {
        NodeList nl = basicAuthentication.getChildNodes();
        block14: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AccountName": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block14;
                }
                case "ContainerName": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getContainerName(), n);
                    continue block14;
                }
                case "ApiVersion": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getApiVersion(), n);
                    continue block14;
                }
                case "SharedKey": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseAzureSharedKey(argsLoader, args, n);
                    continue block14;
                }
                case "SASToken": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseAzureSASToken(argsLoader, args, n);
                }
            }
        }
    }

    private static void parseAzureSharedKey(YADEXMLArgumentsLoader argsLoader, AzureBlobStorageProviderArguments args, Node sharedKey) throws Exception {
        args.getAuthMethod().setValue((Object)AzureBlobStorageClientAuthMethod.SHARED_KEY);
        NodeList nl = sharedKey.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AccountKey": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getAccountKey(), n);
                }
            }
        }
    }

    private static void parseAzureSASToken(YADEXMLArgumentsLoader argsLoader, AzureBlobStorageProviderArguments args, Node sasToken) throws Exception {
        args.getAuthMethod().setValue((Object)AzureBlobStorageClientAuthMethod.SAS_TOKEN);
        NodeList nl = sasToken.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AccountKey": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getAccountKey(), n);
                    continue block8;
                }
                case "Token": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getSASToken(), n);
                }
            }
        }
    }

    private static void parseURLConnection(YADEXMLArgumentsLoader argsLoader, AProviderArguments args, Node urlConnection) throws Exception {
        NodeList nl = urlConnection.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "URL": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    continue block8;
                }
                case "ConnectTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getConnectTimeout(), n);
                }
            }
        }
    }

    private static void parseSSL(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node ssl) throws Exception {
        if (args == null) {
            return;
        }
        NodeList nl = ssl.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "TrustedSSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseTrustedSSL(argsLoader, args, n);
                    continue block10;
                }
                case "UntrustedSSL": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseUntrustedSSL(argsLoader, args, n);
                    continue block10;
                }
                case "EnabledProtocols": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getEnabledProtocols(), n);
                }
            }
        }
    }

    private static void parseTrustedSSL(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node trustedSSL) throws Exception {
        NodeList nl = trustedSSL.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "TrustStore": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseTrustedSSLTrustStore(argsLoader, args, n);
                    continue block8;
                }
                case "KeyStore": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseTrustedSSLKeyStore(argsLoader, args, n);
                }
            }
        }
    }

    private static void parseTrustedSSLTrustStore(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node trustStore) {
        NodeList nl = trustStore.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "TrustStoreType": {
                    KeyStoreType keyStoreType = KeyStoreType.fromString((String)argsLoader.getValue(n));
                    if (keyStoreType == null) continue block10;
                    args.getTrustedSsl().getTrustStoreType().setValue((Object)keyStoreType);
                    continue block10;
                }
                case "TrustStoreFile": {
                    args.getTrustedSsl().getTrustStoreFile().setValue((Object)Path.of(argsLoader.getValue(n), new String[0]));
                    continue block10;
                }
                case "TrustStorePassword": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getTrustedSsl().getTrustStorePassword(), n);
                }
            }
        }
    }

    private static void parseTrustedSSLKeyStore(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node keyStore) {
        NodeList nl = keyStore.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "KeyStoreType": {
                    KeyStoreType keyStoreType = KeyStoreType.fromString((String)argsLoader.getValue(n));
                    if (keyStoreType == null) continue block10;
                    args.getTrustedSsl().getKeyStoreType().setValue((Object)keyStoreType);
                    continue block10;
                }
                case "KeyStoreFile": {
                    args.getTrustedSsl().getKeyStoreFile().setValue((Object)Path.of(argsLoader.getValue(n), new String[0]));
                    continue block10;
                }
                case "KeyStorePassword": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getTrustedSsl().getKeyStorePassword(), n);
                }
            }
        }
    }

    private static void parseYADE1KeyStore(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node keyStore) {
        NodeList nl = keyStore.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "KeyStoreType": {
                    KeyStoreType keyStoreType = KeyStoreType.fromString((String)argsLoader.getValue(n));
                    if (keyStoreType == null) continue block10;
                    args.getTrustedSsl().getTrustStoreType().setValue((Object)keyStoreType);
                    continue block10;
                }
                case "KeyStoreFile": {
                    args.getTrustedSsl().getTrustStoreFile().setValue((Object)Path.of(argsLoader.getValue(n), new String[0]));
                    continue block10;
                }
                case "KeyStorePassword": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getTrustedSsl().getTrustStorePassword(), n);
                }
            }
        }
    }

    private static void parseUntrustedSSL(YADEXMLArgumentsLoader argsLoader, SslArguments args, Node untrustedSSL) throws Exception {
        args.getUntrustedSsl().setValue((Object)true);
        NodeList nl = untrustedSSL.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "DisableCertificateHostnameVerification": {
                    argsLoader.setOppositeBooleanArgumentValue((SOSArgument<Boolean>)args.getUntrustedSslVerifyCertificateHostname(), n);
                }
            }
        }
    }

    private static void parseProxy(YADEXMLArgumentsLoader argsLoader, ProxyConfigArguments args, Node proxy) throws Exception {
        NodeList nl = proxy.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "BasicConnection": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxyBasicConnection(argsLoader, args, n);
                    continue block8;
                }
                case "BasicAuthentication": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseProxyBasicAuthentication(argsLoader, args, n);
                }
            }
        }
    }

    private static void parseProxyBasicConnection(YADEXMLArgumentsLoader argsLoader, ProxyConfigArguments args, Node basicConnection) throws Exception {
        NodeList nl = basicConnection.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Hostname": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    continue block8;
                }
                case "Port": {
                    argsLoader.setIntegerArgumentValue((SOSArgument<Integer>)args.getPort(), n);
                }
            }
        }
    }

    private static void parseProxyBasicAuthentication(YADEXMLArgumentsLoader argsLoader, ProxyConfigArguments args, Node basicAuthentication) throws Exception {
        NodeList nl = basicAuthentication.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block8;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                }
            }
        }
    }

    private static void parseFTPKeepAlive(YADEXMLArgumentsLoader argsLoader, FTPProviderArguments args, Node keepAlive) {
        NodeList nl = keepAlive.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "KeepAliveTimeout": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getKeepAliveTimeout(), n);
                }
            }
        }
    }

    public static void parseSFTPKeepAlive(YADEXMLArgumentsLoader argsLoader, SSHProviderArguments args, Node keepAlive) {
        NodeList nl = keepAlive.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "KeepAliveInterval": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getServerAliveInterval(), n);
                    continue block8;
                }
                case "MaxAliveCount": {
                    argsLoader.setIntegerArgumentValue((SOSArgument<Integer>)args.getServerAliveCountMax(), n);
                }
            }
        }
    }

    private static void parseSFTPSSHAuthenticationMethodPassword(YADEXMLArgumentsLoader argsLoader, SSHProviderArguments args, Node methodPassword) {
        NodeList nl = methodPassword.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                }
            }
        }
    }

    private static void parseSFTPSSHAuthenticationMethodPublickey(YADEXMLArgumentsLoader argsLoader, SSHProviderArguments args, Node methodPublickey) {
        NodeList nl = methodPublickey.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "AuthenticationFile": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getAuthFile(), n);
                    continue block8;
                }
                case "Passphrase": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassphrase(), n);
                }
            }
        }
    }

    private static void parseYADE1FTPSClientSecurity(YADEXMLArgumentsLoader argsLoader, FTPSProviderArguments args, Node clientSecurity) {
        NodeList nl = clientSecurity.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "SecurityMode": {
                    FTPSSecurityMode securityMode = FTPSSecurityMode.fromString((String)argsLoader.getValue(n));
                    if (securityMode == null) continue block12;
                    args.getSecurityMode().setValue((Object)securityMode);
                    continue block12;
                }
                case "KeyStoreType": {
                    KeyStoreType keyStoreType = KeyStoreType.fromString((String)argsLoader.getValue(n));
                    if (keyStoreType == null) continue block12;
                    args.getSsl().getTrustedSsl().getTrustStoreType().setValue((Object)keyStoreType);
                    continue block12;
                }
                case "KeyStoreFile": {
                    args.getSsl().getTrustedSsl().getTrustStoreFile().setValue((Object)Path.of(argsLoader.getValue(n), new String[0]));
                    continue block12;
                }
                case "KeyStorePassword": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getSsl().getTrustedSsl().getTrustStorePassword(), n);
                }
            }
        }
    }

    private static void parseSMBConnection(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node smbAuthentication) {
        NodeList nl = smbAuthentication.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Hostname": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getHost(), n);
                    continue block10;
                }
                case "Port": {
                    argsLoader.setIntegerArgumentValue((SOSArgument<Integer>)args.getPort(), n);
                    continue block10;
                }
                case "Sharename": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getShareName(), n);
                }
            }
        }
    }

    private static void parseSMBAuthentication(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node smbAuthentication) {
        NodeList nl = smbAuthentication.getChildNodes();
        boolean account = false;
        block20: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    account = true;
                    continue block20;
                }
                case "Domain": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getDomain(), n);
                    continue block20;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                    continue block20;
                }
                case "SMBAuthenticationMethodAnonymous": {
                    args.getAuthMethod().setValue((Object)SMBAuthMethod.ANONYMOUS);
                    continue block20;
                }
                case "SMBAuthenticationMethodGuest": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBAuthenticationMethodGuest(argsLoader, args, n);
                    continue block20;
                }
                case "SMBAuthenticationMethodNTLM": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBAuthenticationMethodNTLM(argsLoader, args, n);
                    continue block20;
                }
                case "SMBAuthenticationMethodKerberos": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBAuthenticationMethodKerberos(argsLoader, args, n);
                    continue block20;
                }
                case "SMBAuthenticationMethodSPNEGO": {
                    YADEXMLFragmentsProtocolFragmentHelper.parseSMBAuthenticationMethodSPNEGO(argsLoader, args, n);
                }
            }
        }
        if (account) {
            if (args.getPassword().isEmpty() && args.getDomain().isEmpty()) {
                if (SMBAuthMethod.ANONYMOUS.name().equalsIgnoreCase((String)args.getUser().getValue())) {
                    args.getAuthMethod().setValue((Object)SMBAuthMethod.ANONYMOUS);
                } else {
                    args.getAuthMethod().setValue((Object)SMBAuthMethod.GUEST);
                }
            } else {
                args.getAuthMethod().setValue((Object)SMBAuthMethod.NTLM);
            }
        }
    }

    private static void parseSMBAuthenticationMethodGuest(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node node) {
        NodeList nl = node.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block8;
                }
                case "Domain": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getDomain(), n);
                }
            }
        }
        if (args.getUser().isEmpty()) {
            args.getUser().setValue((Object)"guest");
        }
        args.getAuthMethod().setValue((Object)SMBAuthMethod.GUEST);
    }

    private static void parseSMBAuthenticationMethodNTLM(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node node) {
        NodeList nl = node.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block10;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                    continue block10;
                }
                case "Domain": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getDomain(), n);
                }
            }
        }
        args.getAuthMethod().setValue((Object)SMBAuthMethod.NTLM);
    }

    private static void parseSMBAuthenticationMethodKerberos(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node node) {
        NodeList nl = node.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block12;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                    continue block12;
                }
                case "Domain": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getDomain(), n);
                    continue block12;
                }
                case "LoginContextName": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getLoginContextName(), n);
                }
            }
        }
        args.getAuthMethod().setValue((Object)SMBAuthMethod.KERBEROS);
    }

    private static void parseSMBAuthenticationMethodSPNEGO(YADEXMLArgumentsLoader argsLoader, SMBProviderArguments args, Node node) {
        NodeList nl = node.getChildNodes();
        block12: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getUser(), n);
                    continue block12;
                }
                case "Password": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getPassword(), n);
                    continue block12;
                }
                case "Domain": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getDomain(), n);
                    continue block12;
                }
                case "LoginContextName": {
                    argsLoader.setStringArgumentValue((SOSArgument<String>)args.getLoginContextName(), n);
                }
            }
        }
        args.getAuthMethod().setValue((Object)SMBAuthMethod.SPNEGO);
    }
}

