/*
 * Decompiled with CFR 0.152.
 */
package com.sos.yade.engine.commons.arguments.loaders.xml;

import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.xml.SOSXML;
import com.sos.yade.engine.commons.arguments.loaders.xml.YADEXMLArgumentsLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YADEXMLGeneralHelper {
    protected static void parse(YADEXMLArgumentsLoader argsLoader, Node general) throws Exception {
        if (general == null) {
            return;
        }
        NodeList nl = general.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "SystemPropertyFiles": {
                    YADEXMLGeneralHelper.parseSystemPropertyFiles(argsLoader, n);
                    continue block10;
                }
                case "Notifications": {
                    YADEXMLGeneralHelper.parseNotifications(argsLoader, n, general.getLocalName());
                    continue block10;
                }
                case "RetryOnConnectionError": {
                    YADEXMLGeneralHelper.parseRetryOnConnectionError(argsLoader, n);
                    continue block10;
                }
            }
        }
    }

    public static void parseSystemPropertyFiles(YADEXMLArgumentsLoader argsLoader, Node systemPropertyFiles) {
        NodeList nl = systemPropertyFiles.getChildNodes();
        if (nl == null) {
            return;
        }
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"SystemPropertyFile".equals(n.getNodeName())) continue;
            files.add(Path.of(argsLoader.getValue(n), new String[0]));
        }
        if (files.size() > 0) {
            argsLoader.getClientArgs().getSystemPropertyFiles().setValue(files);
        }
    }

    public static void parseNotifications(YADEXMLArgumentsLoader argsLoader, Node notifications, String parentInfo) throws Exception {
        argsLoader.initializeNotificationArgsIfNull();
        NodeList nl = notifications.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "MailServerFragmentRef": {
                    YADEXMLGeneralHelper.parseMailServerFragmentRef(argsLoader, n, parentInfo);
                }
            }
        }
    }

    public static void parseMailServerFragmentRef(YADEXMLArgumentsLoader argsLoader, Node ref, String parentInfo) throws Exception {
        String exp = "Fragments/MailServerFragments/MailServerFragment[@name='" + SOSXML.getAttributeValue((Node)ref, (String)"ref") + "']";
        Node fragment = argsLoader.getXPath().selectNode(argsLoader.getRoot(), exp);
        if (fragment == null) {
            throw new SOSMissingDataException("[" + parentInfo + "][" + exp + "]referenced MailServerFragment not found");
        }
        NodeList nl = fragment.getChildNodes();
        int len = nl.getLength();
        if (len > 0) {
            block8: for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getNodeName()) {
                    case "MailHost": {
                        YADEXMLGeneralHelper.parseMailHost(argsLoader, n);
                        continue block8;
                    }
                    case "QueueDirectory": {
                        argsLoader.setStringArgumentValue(argsLoader.getNotificationArgs().getMailServer().getQueueDirectory(), n);
                    }
                }
            }
        }
    }

    public static void parseRetryOnConnectionError(YADEXMLArgumentsLoader argsLoader, Node retryOnConnectionError) throws Exception {
        NodeList nl = retryOnConnectionError.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "RetryCountMax": {
                    argsLoader.setIntegerArgumentValue(argsLoader.getSourceArgs().getConnectionErrorRetryCountMax(), n);
                    if (argsLoader.getTargetArgs() == null) continue block8;
                    argsLoader.getTargetArgs().getConnectionErrorRetryCountMax().setValue((Object)((Integer)argsLoader.getSourceArgs().getConnectionErrorRetryCountMax().getValue()));
                    continue block8;
                }
                case "RetryInterval": {
                    argsLoader.setStringArgumentValue(argsLoader.getSourceArgs().getConnectionErrorRetryInterval(), n);
                    if (argsLoader.getTargetArgs() == null) continue block8;
                    argsLoader.getTargetArgs().getConnectionErrorRetryInterval().setValue((Object)((String)argsLoader.getSourceArgs().getConnectionErrorRetryInterval().getValue()));
                }
            }
        }
    }

    private static void parseMailHost(YADEXMLArgumentsLoader argsLoader, Node mailHost) throws Exception {
        NodeList nl = mailHost.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "BasicConnection": {
                    YADEXMLGeneralHelper.parseMailHostBasicConnection(argsLoader, n);
                    continue block10;
                }
                case "BasicAuthentication": {
                    YADEXMLGeneralHelper.parseMailHostBasicAuthentication(argsLoader, n);
                    continue block10;
                }
                case "MailSettings": {
                    YADEXMLGeneralHelper.parseMailHostMailSettings(argsLoader, n);
                }
            }
        }
    }

    private static void parseMailHostBasicConnection(YADEXMLArgumentsLoader argsLoader, Node mailHostBasicConnection) throws Exception {
        NodeList nl = mailHostBasicConnection.getChildNodes();
        block10: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Hostname": {
                    argsLoader.getNotificationArgs().getMailServer().applyHostname(argsLoader.getValue(n));
                    continue block10;
                }
                case "Port": {
                    argsLoader.getNotificationArgs().getMailServer().applyPort(argsLoader.getValue(n));
                    continue block10;
                }
                case "ConnectTimeout": {
                    argsLoader.getNotificationArgs().getMailServer().applyConnectTimeout(argsLoader.getValue(n));
                }
            }
        }
    }

    private static void parseMailHostBasicAuthentication(YADEXMLArgumentsLoader argsLoader, Node mailHostBasicAuthentication) throws Exception {
        NodeList nl = mailHostBasicAuthentication.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "Account": {
                    argsLoader.getNotificationArgs().getMailServer().applyAccount(argsLoader.getValue(n));
                    continue block8;
                }
                case "Password": {
                    argsLoader.getNotificationArgs().getMailServer().applyPassword(argsLoader.getValue(n));
                }
            }
        }
    }

    private static void parseMailHostMailSettings(YADEXMLArgumentsLoader argsLoader, Node mailHostMailSettings) throws Exception {
        NodeList nl = mailHostMailSettings.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getNodeName()) {
                case "MailSetting": {
                    String name = argsLoader.getValue(n, "name");
                    String value = argsLoader.getValue(n);
                    argsLoader.getNotificationArgs().getMailServer().addMailSetting(name, value);
                }
            }
        }
    }
}

